/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.UnsupportedOperationException;

public abstract class AbstractPlatformPolicyFactory {
    private Object m_platformPolicy = null;

    protected Object getPlatformPolicy() {
        if (this.m_platformPolicy == null) {
            if (CicCommonSettings.isWindowsVista()) {
                this.m_platformPolicy = this.createWindowsVistaPolicy();
            } else if (CicCommonSettings.isWindows7()) {
                this.m_platformPolicy = this.createWindows7Policy();
            } else if (CicCommonSettings.isWindows8()) {
                this.m_platformPolicy = this.createWindows8Policy();
            } else if (CicCommonSettings.isWindows2008Server()) {
                this.m_platformPolicy = this.createWindows2008ServerPolicy();
            } else if (CicCommonSettings.isWindows2008ServerR2()) {
                this.m_platformPolicy = this.createWindows2008ServerR2Policy();
            } else if (CicCommonSettings.isWindows2012Server()) {
                this.m_platformPolicy = this.createWindows2012ServerPolicy();
            } else if (CicCommonSettings.isWindows()) {
                this.m_platformPolicy = this.createWindowsPolicy();
            } else if (CicCommonSettings.isLinux()) {
                this.m_platformPolicy = this.createLinuxPolicy();
            } else if (CicCommonSettings.isSolaris()) {
                this.m_platformPolicy = this.createSolarisPolicy();
            } else if (CicCommonSettings.isAix()) {
                this.m_platformPolicy = this.createAixPolicy();
            } else if (CicCommonSettings.isHpux()) {
                this.m_platformPolicy = this.createHpuxPolicy();
            } else if (CicCommonSettings.isMacOSX()) {
                this.m_platformPolicy = this.createMacOSXPolicy();
            } else if (CicCommonSettings.isZOS()) {
                this.m_platformPolicy = this.createZOSPolicy();
            } else if (CicCommonSettings.isOS400()) {
                this.m_platformPolicy = this.createOS400Policy();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this.m_platformPolicy;
    }

    protected Object createWindowsVistaPolicy() {
        return this.createWindowsPolicy();
    }

    protected Object createWindows2008ServerPolicy() {
        return this.createWindowsVistaPolicy();
    }

    protected Object createWindows7Policy() {
        return this.createWindows2008ServerPolicy();
    }

    protected Object createWindows8Policy() {
        return this.createWindows2008ServerPolicy();
    }

    protected Object createWindows2008ServerR2Policy() {
        return this.createWindows7Policy();
    }

    protected Object createWindows2012ServerPolicy() {
        return this.createWindows8Policy();
    }

    protected Object createWindowsPolicy() {
        throw new UnsupportedOperationException();
    }

    protected Object createLinuxPolicy() {
        throw new UnsupportedOperationException();
    }

    protected Object createSolarisPolicy() {
        return this.createLinuxPolicy();
    }

    protected Object createAixPolicy() {
        return this.createLinuxPolicy();
    }

    protected Object createHpuxPolicy() {
        return this.createLinuxPolicy();
    }

    protected Object createMacOSXPolicy() {
        return this.createLinuxPolicy();
    }

    protected Object createZOSPolicy() {
        return this.createLinuxPolicy();
    }

    protected Object createOS400Policy() {
        return this.createLinuxPolicy();
    }
}

