/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.repository.RepositoryPool;
import com.ibm.cic.common.core.internal.utils.CicParserUtils;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.repository.IZipFileHandler;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.downloads.IDownloader;
import com.ibm.cic.common.downloads.IFileContentInfo;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ZipFileHandler
implements IZipFileHandler {
    IFileContentInfo m_zipFileContentInfo;
    IDownloader m_downloader;
    File m_zipFile;
    File m_currentOutputFile = null;
    ZipOutputStream m_currentOutputStream = null;
    int m_writeOpenCount = 0;
    Set m_currentDeleteFileList = null;
    Set m_fileNames = null;
    private static final Logger log = Logger.getLogger(ZipFileHandler.class);

    public ZipFileHandler(IFileContentInfo fileInfo, IDownloader downloader) throws Exception {
        this.m_zipFileContentInfo = fileInfo;
        this.m_downloader = downloader;
    }

    public ZipFileHandler(File file) {
        this.m_zipFile = file;
    }

    public String toString() {
        return "Zip:'" + (this.exists() ? this.getFile().getName() : "null") + "' '" + this.getFile() + '\'';
    }

    @Override
    public ZipOutputStream startAddingFile(String fileName) throws IOException {
        ZipEntry zeDest = new ZipEntry(fileName);
        this.getCurrentOutputStream().putNextEntry(zeDest);
        this.deleteFile(fileName);
        return this.m_currentOutputStream;
    }

    @Override
    public void completeAddingFile() throws IOException {
        this.m_currentOutputStream.closeEntry();
    }

    @Override
    public boolean openToAddOrDeleteFiles() {
        if (this.m_writeOpenCount == 0) {
            this.m_currentOutputFile = this.getTempFile();
        }
        ++this.m_writeOpenCount;
        return true;
    }

    @Override
    public boolean deleteFiles(Set fileNames) {
        boolean return_value = true;
        if (!fileNames.isEmpty()) {
            if (this.m_currentDeleteFileList == null) {
                this.m_currentDeleteFileList = fileNames;
            } else {
                this.m_currentDeleteFileList.addAll(fileNames);
            }
            return_value = this.openToAddOrDeleteFiles();
            if (return_value) {
                return_value = this.close();
            }
        }
        return return_value;
    }

    @Override
    public boolean deleteFile(String fileName) {
        if (this.m_currentDeleteFileList == null) {
            this.m_currentDeleteFileList = new HashSet();
        }
        this.m_currentDeleteFileList.add(fileName);
        boolean return_value = this.openToAddOrDeleteFiles();
        if (return_value) {
            return_value = this.close();
        }
        return return_value;
    }

    @Override
    public boolean containsFile(String fileName) {
        return this.getFileNames().contains(fileName);
    }

    @Override
    public String getName() throws IOException {
        return this.getFile().getCanonicalPath();
    }

    @Override
    public File getFile() {
        if (!(this.m_zipFile != null && this.m_zipFile.exists() || this.m_zipFileContentInfo == null)) {
            try {
                this.m_zipFile = RepositoryPool.getDefault().getFileCacheManager().getFile(this.m_zipFileContentInfo, false, false, this.m_downloader, null);
            }
            catch (Exception exception) {}
        }
        return this.m_zipFile;
    }

    @Override
    public int size() {
        return this.getFileNames().size();
    }

    @Override
    public boolean delete() {
        return FileUtil.delete(this.getFile());
    }

    @Override
    public Set getFileNames() {
        if (this.m_fileNames == null) {
            this.m_fileNames = new HashSet();
            if (this.exists() && this.getFile().length() > 0L) {
                try {
                    ZipFile zf = new ZipFile(this.getFile());
                    Enumeration<? extends ZipEntry> names = zf.entries();
                    while (names.hasMoreElements()) {
                        ZipEntry entry = names.nextElement();
                        this.m_fileNames.add(entry.getName());
                    }
                    zf.close();
                }
                catch (ZipException zipException) {
                    log.warning(Messages.ZipFileHandler_FormatProblem, this.getFile().getName());
                }
                catch (IOException iOException) {
                    log.warning(Messages.ZipFileHandler_IOProblem, this.getFile().getName());
                }
            }
        }
        return this.m_fileNames;
    }

    @Override
    public boolean close() {
        boolean return_value = true;
        --this.m_writeOpenCount;
        if (this.m_writeOpenCount == 0 && this.m_currentOutputFile != null) {
            this.copyCurrentToTmp(this.m_currentDeleteFileList);
            this.m_currentDeleteFileList = null;
            try {
                this.closeCurrentOutputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            FileUtil.delete(this.getFile());
            if (return_value) {
                if (this.m_currentOutputFile.exists()) {
                    return_value = this.m_currentOutputFile.renameTo(this.getFile());
                }
                this.m_fileNames = null;
            }
            this.m_currentOutputFile = null;
        }
        return return_value;
    }

    @Override
    public IStatus export(String fileName, File destination) {
        IStatus return_value;
        block14: {
            return_value = Status.OK_STATUS;
            ZipFile zfi = null;
            try {
                try {
                    zfi = new ZipFile(this.getName());
                    ZipEntry entry = zfi.getEntry(fileName);
                    if (entry != null) {
                        boolean syncOnClose = true;
                        FileUtil.copyStream(entry.getSize(), zfi.getInputStream(entry), destination, syncOnClose, null);
                        break block14;
                    }
                    String msg = NLS.bind(Messages.Downloader_File_Does_Not_Exist, (Object)fileName);
                    log.debug(msg);
                    return_value = new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 6251, msg, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return_value = new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, "", (Throwable)e);
                    if (zfi == null) break block14;
                    try {
                        zfi.close();
                    }
                    catch (IOException e2) {
                        if (return_value.isOK()) {
                            e2.printStackTrace();
                            return_value = new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, "", (Throwable)e2);
                        }
                    }
                }
            }
            finally {
                block15: {
                    if (zfi != null) {
                        try {
                            zfi.close();
                        }
                        catch (IOException e) {
                            if (!return_value.isOK()) break block15;
                            e.printStackTrace();
                            return_value = new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, "", (Throwable)e);
                        }
                    }
                }
            }
        }
        return return_value;
    }

    private void copyCurrentToTmp(Set excluded) {
        block15: {
            if (this.exists()) {
                ZipInputStream zis = this.openReadStream(this.getFile());
                byte[] dataBuf = new byte[1024];
                try {
                    try {
                        ZipEntry zeSource;
                        while ((zeSource = zis.getNextEntry()) != null) {
                            int size;
                            if (excluded != null && excluded.contains(zeSource.getName())) continue;
                            ZipEntry zeDest = new ZipEntry(zeSource.getName());
                            this.getCurrentOutputStream().putNextEntry(zeDest);
                            while ((size = zis.read(dataBuf, 0, 1024)) != -1) {
                                this.m_currentOutputStream.write(dataBuf, 0, size);
                            }
                            this.completeAddingFile();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (zis == null) break block15;
                        try {
                            zis.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    if (zis != null) {
                        try {
                            zis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private File getTempFile() {
        File return_value = null;
        int i = 0;
        while (i < 10000 && return_value == null) {
            return_value = new File(this.getFile().getParentFile(), String.valueOf(this.getFile().getName()) + i);
            if (return_value.exists()) {
                return_value = null;
            }
            ++i;
        }
        return return_value;
    }

    private ZipOutputStream getCurrentOutputStream() throws IOException {
        if (this.m_currentOutputStream == null && this.m_currentOutputFile != null) {
            this.m_currentOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.m_currentOutputFile)));
        }
        return this.m_currentOutputStream;
    }

    private void closeCurrentOutputStream() throws IOException {
        if (this.m_currentOutputStream != null) {
            this.m_currentOutputStream.close();
            this.m_currentOutputStream = null;
        }
    }

    private ZipInputStream openReadStream(File file) {
        ZipInputStream return_value = null;
        try {
            return_value = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return return_value;
    }

    @Override
    public void dispose() {
    }

    @Override
    public IContent getIContentElement(String internalFileName) {
        IContent return_value = null;
        try {
            if (this.exists()) {
                ZipFile zfi = new ZipFile(this.getFile());
                ZipEntry ze = zfi.getEntry(internalFileName);
                if (ze != null) {
                    InputStream input = zfi.getInputStream(ze);
                    if (input != null) {
                        input = new BufferedInputStream(input);
                    }
                    return_value = CicParserUtils.getObjectFromStream(input, String.valueOf(internalFileName) + '@' + this.getFile().toString(), false);
                }
                zfi.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return return_value;
    }

    @Override
    public InputStream getInputStream(String relativePath) throws IOException {
        try (ZipFile zfi = new ZipFile(this.getFile());){
            InputStream entryStream = zfi.getInputStream(zfi.getEntry(relativePath));
            ByteArrayInputStream byteArrayInputStream = FileUtil.transferStreamToByteArrayInputStream(entryStream, (int)zfi.getEntry(relativePath).getSize());
            return byteArrayInputStream;
        }
    }

    @Override
    public boolean exists() {
        File f = this.getFile();
        return f != null && f.isFile();
    }

    @Override
    public synchronized boolean addFile(String targetFilePath, File fileToAdd) throws IOException {
        if (!this.openToAddOrDeleteFiles()) {
            return false;
        }
        try (FileInputStream ins = new FileInputStream(fileToAdd);){
            this.startAddingFile(targetFilePath.toString());
            try {
                FileUtil.transferStreams(ins, false, this.m_currentOutputStream, false);
            }
            finally {
                this.completeAddingFile();
            }
        }
        return this.close();
    }
}

