/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractContentLocator;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractPathReadArtifactRepository;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractWriteArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactFormatterUtil;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactToPathUtil;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.internal.artifactrepo.JarArtifactLocator;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IZipFileHandler;
import com.ibm.cic.common.core.repository.ZipRepository;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class ZipArtifactRepository
extends AbstractWriteArtifactRepo {
    private final AbstractPathReadArtifactRepository pathReadReposotory = new AbstractPathReadArtifactRepository(){

        @Override
        public IRepository getRepository() {
            return ZipArtifactRepository.this.getRepository();
        }

        @Override
        protected IPath getRepositoryPath(IArtifactKey key) throws CoreException {
            return ZipArtifactRepository.this.getArtifactPath(key);
        }

        @Override
        protected IPath getRepositoryPath() {
            return ZipArtifactRepository.this.getRepositoryPath();
        }
    };

    @Override
    public abstract ZipRepository getRepository();

    protected IPath getArtifactPath(IArtifactKey key) throws CoreException {
        IPath relPath = ArtifactToPathUtil.getUpdateSiteCompatiblePath(key);
        if (relPath == null) {
            String msg = NLS.bind((String)Messages.couldnt_determine_target_location, (Object)ArtifactFormatterUtil.toUserString(key));
            throw new CoreException((IStatus)Statuses.ERROR.get(9, msg, new Object[0]));
        }
        return relPath;
    }

    protected IPath getRepositoryPath() {
        return new Path(this.getRepository().getLocationStr());
    }

    protected void doRemoveArtifactFile(IArtifactLocator locator, IPath path, IProgressMonitor monitor) throws CoreException {
        IZipFileHandler zifh = this.getRepository().getArcHandler();
        HashSet<String> fileNames = new HashSet<String>();
        fileNames.add(path.toString());
        if (!zifh.deleteFiles(fileNames)) {
            String msg = NLS.bind((String)Messages.delete_file_failed, (Object)path.toString());
            throw new CoreException((IStatus)Statuses.ERROR.get(13, msg, new Object[0]));
        }
    }

    @Override
    public IStatus doGetArtifactLocator(IArtifactSession session, IArtifact artifact, IContentInfo tocContentInfo, IProgressMonitor monitor, IArtifactLocator[] result) {
        monitor.beginTask("", 1);
        try {
            IPath relPath = ArtifactToPathUtil.getUpdateSiteCompatiblePath(artifact);
            String artifactFile = relPath.toString();
            SimpleContentInfo contentInfo = tocContentInfo != null ? new SimpleContentInfo(tocContentInfo) : new SimpleContentInfo();
            IArtifact artifactForLocator = AbstractWriteArtifactRepo.getArtifactForToc(artifact, contentInfo);
            JarArtifactLocator locator = new JarArtifactLocator(this.getRepository(), artifactForLocator, artifact.getContentInfo(), artifactFile);
            result[0] = locator;
            monitor.worked(1);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected IStatus doAddArtifact(IArtifactSession session, IArtifact artifact, IContentLocator sourceLocator, IProgressMonitor monitor, IArtifactLocator[] outTargetLocator) {
        IPath targetPath;
        try {
            targetPath = this.getArtifactPath(artifact.getKey());
        }
        catch (CoreException e) {
            return this.createAddArtifactError(artifact, e.getStatus());
        }
        File tempFile = null;
        try {
            boolean addStatus;
            tempFile = AbstractContentLocator.createTempFile(artifact.getKey());
            IDownloadedFile dl = sourceLocator.downloadToFile(session, (IPath)new Path(tempFile.toString()), monitor);
            ICicStatus status = dl.getStatus();
            if (status.matches(8)) {
                ICicStatus iCicStatus = status;
                return iCicStatus;
            }
            if (!status.isOK()) {
                session.log(status);
                if (status.matches(4)) {
                    IStatus iStatus = this.createAddArtifactError(artifact, status);
                    return iStatus;
                }
            }
            if (!(addStatus = this.addToArc(targetPath, tempFile))) {
                status = this.createAddArtifactError(artifact, status);
            }
            if (outTargetLocator == null) {
                ICicStatus iCicStatus = status;
                return iCicStatus;
            }
            ArrayList<IStatus> statusKeep = new ArrayList<IStatus>();
            statusKeep.add(status);
            SimpleContentInfo outContentInfo = new SimpleContentInfo();
            String[] digests = this.getTocPreferredDigests(session, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
            IStatus statusCompute = AbstractContentLocator.computeOutContentInfo(status, session, artifact, sourceLocator, dl, monitor, digests, outContentInfo);
            if (!statusCompute.isOK()) {
                statusKeep.add(statusCompute);
            }
            if (statusCompute.matches(4)) {
                statusKeep.add(status);
                IStatus iStatus = this.createAddArtifactError(artifact, statusKeep.toArray(new IStatus[statusKeep.size()]));
                return iStatus;
            }
            if (statusCompute.matches(8)) {
                IStatus iStatus = statusCompute;
                return iStatus;
            }
            IArtifact artifactForToc = this.getArtifactForTocLogIssues(artifact, sourceLocator, dl, targetPath, outContentInfo);
            JarArtifactLocator target = new JarArtifactLocator(this.getRepository(), artifactForToc, artifact.getContentInfo(), targetPath.toString());
            outTargetLocator[0] = target;
            ICicStatus iCicStatus = status;
            return iCicStatus;
        }
        catch (IOException e) {
            IStatus iStatus = this.createAddArtifactError(artifact, e);
            return iStatus;
        }
        catch (CoreException e) {
            IStatus iStatus = this.createAddArtifactError(artifact, e.getStatus());
            return iStatus;
        }
        finally {
            if (tempFile != null) {
                FileUtil.rm(tempFile);
            }
        }
    }

    private synchronized boolean addToArc(IPath targetPath, File tempFile) throws FileNotFoundException, IOException {
        FileInputStream ins = new FileInputStream(tempFile);
        IZipFileHandler zifh = this.getRepository().getArcHandler();
        boolean addStatus = zifh.openToAddOrDeleteFiles();
        if (addStatus) {
            int num;
            byte[] buf = new byte[1024];
            ZipOutputStream zout = zifh.startAddingFile(targetPath.toString());
            while ((num = ((InputStream)ins).read(buf, 0, 1024)) != -1) {
                zout.write(buf, 0, num);
            }
            zifh.completeAddingFile();
            addStatus = zifh.close();
        }
        ((InputStream)ins).close();
        return addStatus;
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.pathReadReposotory.readArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) {
        return this.pathReadReposotory.readCachedArtifactToc(session, tocCache, monitor);
    }

    @Override
    protected IStatus doRemoveArtifact(IArtifactSession session, IArtifactLocator locator, IProgressMonitor monitor) {
        try {
            IPath targetPath = this.getArtifactPath(locator.getArtifactKey());
            this.doRemoveArtifactFile(locator, targetPath, monitor);
        }
        catch (CoreException e) {
            return this.createRemoveArtifactError(locator.getArtifactKey(), e.getStatus(), null);
        }
        return Status.OK_STATUS;
    }
}

