/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.repository.RepositoryList;
import com.ibm.cic.common.core.internal.repository.RepositoryPool;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreDebugOptions;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreTrace;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.internal.CicResolver;
import com.ibm.cic.common.core.model.proxy.IOfferingReference;
import com.ibm.cic.common.core.model.proxy.OfferingReference;
import com.ibm.cic.common.core.repository.AbstractArtifactRepositoryGroup;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryCollection;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IRepositoryPool;
import com.ibm.cic.common.core.repository.RepositoryDescriptor;
import com.ibm.cic.common.core.repository.RepositorySiteProperties;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.SliceUtils;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestRepositoryData;
import com.ibm.cic.common.core.repository.listeners.IRepositoryGroupEventListener;
import com.ibm.cic.common.core.repository.listeners.IRepositoryPropertyEventListener;
import com.ibm.cic.common.core.repository.listeners.RepositoryGroupEvent;
import com.ibm.cic.common.core.repository.listeners.RepositoryGroupEventAdd;
import com.ibm.cic.common.core.repository.listeners.RepositoryGroupEventRemove;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserNames;
import com.ibm.cic.common.downloads.FileCacheManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class RepositoryGroup
implements IRepositoryGroup {
    private static RepositoryGroup m_defaultRSinstance;
    private IRepositoryPool m_pool;
    private final IRepositoryCollection m_repositories;
    private String m_groupName;
    private static final String DEFAULT_GROUP_NAME = "defaultGroupName";
    private static final String REPOSITORY_TYPE = "Group";
    private static final String REPOSITORY_VERSION = "0.0.0.1";
    private final IReadArtifactRepo readArtifactGroup = new AbstractArtifactRepositoryGroup(){

        @Override
        protected Collection getRepositories() {
            return RepositoryGroup.this.getRepositories();
        }

        @Override
        public IRepository getRepository() {
            return RepositoryGroup.this;
        }
    };
    private final HashSet m_listeners = new HashSet();
    private static final CicCommonCoreTrace m_sendEventTrace;
    private static final CicCommonCoreTrace m_recvEventTrace;

    static {
        m_sendEventTrace = new CicCommonCoreTrace(ComIbmCicCommonCorePlugin.getDefault(), CicCommonCoreDebugOptions.REPOSITORY_EVENT_SEND);
        m_recvEventTrace = new CicCommonCoreTrace(ComIbmCicCommonCorePlugin.getDefault(), CicCommonCoreDebugOptions.REPOSITORY_EVENT_RECEIVE);
    }

    public IRepositoryPool getPool() {
        if (this.m_pool == null) {
            this.m_pool = RepositoryPool.getDefault();
        }
        return this.m_pool;
    }

    @Override
    public boolean isOpen() {
        for (IRepository element : this) {
            IRepository rep = element;
            if (!rep.isOpen()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IStatus getStatus(boolean forceReEvaluation, IProgressMonitor progressMonitor) {
        MultiStatus return_value = new MultiStatus(ComIbmCicCommonCorePlugin.getPluginId(), 0, Messages.Repo_GroupStatus, null);
        Iterator<IRepository> iterator = this.iterator();
        while (iterator.hasNext()) {
            IRepository element;
            IRepository repo = element = iterator.next();
            return_value.add(repo.getStatus(forceReEvaluation, progressMonitor));
        }
        return return_value;
    }

    public RepositoryGroup(String groupName, IRepositoryCollection a_collection, IRepositoryPool a_pool) {
        this.m_groupName = groupName;
        this.m_repositories = a_collection;
        this.m_pool = a_pool;
    }

    public RepositoryGroup(String groupName) {
        this(groupName, new RepositoryList(), RepositoryPool.getDefault());
    }

    public String toString() {
        return this.m_groupName;
    }

    @Override
    public void setOpen(boolean isOpened) {
        for (IRepository element : this) {
            element.setOpen(isOpened);
        }
    }

    @Override
    public IStatus canAddExistingRepository(String serializedRepInfo, IProgressMonitor monitor) {
        IRepositoryInfo repInfo = this.createRepositoryInfo(null, null, null, null, serializedRepInfo);
        IStatus return_value = this.canAddExistingRepository(repInfo, monitor);
        return return_value;
    }

    @Override
    public IRepository addExistingRepository(String serializedRepInfo, boolean findPriorityBasedLocation) {
        IRepository return_value = null;
        IRepositoryInfo repInfo = this.createRepositoryInfo(null, null, null, null, serializedRepInfo);
        try {
            return_value = this.addExistingRepository(repInfo, findPriorityBasedLocation);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return return_value;
    }

    @Override
    public IRepository addExistingRepository(IRepositoryInfo repInfo, boolean findPriorityBasedLocation) throws CoreException, IOException {
        IRepository return_value = null;
        if (repInfo != null && (return_value = this.findRepository(repInfo)) == null && (return_value = this.getPool().addExistingRepository(repInfo, findPriorityBasedLocation)) != null) {
            this.addRepositoryToCollection(return_value, findPriorityBasedLocation);
        }
        return return_value;
    }

    @Override
    public IRepository addExistingRepository(IRepository repo, boolean findPriorityBasedLocation) {
        IRepository return_value = null;
        if (repo != null && (return_value = this.findRepository(repo.getRepositoryInfo())) == null && (return_value = this.getPool().addExistingRepository(repo, findPriorityBasedLocation)) != null) {
            this.addRepositoryToCollection(return_value, findPriorityBasedLocation);
        }
        return return_value;
    }

    @Override
    public IRepository addOrCreateRepository(IRepositoryInfo repInfo) throws CoreException, IOException {
        IRepository return_value = null;
        if (repInfo != null && (return_value = this.addExistingRepository(repInfo, false)) == null) {
            return_value = this.createRepository(repInfo);
        }
        return return_value;
    }

    @Override
    public IRepository createRepository(IRepositoryInfo repInfo) throws CoreException, IOException {
        IRepository return_value = this.getPool().createRepository(repInfo);
        if (return_value != null) {
            this.addRepositoryToCollection(return_value, true);
        }
        return return_value;
    }

    @Override
    public IRepository findRepository(IRepositoryInfo repositoryInfo) {
        return this.m_repositories.findRepository(repositoryInfo);
    }

    @Override
    public RepositoryDescriptor findRepositoryDescriptor(IRepositoryInfo rpInfo) {
        return this.getPool().findRepositoryDescriptor(rpInfo);
    }

    @Override
    public IRepositoryInfo createRepositoryInfo(String name, String type, String version, ICicLocation location, String specialSettings) {
        return this.getPool().createRepositoryInfo(name, type, version, location, specialSettings);
    }

    @Override
    public List<IOfferingReference> getAllOfferings(IProgressMonitor monitor) {
        return this.getAllOfferings(false, monitor);
    }

    @Override
    public List getAllOfferings(boolean includeUnavailable, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.size());
        ArrayList<IOfferingReference> return_value = new ArrayList<IOfferingReference>();
        HashSet<IIdentity> recommendedOfferingIds = new HashSet<IIdentity>();
        for (IRepository element : this) {
            IRepository rep = element;
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                List offerings = rep.getAllOfferings(includeUnavailable, (IProgressMonitor)sm.newChild(1));
                if (sm.isCanceled()) break;
                for (IOffering offering : offerings) {
                    IOfferingReference other;
                    IOfferingReference oRef = offering instanceof IOfferingReference ? (IOfferingReference)offering : new OfferingReference(offering);
                    int index = return_value.indexOf(oRef);
                    if (index >= 0 && SliceUtils.isMoreApplicable(oRef, other = (IOfferingReference)return_value.get(index))) {
                        return_value.set(index, oRef);
                    }
                    if (index >= 0) continue;
                    if (oRef.isRecommended() && !recommendedOfferingIds.add(oRef.getIdentity())) {
                        oRef.setRecommended(false);
                    }
                    return_value.add(oRef);
                }
                continue;
            }
            sm.worked(1);
        }
        return return_value;
    }

    @Override
    public List getAllUpdates(IIdentity offeringId, Version offeringVersion, IProgressMonitor monitor) {
        return this.getAllUpdates(false, offeringId, offeringVersion, monitor);
    }

    @Override
    public List getAllUpdates(boolean includeUnavailable, IIdentity offeringId, Version offeringVersion, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.size());
        ArrayList<IOfferingReference> return_value = new ArrayList<IOfferingReference>();
        HashSet<IIdentity> recommendedUpdateIds = new HashSet<IIdentity>();
        for (IRepository element : this) {
            IRepository rep = element;
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                List updates = rep.getAllUpdates(includeUnavailable, offeringId, offeringVersion, (IProgressMonitor)sm.newChild(1));
                if (sm.isCanceled()) break;
                for (IOffering update : updates) {
                    IOfferingReference oRef;
                    IOfferingReference iOfferingReference = oRef = update instanceof IOfferingReference ? (IOfferingReference)update : new OfferingReference(update);
                    if (return_value.contains(oRef)) continue;
                    if (oRef.isRecommended() && !recommendedUpdateIds.add(oRef.getIdentity())) {
                        oRef.setRecommended(false);
                    }
                    return_value.add(oRef);
                }
                continue;
            }
            sm.worked(1);
        }
        return return_value;
    }

    @Override
    public IStatus unsetUpdateOffering(IOffering updateOffering) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getAllFixes(IProgressMonitor monitor) {
        return this.getAllFixes(false, monitor);
    }

    @Override
    public List getAllFixes(boolean includeUnavailable, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.size());
        ArrayList<IFix> return_value = new ArrayList<IFix>();
        for (IRepository element : this) {
            IRepository rep = element;
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                List fixes = rep.getAllFixes(includeUnavailable, (IProgressMonitor)sm.newChild(1));
                if (sm.isCanceled()) break;
                for (IFix fix : fixes) {
                    if (return_value.contains(fix)) continue;
                    return_value.add(fix);
                }
                continue;
            }
            sm.worked(1);
        }
        return return_value;
    }

    @Override
    public List getAllAssemblies(IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.size());
        ArrayList<IAssembly> return_value = new ArrayList<IAssembly>();
        for (IRepository element : this) {
            IRepository rep = element;
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                List assemblies = rep.getAllAssemblies((IProgressMonitor)sm.newChild(1));
                if (sm.isCanceled()) break;
                for (IAssembly asm : assemblies) {
                    if (return_value.contains(asm)) continue;
                    return_value.add(asm);
                }
                continue;
            }
            sm.worked(1);
        }
        return return_value;
    }

    @Override
    public List getAllSus(IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.size());
        ArrayList<IShareableUnit> return_value = new ArrayList<IShareableUnit>();
        for (IRepository element : this) {
            IRepository rep = element;
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                List sus = rep.getAllSus((IProgressMonitor)sm.newChild(1));
                if (sm.isCanceled()) break;
                for (IShareableUnit su : sus) {
                    if (return_value.contains(su)) continue;
                    return_value.add(su);
                }
                continue;
            }
            sm.worked(1);
        }
        return return_value;
    }

    @Override
    public List getAllSuFragments(IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.size());
        ArrayList<ISuFragment> return_value = new ArrayList<ISuFragment>();
        for (IRepository element : this) {
            IRepository rep = element;
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                List sus = rep.getAllSuFragments((IProgressMonitor)sm.newChild(1));
                if (sm.isCanceled()) break;
                for (ISuFragment suFragment : sus) {
                    if (return_value.contains(suFragment)) continue;
                    return_value.add(suFragment);
                }
                continue;
            }
            sm.worked(1);
        }
        return return_value;
    }

    @Override
    public List getAllIus(IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.size());
        ArrayList<IInstallableUnit> return_value = new ArrayList<IInstallableUnit>();
        for (IRepository element : this) {
            IRepository rep = element;
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                List ius = rep.getAllIus((IProgressMonitor)sm.newChild(1));
                if (sm.isCanceled()) break;
                for (IInstallableUnit iu : ius) {
                    if (return_value.contains(iu)) continue;
                    return_value.add(iu);
                }
                continue;
            }
            sm.worked(1);
        }
        return return_value;
    }

    @Override
    public List getAllShareableEntities(IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.size());
        ArrayList<IShareableEntity> return_value = new ArrayList<IShareableEntity>();
        for (IRepository element : this) {
            IRepository rep = element;
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                List ses = rep.getAllShareableEntities((IProgressMonitor)sm.newChild(1));
                if (sm.isCanceled()) break;
                for (IShareableEntity se : ses) {
                    if (return_value.contains(se)) continue;
                    return_value.add(se);
                }
                continue;
            }
            sm.worked(1);
        }
        return return_value;
    }

    @Override
    public List getAllContentElements(IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Monitor_getAllContentElements, (int)this.size());
        ArrayList<IContent> return_value = new ArrayList<IContent>();
        for (IRepository element : this) {
            IRepository rep = element;
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                List contentElems = rep.getAllContentElements((IProgressMonitor)sm.newChild(1));
                if (sm.isCanceled()) break;
                for (IContent ce : contentElems) {
                    if (return_value.contains(ce)) continue;
                    return_value.add(ce);
                }
                continue;
            }
            sm.worked(1);
        }
        return return_value;
    }

    @Override
    public Iterator<IRepository> iterator() {
        return this.getRepositories().iterator();
    }

    @Override
    public IOffering findOffering(IIdentity id, Version version, IProgressMonitor monitor) {
        return this.findOffering(false, id, version, monitor);
    }

    @Override
    public IOffering findOffering(boolean includeUnavailable, IIdentity id, Version version, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Monitor_findOffering, (int)this.size());
        IOffering return_value = null;
        Iterator<IRepository> I = this.iterator();
        while (I.hasNext() && return_value == null) {
            IRepository rep = I.next();
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                return_value = rep.findOffering(includeUnavailable, id, version, (IProgressMonitor)sm.newChild(1));
            } else {
                sm.worked(1);
            }
            if (sm.isCanceled()) break;
        }
        return return_value;
    }

    @Override
    public IOffering findUpdate(IIdentity id, Version version, IProgressMonitor monitor) {
        return this.findUpdate(false, id, version, monitor);
    }

    @Override
    public IOffering findUpdate(boolean includeUnavailable, IIdentity id, Version version, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Monitor_findUpdate, (int)this.size());
        IOffering return_value = null;
        Iterator<IRepository> I = this.iterator();
        while (I.hasNext() && return_value == null) {
            IRepository rep = I.next();
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                return_value = rep.findUpdate(includeUnavailable, id, version, (IProgressMonitor)sm.newChild(1));
            } else {
                sm.worked(1);
            }
            if (sm.isCanceled()) break;
        }
        return return_value;
    }

    @Override
    public IFix findFix(IIdentity id, Version version, IProgressMonitor monitor) {
        return this.findFix(false, id, version, monitor);
    }

    @Override
    public IFix findFix(boolean includeUnavailable, IIdentity id, Version version, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Monitor_findFix, (int)this.size());
        IFix return_value = null;
        Iterator<IRepository> I = this.iterator();
        while (I.hasNext() && return_value == null) {
            IRepository rep = I.next();
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                return_value = rep.findFix(includeUnavailable, id, version, (IProgressMonitor)sm.newChild(1));
            } else {
                sm.worked(1);
            }
            if (sm.isCanceled()) break;
        }
        return return_value;
    }

    @Override
    public IShareableEntity findShareableEntity(IIdentity id, Version version, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Monitor_findShareableEntity, (int)this.size());
        IShareableEntity return_value = null;
        Iterator<IRepository> I = this.iterator();
        while (I.hasNext() && return_value == null) {
            IRepository rep = I.next();
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                return_value = rep.findShareableEntity(id, version, (IProgressMonitor)sm.newChild(1));
            } else {
                sm.worked(1);
            }
            if (sm.isCanceled()) break;
        }
        return return_value;
    }

    @Override
    public List getShareableEntities(IIdentity id, Version version, VersionRange tolerance, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Monitor_getShareableEntities, (int)this.size());
        ArrayList<IShareableEntity> return_value = new ArrayList<IShareableEntity>();
        for (IRepository element : this) {
            IRepository rep = element;
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                List sEs = rep.getShareableEntities(id, version, tolerance, (IProgressMonitor)sm.newChild(1));
                if (sm.isCanceled()) break;
                for (IShareableEntity se : sEs) {
                    if (return_value.contains(se)) continue;
                    return_value.add(se);
                }
                continue;
            }
            sm.worked(1);
        }
        return return_value;
    }

    @Override
    public IInstallableUnit findInstallableUnit(IIdentity id, Version version, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Monitor_findInstallableUnit, (int)this.size());
        IInstallableUnit return_value = null;
        Iterator<IRepository> I = this.iterator();
        while (I.hasNext() && return_value == null) {
            IRepository rep = I.next();
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                return_value = rep.findInstallableUnit(id, version, (IProgressMonitor)sm.newChild(1));
            } else {
                sm.worked(1);
            }
            if (sm.isCanceled()) break;
        }
        return return_value;
    }

    @Override
    public IAssembly findAssembly(IIdentity id, Version version, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Monitor_findAssembly, (int)this.size());
        IAssembly return_value = null;
        Iterator<IRepository> I = this.iterator();
        while (I.hasNext() && return_value == null) {
            IRepository rep = I.next();
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                return_value = rep.findAssembly(id, version, (IProgressMonitor)sm.newChild(1));
            } else {
                sm.worked(1);
            }
            if (sm.isCanceled()) break;
        }
        return return_value;
    }

    @Override
    public IShareableUnit findShareableUnit(IIdentity id, Version version, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Monitor_findShareableUnit, (int)this.size());
        IShareableUnit return_value = null;
        Iterator<IRepository> I = this.iterator();
        while (I.hasNext() && return_value == null) {
            IRepository rep = I.next();
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                return_value = rep.findShareableUnit(id, version, (IProgressMonitor)sm.newChild(1));
            } else {
                sm.worked(1);
            }
            if (sm.isCanceled()) break;
        }
        return return_value;
    }

    @Override
    public ISuFragment findSuFragment(IIdentity id, Version version, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Monitor_findSuFragment, (int)this.size());
        ISuFragment return_value = null;
        Iterator<IRepository> I = this.iterator();
        while (I.hasNext() && return_value == null) {
            IRepository rep = I.next();
            if (rep.isOpen() && rep.getStatus(false, (IProgressMonitor)sm).isOK()) {
                return_value = rep.findSuFragment(id, version, (IProgressMonitor)sm.newChild(1));
            } else {
                sm.worked(1);
            }
            if (sm.isCanceled()) break;
        }
        return return_value;
    }

    @Override
    public int size() {
        return this.m_repositories.size();
    }

    public Object getAdapter(Class adapter) {
        return this.readArtifactGroup.getAdapter(adapter);
    }

    @Override
    public boolean hasArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.readArtifactGroup.hasArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.readArtifactGroup.readArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return this.readArtifactGroup.getArtifactTocCapabilities();
    }

    @Override
    public IRepositoryInfo getRepositoryInfo() {
        return null;
    }

    @Override
    public String serializeRepositoryInfo() {
        return null;
    }

    @Override
    public Collection getRepositories() {
        return this.m_repositories.getAssignedRepositories();
    }

    @Override
    public IStatus deleteRepository(IRepository repository, boolean mustClear) {
        IStatus return_value = this.getPool().deleteRepository(repository, mustClear);
        if (return_value.isOK() && this.m_repositories.removeRepository(repository)) {
            this.publishEvent(new RepositoryGroupEventRemove(this, repository));
        }
        return return_value;
    }

    @Override
    public void removeAllRepositories() {
        Iterator<IRepository> iterator = this.iterator();
        while (iterator.hasNext()) {
            IRepository element;
            IRepository repo = element = iterator.next();
            this.getPool().removeRepository(repo);
            this.publishEvent(new RepositoryGroupEventRemove(this, repo));
        }
        this.m_repositories.removeAllRepositories();
    }

    private void addRepositoryToCollection(IRepository repository, boolean findPriorityBasedLocation) {
        this.m_repositories.addRepository(repository, findPriorityBasedLocation);
        this.publishEvent(new RepositoryGroupEventAdd(this, repository));
    }

    @Override
    public String getName() {
        return this.m_groupName;
    }

    @Override
    public boolean isWritable() {
        for (IRepository element : this) {
            IRepository rep = element;
            if (!rep.isWritable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setName(String name) {
        this.m_groupName = name;
    }

    @Override
    public void refresh() {
        Iterator<IRepository> iterator = this.iterator();
        while (iterator.hasNext()) {
            IRepository element;
            IRepository rep = element = iterator.next();
            rep.refresh();
        }
    }

    @Override
    public IContent refreshContent(IContent content) {
        IRepository repo;
        IContent return_value = content;
        if (return_value != null && (repo = content.getRepository()) != null) {
            return_value = repo.refreshContent(content);
        }
        return return_value;
    }

    @Override
    public boolean setManagedRepositoryGroupCaching(boolean enablePersistenceCache, boolean enableMemoryCache) {
        return this.getPool().setManagedRepositoryGroupCaching(enablePersistenceCache, enableMemoryCache);
    }

    @Override
    public boolean setRepositoryCaching(IRepositoryInfo repositoryInfo, boolean enablePersistenceCache, boolean enableMemoryCache) {
        return this.getPool().setRepositoryCaching(repositoryInfo, enablePersistenceCache, enableMemoryCache);
    }

    @Override
    public RepositoryDescriptor[] getRepositoryDescriptors() {
        return this.getPool().getRepositoryDescriptors();
    }

    @Override
    public IContent addContent(IContent content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus addContent(List contentList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus saveContent(IContent content) throws IOException {
        IRepository repo = content.getRepository();
        if (repo != null) {
            return repo.saveContent(content);
        }
        return RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_CANT_BE_SAVED;
    }

    @Override
    public IContent moveContent(IContent content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus canCreateRepository() {
        return RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY;
    }

    @Override
    public IStatus canAddExistingRepository(IProgressMonitor progressMonitor) {
        return Statuses.ERROR.get(6001, Messages.Repo_CantAddExistingRepository, new Object[0]);
    }

    @Override
    public IStatus resolve(IOfferingOrFix element, IProgressMonitor progressMonitor) {
        List ses = this.getAllShareableEntities(progressMonitor);
        return CicResolver.resolve(element, ses);
    }

    @Override
    public IStatus deleteContent(IContent content) throws IOException {
        IRepository repo = content.getRepository();
        if (repo != null) {
            return repo.deleteContent(content);
        }
        return RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_CANT_BE_DELETED;
    }

    @Override
    public IAssembly createAssembly(IIdentity id, Version version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IOffering createOffering(IIdentity id, Version version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFix createFix(IIdentity id, Version version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IShareableUnit createSu(IIdentity id, Version version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ISuFragment createSuFragment(IIdentity id, Version version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IInstallableUnit createIu(IIdentity id, Version version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus clear() {
        MultiStatus return_value = new MultiStatus(ComIbmCicCommonCorePlugin.getPluginId(), 0, Messages.Repo_RepositoryClearFailed, null);
        Iterator<IRepository> iterator = this.iterator();
        while (iterator.hasNext()) {
            IRepository element;
            IRepository rrepo = element = iterator.next();
            return_value.add(rrepo.clear());
        }
        return return_value;
    }

    @Override
    public IStatus delete(boolean mustClear) {
        MultiStatus return_value = new MultiStatus(ComIbmCicCommonCorePlugin.getPluginId(), 0, Messages.Repo_RepositoryRemoveFailed, null);
        Iterator<IRepository> iterator = this.iterator();
        while (iterator.hasNext()) {
            IRepository element;
            IRepository repository = element = iterator.next();
            IStatus rv = this.getPool().deleteRepository(repository, mustClear);
            return_value.add(rv);
            this.publishEvent(new RepositoryGroupEventRemove(this, repository));
        }
        this.m_repositories.removeAllRepositories();
        return return_value;
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    private void publishEvent(RepositoryGroupEvent event) {
        if (RepositoryGroup.m_sendEventTrace.enabled) {
            m_sendEventTrace.println("SENT:" + event.toString());
        }
        for (IRepositoryGroupEventListener listener : this.m_listeners) {
            if (event instanceof RepositoryGroupEventAdd) {
                if (RepositoryGroup.m_recvEventTrace.enabled) {
                    m_sendEventTrace.println("DELIVERING " + event.toString() + " TO:'" + listener.getClass().getName() + "#repositoryGroupEventAddOccurred()'");
                }
                listener.repositoryGroupEventAddOccurred((RepositoryGroupEventAdd)event);
                continue;
            }
            if (RepositoryGroup.m_recvEventTrace.enabled) {
                m_sendEventTrace.println("DELIVERING " + event.toString() + " TO:'" + listener.getClass().getName() + "#repositoryGroupEventRemoveOccurred()'");
            }
            listener.repositoryGroupEventRemoveOccurred((RepositoryGroupEventRemove)event);
        }
    }

    @Override
    public void registerListener(IRepositoryPropertyEventListener listener) {
        if (listener instanceof IRepositoryGroupEventListener) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void unregisterListener(IRepositoryPropertyEventListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public boolean containsMetadata() {
        for (IRepository element : this) {
            IRepository rrepo = element;
            if (!rrepo.containsMetadata()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsArtifacts() {
        for (IRepository element : this) {
            IRepository rrepo = element;
            if (!rrepo.containsArtifacts()) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStream getContentInputStream(IContent content) throws IOException {
        IRepository repo = content.getRepository();
        for (IRepository element : this) {
            IRepository rrepo = element;
            if (repo != rrepo) continue;
            return rrepo.getContentInputStream(content);
        }
        return null;
    }

    @Override
    public InputStream getInputStream(String relativePath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) throws CoreException {
        return this.readArtifactGroup.readCachedArtifactToc(session, tocCache, monitor);
    }

    @Override
    public IRepository getRepositoryReference() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRepositoryReference(IRepository repository) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canStoreArtifacts() {
        for (IRepository element : this) {
            IRepository rrepo = element;
            if (!rrepo.canStoreArtifacts()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canStoreMetadata() {
        for (IRepository element : this) {
            IRepository rrepo = element;
            if (!rrepo.canStoreMetadata()) continue;
            return true;
        }
        return false;
    }

    public static RepositoryGroup getDefault() {
        if (m_defaultRSinstance == null) {
            m_defaultRSinstance = new RepositoryGroup(DEFAULT_GROUP_NAME);
        }
        return m_defaultRSinstance;
    }

    @Override
    public IRepository removeRepository(IRepository repository) {
        boolean removed = this.m_repositories.removeRepository(repository);
        IRepository return_value = null;
        if (removed) {
            return_value = this.getPool().removeRepository(repository);
            this.publishEvent(new RepositoryGroupEventRemove(this, repository));
        }
        return return_value;
    }

    @Override
    public IStatus canAddExistingRepository(IRepositoryInfo repInfo, IProgressMonitor progressMonitor) {
        IStatus return_value = Status.OK_STATUS;
        if (this.findRepository(repInfo) == null) {
            return_value = this.getPool().canAddExistingRepository(repInfo, progressMonitor);
        }
        return return_value;
    }

    protected void finalize() throws Throwable {
        this.removeAllRepositories();
    }

    @Override
    public FileCacheManager getFileCacheManager() {
        return this.getPool().getFileCacheManager();
    }

    @Override
    public IStatus isRepInfoMatchingRepositoryObject(IRepositoryInfo repInfo) {
        return this.findRepository(repInfo) != null ? Status.OK_STATUS : RepositoryStatus.ST_ERROR_REP_INFO_DOES_NOT_MATCH;
    }

    @Override
    public IStatus canCreateRepository(IRepositoryInfo repInfo) {
        return this.getPool().canCreateRepository(repInfo);
    }

    @Override
    public void moveDown(IRepository repository) {
        this.m_repositories.moveDown(repository);
    }

    @Override
    public void moveUp(IRepository repository) {
        this.m_repositories.moveUp(repository);
    }

    @Override
    public IContentRepository getContentRepository(IContent element) {
        IRepository repo;
        if (element != null && (repo = element.getRepository()) != null) {
            for (IRepository element2 : this) {
                IRepository rrepo = element2;
                if (repo != rrepo) continue;
                return repo.getContentRepository(element);
            }
        }
        return null;
    }

    @Override
    public UserNames getUserNames() {
        return new UserNames(this.getName(), null);
    }

    @Override
    public RepositorySiteProperties getSiteProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICicLocation getLocation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLocationStr() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType() {
        return REPOSITORY_TYPE;
    }

    @Override
    public String getVersion() {
        return REPOSITORY_VERSION;
    }

    @Override
    public IStatus updateRepositoryDigest(int a_request, IProgressMonitor progressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RepositoryDigestRepositoryData generateRepositoryDigestData(CicMultiStatus status, IProgressMonitor pm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RepositoryDigestRepositoryData getRepositoryDigestData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus importP2Repository(File p2RepositoryFile, IProgressMonitor progressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus deleteP2Repository(IProgressMonitor progressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus exportP2Repository(File destinationFile, IProgressMonitor progressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsP2Repository(IProgressMonitor monitor) {
        boolean return_value = false;
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, this.size());
        Iterator<IRepository> I = this.iterator();
        while (I.hasNext() && !return_value) {
            IRepository rrepo = I.next();
            if (!rrepo.containsP2Repository(pm.next())) continue;
            return_value = true;
        }
        pm.done();
        return return_value;
    }

    @Override
    public IStatus addNLSFile(String fileName, InputStream source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus deleteNLSFile(String fileName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getNLSFileList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream openNLSFileStream(String fileName) {
        throw new UnsupportedOperationException();
    }
}

