/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.downloads.FileContentInfo;
import com.ibm.cic.common.core.internal.repository.RepositoryPool;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.preferences.CicAbstractPreferenceHandler;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.preferences.CicDirPreferenceHandler;
import com.ibm.cic.common.core.preferences.CicLocationPreferenceHandler;
import com.ibm.cic.common.core.preferences.ICicPreferenceHandler;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.LayoutPolicy;
import com.ibm.cic.common.core.repository.RepositorySiteProperties;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.digest.RepositoryDigest;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestRepositoryData;
import com.ibm.cic.common.core.repository.nls.ContentResourceManager;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.SortedProperties;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.FileCacheManager;
import com.ibm.cic.common.downloads.IDownloader;
import com.ibm.cic.common.downloads.IFileContentInfo;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;
import org.xml.sax.InputSource;

public class RepositoryFileBasedSiteProperties
extends RepositorySiteProperties {
    private static final String SUB_PREF_HANDLER = "CHILD_PREF_";
    private static final String REPOSITORY_URL = "repository.url.";
    public static final String REP_CONFIG_FILE = "repository.config";
    public static final Set<String> REP_MAIN_SITE_PROPERTY_FILES = new LinkedHashSet<String>(Arrays.asList("repository.xml", "repository.config"));
    private final Set<String> m_allSitePropertyFiles;
    private final Map<String, ICicPreferenceHandler> m_childPreferences = new HashMap<String, ICicPreferenceHandler>();
    protected String m_outputFileName = "repository.config";
    private final LayoutPolicy m_layoutPolicy;
    protected static final Logger log = Logger.getLogger(RepositoryFileBasedSiteProperties.class);
    protected final FileCacheManager fcm = RepositoryPool.getDefault().getFileCacheManager();
    protected RepositoryDigest m_repDigest;

    public RepositoryFileBasedSiteProperties(LayoutPolicy layoutPolicy) {
        this.m_layoutPolicy = layoutPolicy;
        this.m_allSitePropertyFiles = new HashSet<String>(REP_MAIN_SITE_PROPERTY_FILES);
        this.m_repDigest = new RepositoryDigest(this);
    }

    LayoutPolicy getLayoutPolicy() {
        return this.m_layoutPolicy;
    }

    @Override
    public RepositoryDigest getRepositoryDigest() {
        return this.m_repDigest;
    }

    @Override
    public RepositoryDigestRepositoryData getThisRepositoryDigestData() {
        return this.getRepositoryDigest().getThisRepositoryData();
    }

    @Override
    public IStatus exists(boolean reReadProperties, IStatus current_status, IDownloader downloader, IProgressMonitor progressMonitor) {
        IStatus return_value = current_status;
        if (reReadProperties || !this.isInitialized()) {
            return_value = this.load(downloader, progressMonitor);
        }
        if (return_value.isOK()) {
            return_value = this.checkProperties();
        }
        return return_value;
    }

    @Override
    public boolean isInitialized() {
        return !this.m_repDigest.isEmpty();
    }

    private IStatus checkProperties() {
        int index;
        Version repVersion;
        Version siteVersion;
        int compare;
        String policy = this.getProperty("LayoutPolicy");
        if (!policy.equals(this.m_layoutPolicy.getId())) {
            return new RepositoryStatus(RepositoryStatus.ST_ERROR_UNSUPPORTED_LAYOUT_POLICY, this.getRepository());
        }
        String version = this.getProperty("LayoutPolicyVersion");
        if (version.length() > 0 && (compare = (siteVersion = new Version(version)).compareTo(repVersion = new Version(this.m_layoutPolicy.getVersion()))) > 0) {
            return new RepositoryStatus(RepositoryStatus.ST_ERROR_UNSUPPORTED_LAYOUT_POLICY_VERSION, this.getRepository());
        }
        String repositoryStatus = this.getProperty("RepositoryStatus");
        if (repositoryStatus.length() > 0 && (index = repositoryStatus.indexOf(58)) != -1) {
            String status = repositoryStatus.substring(0, index);
            String msg = repositoryStatus.substring(index + 1);
            this.getRepository().getRepositoryInfo().setRepositoryReportedStatus(status, this.resolveNL(msg));
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isSitePropertyFile(String name) {
        return this.m_allSitePropertyFiles.contains(name);
    }

    @Override
    public void clear() {
        this.m_repDigest.clear();
        this.m_childPreferences.clear();
    }

    private void load(InputStream in) throws IOException {
        SortedProperties properties = new SortedProperties();
        properties.load(in);
        Enumeration en = properties.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (key.startsWith(REPOSITORY_URL)) {
                this.getThisRepositoryDigestData().getRepositoryDigestData(null, properties.getProperty(key));
                continue;
            }
            this.getProperties().setProperty(key, properties.getProperty(key));
            if (!key.startsWith(SUB_PREF_HANDLER)) continue;
            this.m_allSitePropertyFiles.add(properties.getProperty(key));
        }
    }

    private InputStream getInputStream(File a_file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(a_file));
    }

    @Override
    public IStatus load(IDownloader downloader, IProgressMonitor progressMonitor) {
        RepositoryStatus return_value = null;
        Status reportedStatus = null;
        if (!CicConstants.hasArchiveInPath(this.m_layoutPolicy.getFQTopBaseDirPath())) {
            for (String propName : REP_MAIN_SITE_PROPERTY_FILES) {
                if (!"repository.xml".equals(propName) || !CicCommonSettings.ignoreRepositoryDigest()) {
                    ICicLocation loc = this.getLocation(propName);
                    try {
                        return_value = this.load(propName, downloader, new FileContentInfo(loc), progressMonitor);
                    }
                    catch (FileNotFoundException e) {
                        log.debug(Messages.Repo_CantAccessOrParseRepositoryFile, loc, e);
                    }
                    catch (IOException e) {
                        log.debug(Messages.Repo_CantAccessOrParseRepositoryFile, loc, e);
                    }
                    catch (CoreException e) {
                        IStatus stat = e.getStatus();
                        if (stat.matches(8)) {
                            return_value = e.getStatus();
                        } else {
                            log.debug(Messages.Repo_CantAccessOrParseRepositoryFile, new Object[]{loc, e});
                            if (reportedStatus == null) {
                                reportedStatus = Statuses.ST.createMultiStatusFromStatus(stat);
                            } else {
                                ((CicMultiStatus)reportedStatus).add(stat);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.warning(Messages.Repo_CantAccessOrParseRepositoryFile, loc, e);
                        return_value = new RepositoryStatus(RepositoryStatus.ST_ERRORTEMPLT_CANT_ACCESS_REPOSITORY, this.getRepository());
                    }
                }
                if (return_value != null) break;
            }
        }
        if (return_value == null) {
            return_value = reportedStatus == null ? new RepositoryStatus(RepositoryStatus.ST_ERRORTEMPLT_CANT_ACCESS_REPOSITORY, this.getRepository()) : reportedStatus;
        }
        return return_value;
    }

    protected IStatus load(String propName, IDownloader downloader, IFileContentInfo finfo, IProgressMonitor progressMonitor) throws IOException, FileNotFoundException, Exception {
        IStatus return_value = null;
        if ("repository.xml".equals(propName)) {
            return_value = this.fcm.getRepositoryDigest(this.getRepositoryDigest(), finfo, false, true, downloader, progressMonitor);
            if (return_value == null || !return_value.isOK()) {
                return_value = null;
            } else {
                this.m_repDigest.getThisRepositoryData().setUseContentData(true);
            }
        } else {
            File file = this.fcm.getFile(finfo, false, true, downloader, progressMonitor);
            if (file != null && file.exists() && file.length() != 0L) {
                InputStream in = this.getInputStream(file);
                this.load(in);
                in.close();
                this.m_outputFileName = propName;
                return_value = Status.OK_STATUS;
            } else if (file != null && file.exists() && file.length() == 0L) {
                log.warning(NLS.bind((String)Messages.Repo_CantReadZeroLengthRepositoryFile, (Object)finfo.getFileLocation().toString()));
            }
        }
        return return_value;
    }

    protected IStatus load(String location, String propName, InputStream a_inputStream) throws IOException, FileNotFoundException {
        IStatus return_value;
        if ("repository.xml".equals(propName)) {
            InputSource inputSource = new InputSource(a_inputStream);
            inputSource.setSystemId(location);
            return_value = this.m_repDigest.load(inputSource);
            if (!return_value.isOK()) {
                return_value = null;
            } else {
                this.m_repDigest.getThisRepositoryData().setUseContentData(true);
            }
        } else {
            this.load(a_inputStream);
            this.m_outputFileName = propName;
            return_value = Status.OK_STATUS;
        }
        return return_value;
    }

    private ICicLocation getLocation(String filename) {
        String locationStr = this.m_layoutPolicy.getRepository().getLocationStr();
        if (!locationStr.startsWith("http")) {
            return this.m_layoutPolicy.getFQTopBaseDirPath().append(filename);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(locationStr);
        if (!locationStr.endsWith("/")) {
            buf.append("/");
        }
        buf.append(filename);
        Map map = this.getRepository().getRepositoryInfo().getProperties();
        Iterator iterator = map.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry me = iterator.next();
            Object key = me.getKey();
            Object obj = me.getValue();
            if (obj == null) {
                obj = "";
            }
            if (key instanceof String && obj instanceof String) {
                if (i == 0) {
                    buf.append("?");
                } else {
                    buf.append("&");
                }
                buf.append(key).append("=");
                buf.append(this.getEncodedString((String)obj));
            }
            ++i;
        }
        return new CicFileLocation(buf.toString());
    }

    private String getEncodedString(String val) {
        if (val != null) {
            try {
                return URLEncoder.encode(val, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return "";
    }

    @Override
    public LinkedProperties getProperties() {
        return this.m_repDigest.getThisRepositoryData().getProperties();
    }

    @Override
    public String removeProperty(String key) {
        return (String)this.getProperties().remove(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.getProperties().setProperty(key, value);
    }

    @Override
    public String getProperty(String a_id) {
        Set entrySet = this.getProperties().entrySet();
        for (Map.Entry entry : entrySet) {
            if (!((String)entry.getKey()).equalsIgnoreCase(a_id)) continue;
            return (String)entry.getValue();
        }
        return "";
    }

    @Override
    public String resolveNL(String a_str) {
        String return_value;
        if (this.isRepositoryDigestInUse()) {
            return_value = this.getThisRepositoryDigestData().resolveNL(a_str);
        } else {
            ContentResourceManager crm = new ContentResourceManager(this.m_layoutPolicy.getFQTopNLSPath().append("messages").toString());
            return_value = crm.getString(a_str, a_str);
        }
        return return_value;
    }

    protected void save(OutputStream out, String header) throws IOException {
        Properties refactoredProperties = new Properties();
        for (String key : this.getProperties().getPropertyKeysCollection()) {
            if (key.startsWith(REPOSITORY_URL)) continue;
            refactoredProperties.put(key, this.getProperties().get(key));
        }
        int i = 1;
        for (RepositoryDigestRepositoryData repData : this.getThisRepositoryDigestData().getRepositoryDigestList()) {
            refactoredProperties.put(REPOSITORY_URL + i++, repData.getLocation());
        }
        refactoredProperties.store(out, header);
    }

    @Override
    public IStatus save() {
        File dir;
        ICicLocation location = this.m_layoutPolicy.getFQTopBaseDirPath().append(this.m_outputFileName);
        File file = location.toFile();
        if (!(file.exists() || (dir = file.getParentFile()).exists() || dir.mkdirs())) {
            return RepositoryStatus.createErrorStatus(NLS.bind((String)Messages.RepositoryDigest_Cant_Write_To_File, (Object)this.m_outputFileName), 6253, log);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file.getCanonicalPath());
            this.save(out, null);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY;
        }
        this.fcm.removeCachedElement(location);
        return Status.OK_STATUS;
    }

    @Override
    IStatus canCreate() {
        for (String name : REP_MAIN_SITE_PROPERTY_FILES) {
            File file = this.m_layoutPolicy.getFQTopBaseDirPath().append(name).toFile();
            if (!file.exists()) {
                File dir = file.getParentFile();
                if (!dir.exists() && !dir.mkdirs()) {
                    return new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_CANT_CREATE_FILE, this.getRepository().getLocationStr(), dir.getAbsolutePath());
                }
                try {
                    if (file.createNewFile()) {
                        if (file.delete()) continue;
                        return new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_CANT_DELETE_FILE, this.getRepository().getLocationStr(), file.getAbsolutePath());
                    }
                    return new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_CANT_DELETE_FILE, this.getRepository().getLocationStr(), file.getAbsolutePath());
                }
                catch (IOException e) {
                    RepositoryStatus ret = new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_BECAUSE, this.getRepository().getLocationStr(), e.toString());
                    ret.setException(e);
                    return ret;
                }
            }
            return new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_ALREADY_EXISTS, file.getParentFile().getAbsolutePath());
        }
        return Status.OK_STATUS;
    }

    @Override
    public ICicPreferenceHandler getChildPreferenceHandler(String childHandlerId) {
        String fileName = this.getProperty(SUB_PREF_HANDLER + childHandlerId);
        if (fileName.length() > 0) {
            if (this.m_childPreferences.containsKey(fileName)) {
                return this.m_childPreferences.get(fileName);
            }
            ICicLocation location = this.getLocation(fileName);
            CicAbstractPreferenceHandler return_value = FileURLUtil.isURLString(location.toString(), true) ? new CicLocationPreferenceHandler(location.toURL()) : new CicDirPreferenceHandler(location.toString());
            if (!return_value.isValid()) {
                return_value = null;
            } else {
                this.m_childPreferences.put(fileName, return_value);
            }
            return return_value;
        }
        return super.getChildPreferenceHandler(childHandlerId);
    }

    @Override
    public void setChildPreference(String childHandlerId, String childHandlerFile) {
        this.setProperty(SUB_PREF_HANDLER + childHandlerId, childHandlerFile);
    }

    @Override
    public String getChildPreference(String childHandlerId) {
        return this.getProperty(SUB_PREF_HANDLER + childHandlerId);
    }

    @Override
    public IStatus deleteRepositoryDigest() {
        ICicLocation location = this.m_layoutPolicy.getFQTopBaseDirPath().append("repository.xml");
        File file = location.toFile();
        if (file.exists() && !file.delete()) {
            return RepositoryStatus.createErrorStatus(NLS.bind((String)Messages.FileLog_Failed_To_Delete, (Object)location.toString()), 6251, log);
        }
        this.m_repDigest.clearDigestInfo();
        this.m_repDigest.getThisRepositoryData().setUseContentData(false);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus saveRepositoryDigest(ICicLocation a_destLocation) {
        ICicLocation location = a_destLocation == null ? this.m_layoutPolicy.getFQTopBaseDirPath().append("repository.xml") : a_destLocation;
        IStatus return_value = this.m_repDigest.saveXML(location);
        if (return_value.isOK()) {
            this.m_repDigest.getThisRepositoryData().setUseContentData(true);
        }
        return return_value;
    }

    @Override
    public IRepository getRepository() {
        return this.m_layoutPolicy.getRepository();
    }

    @Override
    public boolean isRepositoryDigestInUse() {
        return this.m_repDigest.getThisRepositoryData().useContentData() && !CicCommonSettings.ignoreRepositoryDigest();
    }
}

