/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryCollection;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryTypePriority;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractRepositoryCollection
implements IRepositoryCollection {
    List m_containedRepositories;

    public AbstractRepositoryCollection(List repositories) {
        this.m_containedRepositories = repositories;
    }

    @Override
    public IRepository findRepository(IRepositoryInfo repInfo) {
        for (IRepository rr : this) {
            if (!rr.getLocation().equals(repInfo.getLocation()) || !rr.isRepInfoMatchingRepositoryObject(repInfo).isOK()) continue;
            repInfo.initializeFrom(rr.getRepositoryInfo());
            return rr;
        }
        return null;
    }

    @Override
    public void addRepository(IRepository newRepository, boolean findPriorityBasedLocation) {
        RepositoryTypePriority newRepPr = newRepository.getRepositoryInfo().getRepositoryDescriptor().getPriority();
        int index = 0;
        if (findPriorityBasedLocation) {
            for (IRepository repository : this) {
                RepositoryTypePriority repPr = repository.getRepositoryInfo().getRepositoryDescriptor().getPriority();
                if (newRepPr.compareTo(repPr) > 0) {
                    this.add(index, newRepository);
                    return;
                }
                ++index;
            }
        }
        this.add(newRepository);
    }

    @Override
    public boolean contains(Object o) {
        return this.m_containedRepositories.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.m_containedRepositories.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.m_containedRepositories.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.m_containedRepositories.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.m_containedRepositories.remove(o);
    }

    @Override
    public List getAssignedRepositories() {
        ArrayList<IRepository> return_value = new ArrayList<IRepository>();
        for (IRepository rep : this) {
            return_value.add(rep);
        }
        return return_value;
    }

    public IRepositoryInfo getRepositoryInfo() {
        return null;
    }

    @Override
    public int size() {
        return this.m_containedRepositories.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_containedRepositories.isEmpty();
    }

    public boolean containsAll(Collection c) {
        return this.m_containedRepositories.containsAll(c);
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        return this.m_containedRepositories.retainAll(c);
    }

    @Override
    public void clear() {
        this.m_containedRepositories.clear();
    }

    public boolean add(Object o) {
        boolean return_value = false;
        if (!(o instanceof IRepository)) {
            throw new UnsupportedOperationException();
        }
        IRepository repoRef = ((IRepository)o).getRepositoryReference();
        return_value = this.m_containedRepositories.add(repoRef);
        return return_value;
    }

    public void add(int index, Object element) {
        if (!(element instanceof IRepository)) {
            throw new UnsupportedOperationException();
        }
        IRepository repoRef = ((IRepository)element).getRepositoryReference();
        this.m_containedRepositories.add(index, repoRef);
    }

    @Override
    public boolean removeRepository(IRepository repository) {
        return this.remove(repository);
    }

    @Override
    public void removeAllRepositories() {
        this.m_containedRepositories.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            sb.append(o);
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void moveDown(IRepository repository) {
        int index = this.m_containedRepositories.lastIndexOf(repository);
        if (index < this.size() - 1) {
            this.m_containedRepositories.remove(index);
            this.m_containedRepositories.add(index + 1, repository);
        }
    }

    @Override
    public void moveUp(IRepository repository) {
        int index = this.m_containedRepositories.lastIndexOf(repository);
        if (index > 0) {
            this.m_containedRepositories.remove(index);
            this.m_containedRepositories.add(index - 1, repository);
        }
    }
}

