/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.preferences;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.preferences.UserContext;
import com.ibm.cic.common.core.preferences.CicSimplePreferenceHandler;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.preferences.ICicPreferenceHandler;
import com.ibm.cic.common.core.repository.RepositoryTypePriority;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;

public class CicPreferenceManager
extends ICicPreferenceConstants {
    private static final String PT_PREFERENCE_HANDLERS = "preferenceHandlers";
    private static final String ELEMENT_PRIORITY = "Priority";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String TRUE_STRING = "true";
    private static CicPreferenceManager m_instance = new CicPreferenceManager();
    private static final String ATTRIBUTE_CLASS = "class";
    private ICicPreferenceHandler m_defaultsPreferenceHandler;
    private ICicPreferenceHandler m_remotePreferenceHandler;
    private boolean m_explicitRemoteSet = false;
    private ICicPreferenceHandler m_currentPreferenceHandler;
    private boolean m_updatedDefaults;
    private boolean m_updatedCurrent;

    public CicPreferenceManager() {
        this.reset();
    }

    private void reset() {
        this.m_updatedDefaults = false;
        this.m_updatedCurrent = false;
    }

    public void setDefaultsPreferenceHandler(ICicPreferenceHandler prefHandler) {
        if (prefHandler != null) {
            this.m_defaultsPreferenceHandler = prefHandler;
            this.m_defaultsPreferenceHandler.init(this);
            this.reset();
            this.updateHandlers();
        }
    }

    public void setCurrentPreferenceHandler(ICicPreferenceHandler prefHandler) {
        if (prefHandler != null) {
            this.m_currentPreferenceHandler = prefHandler;
            this.m_currentPreferenceHandler.init(this);
            this.reset();
            this.updateHandlers();
        }
    }

    public ICicPreferenceHandler getDefaultsPreferenceHandler() {
        return this.m_defaultsPreferenceHandler;
    }

    public ICicPreferenceHandler getRemotePreferenceHandler() {
        return this.m_remotePreferenceHandler;
    }

    public ICicPreferenceHandler getCurrentPreferenceHandler() {
        return this.m_currentPreferenceHandler;
    }

    private boolean isReady(ICicPreferenceHandler prefHandler) {
        return prefHandler != null && prefHandler.isReady();
    }

    public static CicPreferenceManager getInstance() {
        return m_instance;
    }

    public static void setInstance(CicPreferenceManager prefManager) {
        m_instance = prefManager;
    }

    public ICicPreferenceHandler setTemporaryRemotePreferenceHandler(ICicPreferenceHandler a_tmpRemotePrefHandler, boolean a_createBackup) {
        if (a_tmpRemotePrefHandler == null) {
            if (a_createBackup) {
                this.m_currentPreferenceHandler.backup(this.m_remotePreferenceHandler);
            }
        } else {
            this.reset();
            if (this.m_currentPreferenceHandler != null) {
                this.m_currentPreferenceHandler.restoreBackup();
            }
            this.m_explicitRemoteSet = true;
            this.m_remotePreferenceHandler = a_tmpRemotePrefHandler;
            this.m_remotePreferenceHandler.init(this);
            if (a_createBackup) {
                this.m_currentPreferenceHandler.backup(this.m_remotePreferenceHandler);
            }
            this.updateHandlers();
        }
        return this.m_remotePreferenceHandler;
    }

    public ICicPreferenceHandler setTemporaryRemotePreferenceHandler(ICicPreferenceHandler a_tmpRemotePrefHandler) {
        return this.setTemporaryRemotePreferenceHandler(a_tmpRemotePrefHandler, true);
    }

    public ICicPreferenceHandler setRemotePreferenceHandler() {
        this.m_explicitRemoteSet = false;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(ComIbmCicCommonCorePlugin.getPluginId(), PT_PREFERENCE_HANDLERS);
        boolean prefHandlerUpdated = false;
        do {
            this.reset();
            String currentClassName = this.m_remotePreferenceHandler == null ? "" : this.m_remotePreferenceHandler.getClass().getName();
            RepositoryTypePriority highestPriority = RepositoryTypePriority.LOWEST;
            ICicPreferenceHandler newHandler = null;
            try {
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    String priority = element.getAttribute(ELEMENT_PRIORITY);
                    RepositoryTypePriority priorityType = RepositoryTypePriority.parse(priority);
                    if (priorityType.compareTo(highestPriority) >= 0) {
                        String className = element.getAttribute(ATTRIBUTE_CLASS);
                        if (className.equals(currentClassName)) {
                            prefHandlerUpdated = this.m_remotePreferenceHandler.refresh();
                            if (this.m_remotePreferenceHandler.isValid()) {
                                newHandler = this.m_remotePreferenceHandler;
                                highestPriority = priorityType;
                            }
                        } else {
                            ICicPreferenceHandler nextHandler = (ICicPreferenceHandler)element.createExecutableExtension(ATTRIBUTE_CLASS);
                            nextHandler.init(this);
                            if (nextHandler.isValid()) {
                                highestPriority = priorityType;
                                newHandler = nextHandler;
                                prefHandlerUpdated = true;
                            }
                        }
                    }
                    ++n2;
                }
                this.m_remotePreferenceHandler = newHandler;
                this.updateHandlers();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        } while (prefHandlerUpdated);
        return this.m_remotePreferenceHandler;
    }

    public String getDefaultString(String name) {
        return this.getDefaultsPreferenceHandler().getString(name);
    }

    public boolean isEditable(ICicPreferenceConstants.PreferenceTag tag) {
        boolean return_value = this.m_currentPreferenceHandler != null && this.m_currentPreferenceHandler.isSetEditable(tag.key()) ? this.m_currentPreferenceHandler.isEditable(tag) : this.m_defaultsPreferenceHandler.isEditable(tag);
        return return_value;
    }

    private boolean updateHandlers() {
        return this.updateDefaultFromRemote() && this.updateCurrentFromDefault();
    }

    private boolean updateDefaultFromRemote() {
        if (!this.m_updatedDefaults && this.isReady(this.m_defaultsPreferenceHandler) && this.isReady(this.m_remotePreferenceHandler)) {
            for (ICicPreferenceConstants.PreferenceTag tag : ICicPreferenceConstants.ALL_PREFERENCES) {
                if (this.m_remotePreferenceHandler.isSet(tag.key())) {
                    String val = this.m_remotePreferenceHandler.getString(tag.key());
                    if (val.length() > 0) {
                        CicPreferenceManager.copyPreferences(tag, this.m_remotePreferenceHandler, this.m_defaultsPreferenceHandler);
                    } else if (this.m_remotePreferenceHandler.isSet(tag.key())) {
                        this.m_defaultsPreferenceHandler.remove(tag);
                    }
                }
                if (!this.m_remotePreferenceHandler.isSetEditable(tag.key())) continue;
                boolean editable = this.m_remotePreferenceHandler.isEditable(tag);
                this.m_defaultsPreferenceHandler.setEditable(tag.key(), editable);
            }
            this.m_defaultsPreferenceHandler.save();
            this.m_updatedDefaults = true;
        }
        return this.m_updatedDefaults;
    }

    public void copyPreferences(ICicPreferenceHandler from, ICicPreferenceHandler to) {
        for (ICicPreferenceConstants.PreferenceTag tag : ICicPreferenceConstants.ALL_PREFERENCES) {
            CicPreferenceManager.copyPreferences(tag, from, to);
        }
    }

    private boolean updateCurrentFromDefault() {
        if (!this.m_updatedCurrent && this.isReady(this.m_defaultsPreferenceHandler) && this.isReady(this.m_currentPreferenceHandler)) {
            if (!this.m_explicitRemoteSet) {
                this.m_currentPreferenceHandler.restoreBackup();
            }
            for (ICicPreferenceConstants.PreferenceTag tag : ICicPreferenceConstants.ALL_PREFERENCES) {
                boolean editable;
                boolean isSet = this.m_defaultsPreferenceHandler.isSetEditable(tag.key());
                if (!isSet || (editable = this.m_defaultsPreferenceHandler.isEditable(tag))) continue;
                this.m_currentPreferenceHandler.remove(tag);
            }
            this.m_currentPreferenceHandler.save();
            this.m_updatedCurrent = true;
        }
        return this.m_updatedCurrent;
    }

    public static void copyPreferences(ICicPreferenceConstants.PreferenceTag prefTag, ICicPreferenceHandler from, ICicPreferenceHandler to) {
        to.remove(prefTag);
        String[] vals = from.getStringArray(prefTag.key());
        to.setValues(prefTag.key(), vals);
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            ICicPreferenceConstants.PreferenceTag[] preferenceTagArray = prefTag.subPrefs();
            int n3 = preferenceTagArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ICicPreferenceConstants.PreferenceTag subPref = preferenceTagArray[n4];
                ICicPreferenceConstants.ComposedPreferenceTag subTag = new ICicPreferenceConstants.ComposedPreferenceTag(prefTag, val, subPref);
                CicPreferenceManager.copyPreferences(subTag, from, to);
                ++n4;
            }
            ++n2;
        }
    }

    public boolean isReady() {
        return this.m_updatedCurrent && this.m_updatedDefaults;
    }

    IStatus getStatus() {
        if (!this.m_updatedDefaults) {
            return this.m_remotePreferenceHandler.getStatus();
        }
        if (!this.m_updatedCurrent) {
            return this.m_defaultsPreferenceHandler.getStatus();
        }
        return Status.OK_STATUS;
    }

    public String getString(String name) {
        return this.getString(name, "");
    }

    public String getString(String name, String defaultValue) {
        String return_value = this.m_currentPreferenceHandler != null && this.m_currentPreferenceHandler.isSet(name) ? this.m_currentPreferenceHandler.getString(name) : (this.m_defaultsPreferenceHandler != null && this.m_defaultsPreferenceHandler.isSet(name) ? this.m_defaultsPreferenceHandler.getString(name) : defaultValue);
        return return_value;
    }

    public void setValue(ICicPreferenceConstants.PreferenceTag tag, String value) {
        if (tag != null && value != null) {
            if (this.m_defaultsPreferenceHandler.getString(tag.key()).equals(value)) {
                this.m_currentPreferenceHandler.remove(tag);
            } else {
                this.m_currentPreferenceHandler.setValue(tag.key(), value);
            }
        }
    }

    public void setBoolean(ICicPreferenceConstants.PreferenceTag tag, boolean value) {
        if (tag != null) {
            if (this.m_defaultsPreferenceHandler.getBoolean(tag) == value) {
                this.m_currentPreferenceHandler.remove(tag);
            } else {
                this.m_currentPreferenceHandler.setValue(tag.key(), value);
            }
        }
    }

    public void setToDefault(ICicPreferenceConstants.PreferenceTag tag) {
        if (tag != null) {
            this.m_currentPreferenceHandler.remove(tag);
        }
    }

    public void addValue(ICicPreferenceConstants.PreferenceTag tag, String value) {
        if (tag != null && value != null) {
            if (this.m_currentPreferenceHandler.getString(tag.key()).length() == 0) {
                CicPreferenceManager.copyPreferences(tag, this.m_defaultsPreferenceHandler, this.m_currentPreferenceHandler);
            }
            this.m_currentPreferenceHandler.addValue(tag.key(), value);
        }
    }

    public void addFirstValue(ICicPreferenceConstants.PreferenceTag tag, String value) {
        if (tag != null && value != null) {
            if (this.m_currentPreferenceHandler.getString(tag.key()).length() == 0) {
                CicPreferenceManager.copyPreferences(tag, this.m_defaultsPreferenceHandler, this.m_currentPreferenceHandler);
            }
            this.m_currentPreferenceHandler.addFirstValue(tag, value);
        }
    }

    public void addFirstValue(ICicPreferenceConstants.PreferenceTag tag, String value, boolean isTemporary) {
        if (tag != null && value != null) {
            if (this.m_currentPreferenceHandler.getString(tag.key()).length() == 0) {
                CicPreferenceManager.copyPreferences(tag, this.m_defaultsPreferenceHandler, this.m_currentPreferenceHandler);
            }
            this.m_currentPreferenceHandler.addFirstValue(tag, value, isTemporary);
        }
    }

    public String[] getStringArray(String tag) {
        String[] return_value = this.m_currentPreferenceHandler.getStringArray(tag);
        if (return_value.length == 0 && !this.m_currentPreferenceHandler.isSet(tag)) {
            return_value = this.m_defaultsPreferenceHandler.getStringArray(tag);
        }
        return return_value;
    }

    public boolean getBoolean(String name) {
        return this.getString(name).equalsIgnoreCase(TRUE_STRING);
    }

    public void initializePreferenceHandlers(String bundleId) {
        String qualifier = bundleId;
        DefaultScope.INSTANCE.getNode(qualifier);
        CicPreferenceManager prefMan = CicPreferenceManager.getInstance();
        prefMan.setCurrentPreferenceHandler(new CicSimplePreferenceHandler(new UserContext(), qualifier));
        prefMan.setRemotePreferenceHandler();
    }

    public void removeBackup() {
        this.m_currentPreferenceHandler.removeBackup();
    }

    public boolean isSet(String name) {
        return this.m_currentPreferenceHandler != null && this.m_currentPreferenceHandler.isSet(name);
    }
}

