/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.validation;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IParseInfoStore;
import com.ibm.cic.common.core.model.internal.validation.Messages;
import com.ibm.cic.common.core.model.validation.ValidationService;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ValidationUtil {
    public static final String ANONYMOUS_CONTENT = "(anonymous)";
    public static final int IMMUTABLE_RULE = 0;
    private static final Logger log = Logger.getLogger(ValidationService.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    private static final String LINE_NUM_HOLDER = "_@_LINE_";
    private static final String URL_SEPARATOR = "_";
    private static final String EMPTY_STRING = "";
    private static final int LINE_NUM_HOLDER_LEN = "_@_LINE_".length();
    private static final String RULE_PREFIX = "[RULE-{0}] {1}";

    public static IStatus newWarningStatus(String msg, String pluginId, int rule) {
        msg = ValidationUtil.warning(msg, rule);
        return new Status(2, pluginId, rule, msg, null);
    }

    public static IStatus newFailedStatus(String msg, String pluginId, int rule) {
        msg = ValidationUtil.error(msg, rule);
        return new Status(4, pluginId, rule, msg, null);
    }

    public static IStatus newFailedStatus(String msg, String pluginId, Throwable reason) {
        msg = ValidationUtil.error(msg, 0);
        return new Status(4, pluginId, -1, msg, reason);
    }

    public static String error(String msg, int rule) {
        msg = ValidationUtil.prependRuleId(rule, msg);
        String errMsg = NLS.bind((String)Messages.ValidationUtil_ERROR, (Object)msg);
        log.debug(errMsg);
        return errMsg;
    }

    public static String warning(String msg, int rule) {
        msg = ValidationUtil.prependRuleId(rule, msg);
        String warnMsg = NLS.bind((String)Messages.ValidationUtil_WARNING, (Object)msg);
        log.debug(warnMsg);
        return warnMsg;
    }

    public static String formatMessage(String msg, Object[] args) {
        return MessageFormat.format(msg, args);
    }

    public static String formatMessage(String msg, Object arg) {
        return ValidationUtil.formatMessage(msg, new Object[]{arg});
    }

    public static String formatMessage(String msg, Object arg1, Object arg2) {
        return ValidationUtil.formatMessage(msg, new Object[]{arg1, arg2});
    }

    public static String formatMessage(String msg, Object arg1, Object arg2, Object arg3) {
        return ValidationUtil.formatMessage(msg, new Object[]{arg1, arg2, arg3});
    }

    public static String getContentName(IContent content) {
        return content.getName();
    }

    public static String getConentId(IContent content) {
        IIdentity identity = content.getIdentity();
        return identity != null ? identity.getId() : ANONYMOUS_CONTENT;
    }

    public static String getDisplayInfo(IContent content) {
        return String.valueOf(ValidationUtil.getSimpleName(content.getClass())) + content.getName();
    }

    private static String getSimpleName(Class klass) {
        String fullname = klass.getName();
        int lastDot = fullname.lastIndexOf(".");
        return String.valueOf(fullname.substring(lastDot + 1)) + " ";
    }

    public static String appendLineAndLocationToMessage(String msg, Object obj) {
        int line = -1;
        String url = null;
        if (obj instanceof IContent) {
            IContent content = (IContent)obj;
            ICicLocation location = content.getLocation();
            IRepository repo = content.getRepository();
            if (repo != null && location != null) {
                url = repo.getLocation().append(content.getLocation()).toString();
            }
        }
        if (obj instanceof IParseInfoStore) {
            line = ((IParseInfoStore)obj).getLineNumber();
        } else if (obj instanceof Integer) {
            line = (Integer)obj;
        }
        if (line > 0) {
            return String.valueOf(msg) + LINE_NUM_HOLDER + String.valueOf(line) + (url != null ? URL_SEPARATOR + url : EMPTY_STRING);
        }
        return msg;
    }

    public static String[] separateLineAndLocationFromMessage(String msg) {
        String[] result = new String[]{msg, null, null};
        int lineInfoPos = msg.indexOf(LINE_NUM_HOLDER);
        if (lineInfoPos >= 0) {
            result[0] = lineInfoPos == 0 ? EMPTY_STRING : msg.substring(0, lineInfoPos);
            String lineAndUrl = msg.substring(lineInfoPos + LINE_NUM_HOLDER_LEN);
            int urlSepPos = lineAndUrl.indexOf(URL_SEPARATOR);
            if (urlSepPos != -1) {
                result[1] = lineAndUrl.substring(0, urlSepPos);
                result[2] = lineAndUrl.substring(urlSepPos + 1);
            } else {
                result[1] = lineAndUrl;
            }
        }
        return result;
    }

    private static String prependRuleId(int rule, String msg) {
        return rule == 0 ? msg : ValidationUtil.formatMessage(RULE_PREFIX, String.valueOf(rule), msg);
    }

    public static boolean isRuleSuppressed(int rule) {
        return rule != 0 && !RuleFilter.isEnabled(rule);
    }

    private static class RuleFilter {
        private static String filterStr = null;
        private static Set filter;
        private static boolean exclusions;
        private static final String negation = "-";
        private static final char comma = ',';

        static {
            RuleFilter.refresh();
        }

        private RuleFilter() {
        }

        private static void refresh() {
            String input = UserOptions.getModelValidationFilter().trim();
            if (input.equals(filterStr)) {
                return;
            }
            exclusions = input.startsWith(negation);
            if (exclusions) {
                input = input.substring(1).trim();
            }
            filter = Util.toOrderedSet(input, ',', null);
            filterStr = input;
        }

        static boolean isEnabled(int rule) {
            RuleFilter.refresh();
            if (filter.isEmpty()) {
                return true;
            }
            boolean present = filter.contains(String.valueOf(rule));
            return exclusions ? !present : present;
        }
    }
}

