/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.validation;

import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.internal.validation.Messages;
import com.ibm.cic.common.core.model.internal.validation.ValidationMultiStatus;
import com.ibm.cic.common.core.model.internal.validation.ValidatorRegistry;
import com.ibm.cic.common.core.model.validation.IValidationEvent;
import com.ibm.cic.common.core.model.validation.IValidationListener;
import com.ibm.cic.common.core.model.validation.IValidator;
import com.ibm.cic.common.core.model.validation.ValidationCategory;
import com.ibm.cic.common.core.model.validation.ValidationUtil;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class ValidationService {
    public static final IProgressMonitor NULL_PROGRESS = new NullProgressMonitor();
    private final IRepositoryGroup repoSvc;
    private final EventManager eventManager = new EventManager();
    private static ValidationService theDefault = null;

    public ValidationService(IRepositoryGroup repoSvc) {
        this.repoSvc = repoSvc;
    }

    public static ValidationService getDefault() {
        if (theDefault == null) {
            theDefault = new ValidationService(RepositoryGroup.getDefault());
        }
        return theDefault;
    }

    public IStatus validate(IContent content) {
        return this.validate(content, ValidationCategory.getAll());
    }

    public IStatus validate(IContent content, IProgressMonitor progressMonitor) {
        return this.validate(content, ValidationCategory.getAll(), progressMonitor);
    }

    public IStatus validate(IContent[] contents, IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NULL_PROGRESS;
        }
        ValidationMultiStatus topLevelStatus = new ValidationMultiStatus();
        if (!ValidatorRegistry.INSTANCE.isEmpty()) {
            ValidationCategory[] categories = ValidationCategory.getAll();
            if (progressMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            boolean progressTaskStarted = false;
            if (progressMonitor != NULL_PROGRESS) {
                progressTaskStarted = this.initProgressMonitor(contents.length, categories, progressMonitor);
            }
            try {
                IContent[] iContentArray = contents;
                int n = contents.length;
                int n2 = 0;
                while (n2 < n) {
                    IContent content = iContentArray[n2];
                    if (progressMonitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    topLevelStatus.add(this.validate(content, categories, progressMonitor, progressTaskStarted));
                    ++n2;
                }
            }
            finally {
                if (progressTaskStarted) {
                    progressMonitor.done();
                }
            }
        }
        return topLevelStatus;
    }

    public IStatus validate(IContent content, ValidationCategory[] categories) {
        return this.validate(content, categories, NULL_PROGRESS);
    }

    public IStatus validate(IContent content, ValidationCategory[] categories, IProgressMonitor progressMonitor) {
        return this.validate(content, categories, progressMonitor, false);
    }

    private IStatus validate(IContent content, ValidationCategory[] categories, IProgressMonitor progressMonitor, boolean progressTaskAlreadyStarted) {
        if (progressMonitor == null) {
            progressMonitor = NULL_PROGRESS;
        }
        boolean progressTaskStartedLocally = false;
        ValidationMultiStatus topLevelStatus = new ValidationMultiStatus();
        if (!ValidatorRegistry.INSTANCE.isEmpty()) {
            if (progressMonitor != NULL_PROGRESS && !progressTaskAlreadyStarted) {
                progressTaskAlreadyStarted = progressTaskStartedLocally = this.initProgressMonitor(1, categories, progressMonitor);
            }
            try {
                ValidationCategory[] validationCategoryArray = categories;
                int n = categories.length;
                int n2 = 0;
                while (n2 < n) {
                    ValidationCategory category = validationCategoryArray[n2];
                    if (progressMonitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    topLevelStatus.add(this.validate(content, category, progressMonitor, progressTaskAlreadyStarted));
                    ++n2;
                }
            }
            finally {
                if (progressTaskStartedLocally) {
                    progressMonitor.done();
                }
            }
        }
        return topLevelStatus;
    }

    public IStatus validate(IContent content, ValidationCategory category) {
        return this.validate(content, category, NULL_PROGRESS);
    }

    public IStatus validate(IContent content, ValidationCategory category, IProgressMonitor progressMonitor) {
        return this.validate(content, category, progressMonitor, false);
    }

    private IStatus validate(IContent content, ValidationCategory category, IProgressMonitor progressMonitor, boolean progressTaskAlreadyStarted) {
        ValidationMultiStatus cumulativeStatus = new ValidationMultiStatus();
        List validators = ValidatorRegistry.INSTANCE.getValidators(category);
        boolean progressTaskStartedLocally = false;
        if (!progressTaskAlreadyStarted) {
            progressMonitor.beginTask(Messages.ValidationService_ProgressInvokingValidators, validators.size());
            progressTaskStartedLocally = true;
        }
        try {
            for (IValidator validator : validators) {
                String caption = ValidationUtil.formatMessage(Messages.ValidationService_ProgressInvoking, validator.getDisplayName());
                progressMonitor.subTask(caption);
                IStatus status = validator.validate(content, this.repoSvc, progressMonitor);
                cumulativeStatus.add(status);
                this.eventManager.notifyListeners(content, status);
                progressMonitor.worked(1);
                progressMonitor.subTask("");
            }
        }
        finally {
            progressMonitor.subTask("");
            if (progressTaskStartedLocally) {
                progressMonitor.done();
            }
        }
        return cumulativeStatus;
    }

    private boolean initProgressMonitor(int contentsCount, ValidationCategory[] categories, IProgressMonitor progressMonitor) {
        int workUnits = 0;
        StringBuffer categoryNames = new StringBuffer();
        ValidationCategory[] validationCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            ValidationCategory category = validationCategoryArray[n2];
            workUnits += ValidatorRegistry.INSTANCE.getValidators(category).size();
            if (categoryNames.length() > 0) {
                categoryNames.append(", ");
            }
            categoryNames.append(category.getName());
            ++n2;
        }
        if (workUnits == 0) {
            return false;
        }
        progressMonitor.beginTask(Messages.ValidationService_ProgressInvokingValidators, contentsCount * workUnits);
        return true;
    }

    public boolean hasValidationDone(IStatus status) {
        return status.getCode() != -1 && !this.hasValidationCancelled(status);
    }

    public boolean hasValidationPassed(IStatus status) {
        return status.isOK();
    }

    public boolean hasValidationCancelled(IStatus status) {
        return status.matches(8);
    }

    public void addListener(IValidationListener listener) {
        this.eventManager.addListener(listener);
    }

    public void removeListener(IValidationListener listener) {
        this.eventManager.removeListener(listener);
    }

    private static class EventManager {
        private List listeners = null;

        private EventManager() {
        }

        private void addListener(IValidationListener listener) {
            if (this.listeners == null) {
                this.listeners = new LinkedList();
            }
            if (listener != null) {
                this.listeners.add(listener);
            }
        }

        private void removeListener(IValidationListener listener) {
            if (this.listeners != null && listener != null) {
                this.listeners.remove(listener);
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
            }
        }

        private void notifyListeners(IContent content, IStatus status) {
            IValidationListener[] clients;
            if (this.listeners == null) {
                return;
            }
            IValidationEvent event = this.createEvent(content, status);
            IValidationListener[] iValidationListenerArray = clients = this.listeners.toArray(new IValidationListener[this.listeners.size()]);
            int n = clients.length;
            int n2 = 0;
            while (n2 < n) {
                IValidationListener client = iValidationListenerArray[n2];
                try {
                    client.validated(event);
                }
                catch (Throwable t) {
                    ExceptionUtil.debugLogToReview(t);
                }
                ++n2;
            }
        }

        private IValidationEvent createEvent(final IContent content, final IStatus status) {
            return new IValidationEvent(){

                @Override
                public IContent getValidatedElement() {
                    return content;
                }

                @Override
                public IStatus getValidationStatus() {
                    return status;
                }
            };
        }
    }
}

