/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.BaseEvaluationContext;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.ISuFragmentSelector;
import com.ibm.cic.common.core.model.PredefinedSelectors;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.MapSet;
import com.ibm.cic.common.core.utils.Util;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SelectorContext {
    private static final IStatus INFO_STATUS = new Status(1, ComIbmCicCommonCorePlugin.getPluginId(), null);
    private final MapSet<IShareableEntity, IContentSelector> context = MapSet.newLinkedHash();
    private final Set<IContentSelector> recursionGuard = new HashSet<IContentSelector>(4);
    private final Map<String, Set<String>> overrides;
    private boolean ignoringBundles = true;
    private boolean includeAllSuArtifacts = false;

    public SelectorContext() {
        this(null);
    }

    public SelectorContext(LinkedProperties overriddenPredefineds, boolean enableNonOverriddenPredefineds) {
        this(PredefinedSelectors.makeOverridesMap(overriddenPredefineds, enableNonOverriddenPredefineds));
    }

    public SelectorContext(IShareableEntity entity, Set<IContentSelector> selectors) {
        this(null);
        assert (selectors != null);
        this.select(entity, selectors);
    }

    public SelectorContext(IShareableEntity entity, Set<IContentSelector> selectors, LinkedProperties overriddenPredefineds, boolean enableNonOverriddenPredefineds) {
        this(overriddenPredefineds, enableNonOverriddenPredefineds);
        this.select(entity, selectors);
    }

    private SelectorContext(Map<String, Set<String>> overrides) {
        this.overrides = overrides;
    }

    public String toString() {
        return Util.toString(this.context.toMap(), new Util.MapFormatter(){

            @Override
            protected String emptyString() {
                return "<empty>";
            }

            @Override
            protected String formatKey(Object key) {
                return ((IShareableEntity)key).getIdentity().getId();
            }

            @Override
            protected String formatValue(Object value) {
                return Util.toSelectorIdString((Set)value);
            }
        });
    }

    public Set<IShareableEntity> getShareableEntities() {
        return this.context.keySet();
    }

    private IStatus getSelectedStatus(IShareableEntity se, IContentSelector selector) {
        if (this.getSelected(se).contains(selector)) {
            return this.ignoringBundles ? INFO_STATUS : Status.OK_STATUS;
        }
        return this.getSelectedStatus(se, selector.getExpression());
    }

    private IStatus getSelectedStatus(IShareableEntity se, ISelectionExpression expr) {
        if (expr == null) {
            return Status.CANCEL_STATUS;
        }
        return expr.evaluate(this.createEvaluationContext(se));
    }

    public boolean isSelected(IShareableEntity se, IContentSelector selector) {
        return this.isSelected(this.getSelectedStatus(se, selector));
    }

    public boolean isSelected(IShareableEntity se, ISelectionExpression expr) {
        return this.isSelected(this.getSelectedStatus(se, expr));
    }

    public boolean isSelected(IShareableUnit su, ISuFragment fragment, ISelectionExpression expr) {
        assert (su == null || fragment.getTargetId().equals(su.getIdentity()));
        return this.isSelected(expr.evaluate(this.createEvaluationContext(su, fragment)));
    }

    private boolean isSelected(IStatus status) {
        return status.isOK() || status.getSeverity() == 1;
    }

    public Set<IContentSelector> getSelected(IShareableEntity se) {
        return this.context.get(se);
    }

    public void select(IShareableEntity se, Set<IContentSelector> selectors) {
        this.context.addAll(se, selectors);
    }

    public void select(IShareableEntity se, IContentSelector selector) {
        this.context.add(se, selector);
    }

    public void deselect(IShareableEntity se, IContentSelector selector) {
        this.context.remove(se, selector);
    }

    public void setIgnoringBundles(boolean ignoringBundles) {
        this.ignoringBundles = ignoringBundles;
    }

    protected boolean isOverridingPredefineds() {
        return this.overrides != null;
    }

    protected IStatus evaluatePredefinedSelector(String selIdStr, String selValStr) {
        return SelectorContext.evaluatePredefinedSelector(this.overrides, this.ignoringBundles, selIdStr, selValStr);
    }

    public void setIncludeAllSuArtifacts(boolean includeAllSuArtifacts) {
        this.includeAllSuArtifacts = includeAllSuArtifacts;
    }

    public boolean includeAllSuArtifacts() {
        return this.includeAllSuArtifacts;
    }

    public static IStatus evaluatePredefinedSelector(Map<String, Set<String>> overrides, boolean ignoringBundles, String selIdStr, String selValStr) {
        Set<String> values = overrides.get(selIdStr);
        if (selIdStr.equals("isBeta") && selValStr == null) {
            selValStr = "true";
        }
        if (values.contains(selValStr) || PredefinedSelectors.matchesNL(selIdStr, values, selValStr)) {
            if (ignoringBundles && "nl".equals(selIdStr) && ProfileLanguageUtils.isDefaultLocaleLanguageCodeSet(values)) {
                return INFO_STATUS;
            }
            return Status.OK_STATUS;
        }
        if (values.contains("*")) {
            return INFO_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    protected ISelectionExpression.EvaluationContext createEvaluationContext(IShareableEntity se) {
        return new EvalContext(this, se);
    }

    public ISelectionExpression.SuFragmentEvaluationContext createEvaluationContext(IShareableUnit su, ISuFragment fragment) {
        return new FragmentEvalContext(this, su, fragment);
    }

    protected static class EvalContext
    extends BaseEvaluationContext {
        private final SelectorContext sc;
        private final IShareableEntity se;

        public EvalContext(SelectorContext sc, IShareableEntity se) {
            super(sc.isOverridingPredefineds(), sc.ignoringBundles);
            this.sc = sc;
            this.se = se;
        }

        @Override
        public IStatus evaluate(String selIdStr, String selValStr) {
            if (PredefinedSelectors.isVariable(selIdStr) || PredefinedSelectors.isVariable(selValStr)) {
                return INFO_STATUS;
            }
            if (PredefinedSelectors.contains(selIdStr)) {
                return this.canEvaluatePredefineds() ? this.sc.evaluatePredefinedSelector(selIdStr, selValStr) : Status.CANCEL_STATUS;
            }
            if (this.se == null) {
                return INFO_STATUS;
            }
            IContentSelector selector = this.se.getSelector(new SimpleIdentity(selIdStr), false);
            if (selector == null || this.sc.recursionGuard.contains(selector)) {
                return Status.CANCEL_STATUS;
            }
            this.sc.recursionGuard.add(selector);
            try {
                IStatus iStatus = this.sc.getSelectedStatus(this.se, selector);
                return iStatus;
            }
            finally {
                this.sc.recursionGuard.remove(selector);
            }
        }
    }

    private class FragmentEvalContext
    extends BaseEvaluationContext
    implements ISelectionExpression.SuFragmentEvaluationContext {
        private final ISelectionExpression.EvaluationContext suEvalContext;
        private final ISuFragment fragment;

        FragmentEvalContext(SelectorContext sc, IShareableUnit su, ISuFragment fragment) {
            super(sc.isOverridingPredefineds(), sc.ignoringBundles);
            this.suEvalContext = SelectorContext.this.createEvaluationContext(su);
            this.fragment = fragment;
        }

        @Override
        public IStatus evaluate(String selIdStr, String selValStr) {
            if (PredefinedSelectors.isVariable(selIdStr) || PredefinedSelectors.isVariable(selValStr) || PredefinedSelectors.contains(selIdStr)) {
                return this.suEvalContext.evaluate(selIdStr, selValStr);
            }
            ISuFragmentSelector selector = this.fragment.getSelector(new SimpleIdentity(selIdStr), false);
            return selector == null ? Status.CANCEL_STATUS : selector.getExpression().evaluate(this);
        }

        @Override
        public IStatus evaluateInTarget(String selIdStr) {
            return this.suEvalContext.evaluate(selIdStr, null);
        }
    }
}

