/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;

public class ExtensionBundleUtils {
    public static final String CLASS_ATTR = "class";
    public static final ExtensionBundleClassFinder DEFAULT_EXTENSION_FINDER = new ExtensionBundleClassFinder();

    public static Object createExecutableExtension(IConfigurationElement ce, Class instanceOfClass) throws CoreException {
        assert (ce != null);
        Object ee = null;
        try {
            ee = ce.createExecutableExtension(CLASS_ATTR);
            if (!instanceOfClass.isInstance(ee)) {
                throw new ClassCastException(NLS.bind(Messages.ExtensionBundleUtils_classCastException, ee, (Object)instanceOfClass.getName()));
            }
            return ee;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            String classAttr = ce.getAttribute(CLASS_ATTR);
            String errMsg = NLS.bind(Messages.ExtensionBundleUtils_failedToLoadExtension, classAttr, ce.getNamespaceIdentifier(), ce.getName());
            throw new CoreException((IStatus)Statuses.ERROR.get(e, errMsg, new Object[0]));
        }
    }

    public static IStatus getStatusForUnexpectedExtensionCallException(IConfigurationElement ce, String invocation, Throwable t) {
        assert (ce != null);
        assert (invocation != null);
        assert (t != null);
        String classAttr = ce.getAttribute(CLASS_ATTR);
        return Statuses.ERROR.get(t, Messages.ExtensionBundleUtils_extensionCallFailed, ce.getNamespaceIdentifier(), ce.getName(), classAttr, invocation);
    }

    public static class ExtensionBundleClassFinder {
        protected ExtensionBundleClassFinder() {
        }

        public IConfigurationElement findMatchingConfigurationElement(Object context, String extensionPointNamespace, String extensionPointName, String bundleId, String className) throws CoreException {
            IExtension[] extensions = this.findMatchingExtension(context, extensionPointNamespace, extensionPointName, bundleId);
            IConfigurationElement config = className != null ? this.findMatchingClass(context, bundleId, className, extensions) : extensions[0].getConfigurationElements()[0];
            return config;
        }

        protected IExtension[] findMatchingExtension(Object context, String extensionPointNamespace, String extensionPointName, String bundleId) throws CoreException {
            IExtension[] extensions;
            ArrayList<IExtension> return_result = new ArrayList<IExtension>();
            IExtensionPoint extn_point = Platform.getExtensionRegistry().getExtensionPoint(extensionPointNamespace, extensionPointName);
            IExtension[] iExtensionArray = extensions = extn_point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configs;
                IExtension extension = iExtensionArray[n2];
                if (bundleId.equals(extension.getContributor().getName()) && (configs = extension.getConfigurationElements()) != null && configs.length != 0) {
                    return_result.add(extension);
                }
                ++n2;
            }
            if (return_result.isEmpty()) {
                this.onNoMatchingExtensionFound(context, extensionPointNamespace, extensionPointName, bundleId);
            }
            return return_result.toArray(new IExtension[return_result.size()]);
        }

        protected void onNoMatchingExtensionFound(Object context, String extensionPointNamespace, String extensionPointName, String bundleId) throws CoreException {
            String msg = NLS.bind(Messages.ExtensionBundleUtils_bundleDoesNotProvideExtPoint, bundleId, extensionPointNamespace, extensionPointName);
            throw new CoreException((IStatus)Statuses.ERROR.get(msg, new Object[0]));
        }

        protected IConfigurationElement findMatchingClass(Object context, String bundleId, String className, IExtension[] extensions) throws CoreException {
            IConfigurationElement[] firstConfig = null;
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] configs = extension.getConfigurationElements();
                if (firstConfig == null) {
                    firstConfig = configs;
                }
                if (configs != null && configs.length != 0) {
                    IConfigurationElement[] iConfigurationElementArray = configs;
                    int n3 = configs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement config = iConfigurationElementArray[n4];
                        String classAttr = config.getAttribute(ExtensionBundleUtils.CLASS_ATTR);
                        if (classAttr != null && classAttr.endsWith(className)) {
                            return config;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return this.onNoMatchingConfigurationFound(context, extensions, bundleId, className, firstConfig);
        }

        protected IConfigurationElement onNoMatchingConfigurationFound(Object context, IExtension[] extensions, String bundleId, String className, IConfigurationElement[] configs) throws CoreException {
            String extensionPointId = extensions[0].getExtensionPointUniqueIdentifier();
            ICicStatus status = Statuses.ERROR.get(Messages.ExtensionBundleUtils_bundleDoesNotProvideExtPointClass, bundleId, className, extensionPointId);
            throw new CoreException((IStatus)status);
        }
    }
}

