/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.ISuFragmentSelector;
import com.ibm.cic.common.core.model.internal.BaseUnit;
import com.ibm.cic.common.core.model.internal.SuFragmentSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class SuFragment
extends BaseUnit
implements ISuFragment {
    private IIdentity targetId;
    private VersionRange targetTolerance;
    private boolean strict = false;
    private Set selectors;
    private ArrayList children;

    public SuFragment(IIdentity id, Version version) {
        super(id, version);
    }

    public SuFragment(IIdentity id, Version version, IIdentity targetId, VersionRange targetTolerance) {
        super(id, version);
        this.setTargetId(targetId);
        this.setTargetTolerance(targetTolerance);
    }

    @Override
    public IIdentity getTargetId() {
        return this.targetId;
    }

    @Override
    public void setTargetId(IIdentity targetId) {
        this.targetId = targetId;
    }

    @Override
    public VersionRange getTargetTolerance() {
        return this.targetTolerance;
    }

    @Override
    public void setTargetTolerance(VersionRange targetTolerance) {
        this.targetTolerance = targetTolerance;
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    private ISuFragmentSelector findSelector(IIdentity id) {
        if (this.selectors == null) {
            return null;
        }
        for (ISuFragmentSelector selector : this.selectors) {
            if (!selector.getIdentity().equals(id)) continue;
            return selector;
        }
        return null;
    }

    @Override
    public ISuFragmentSelector getSelector(IIdentity id, boolean createIfAbsent) {
        ISuFragmentSelector selector = this.findSelector(id);
        if (selector == null && createIfAbsent) {
            selector = new SuFragmentSelector(id);
            selector.setSuFragment(this);
            this.addSelector(selector);
        }
        return selector;
    }

    @Override
    public void addSelector(ISuFragmentSelector selector) {
        if (this.selectors == null) {
            this.selectors = new LinkedHashSet(4);
        }
        this.selectors.add(selector);
    }

    @Override
    public Set getSelectors() {
        return this.selectors == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(this.selectors);
    }

    @Override
    public void addInstallableUnit(IInstallableUnit iu) {
        if (this.children == null) {
            this.children = new ArrayList(4);
        }
        this.children.add(iu);
    }

    @Override
    public List getInstallableUnits() {
        return this.children == null ? Collections.EMPTY_LIST : this.children;
    }

    @Override
    public boolean hasInstallableUnits() {
        return this.children != null;
    }

    @Override
    public void setChildrenCount(int count) {
        if (this.children == null) {
            this.children = new ArrayList(count);
        } else {
            this.children.ensureCapacity(count);
        }
    }

    @Override
    public List getChildren() {
        return this.getInstallableUnits();
    }

    @Override
    public boolean hasChildren() {
        return this.hasInstallableUnits();
    }
}

