/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.internal.BaseUnit;
import com.ibm.cic.common.core.model.internal.CICParser;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.osgi.framework.Version;

public abstract class ShareableEntity
extends BaseUnit
implements IShareableEntity {
    private ArrayList children;
    private Set selectors;
    private boolean visible = true;

    public ShareableEntity(IIdentity id, Version version) {
        super(id, version);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ShareableEntity && super.equals(other);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null;
    }

    @Override
    public void setChildrenCount(int count) {
        Assert.isTrue((count > 0 ? 1 : 0) != 0);
        if (!this.hasChildren()) {
            this.children = new ArrayList(count);
        } else {
            this.children.ensureCapacity(count);
        }
    }

    @Override
    public List getChildren() {
        if (!this.hasChildren()) {
            this.children = new ArrayList(4);
        }
        return this.children;
    }

    @Override
    public Set getSelectors() {
        if (this.selectors == null) {
            this.selectors = new LinkedHashSet(4);
        }
        return this.selectors;
    }

    @Override
    public abstract IContentSelector getSelector(IIdentity var1, boolean var2);

    protected IContentSelector findSelector(IIdentity id) {
        if (this.selectors == null) {
            return null;
        }
        for (IContentSelector selector : this.selectors) {
            if (!selector.getIdentity().equals(id)) continue;
            return selector;
        }
        return null;
    }

    protected void ensureNotOneOfThePredefineds(IIdentity id) {
        String errMsg = CICParser.getErrMsgIfOneOfThePredefineds(id.getId());
        if (errMsg != null) {
            throw new IllegalArgumentException(errMsg);
        }
    }

    @Override
    public void addSelector(IContentSelector selector) {
        selector.setShareableEntity(this);
        this.getSelectors().add(selector);
    }
}

