/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.ISelectionExpressionFactory;
import com.ibm.cic.common.core.model.internal.SelectionExpression;
import com.ibm.cic.common.core.model.internal.SelectionOperator;

public class SelExprFactory
implements ISelectionExpressionFactory {
    @Override
    public ISelectionExpression createSelectedBy(String selIdStr) {
        return SelectionExpression.createSelectedById(selIdStr);
    }

    @Override
    public ISelectionExpression createSelectedBy(String selIdStr, String selValStr) {
        return SelectionExpression.createSelectedByPredefinedId(selIdStr, selValStr);
    }

    @Override
    public ISelectionExpression createSelectedByBundle(String bundleId, String className) {
        return SelectionExpression.createSelectedByBundle(bundleId, className);
    }

    public ISelectionExpression createSelectedByTarget(String targetId) {
        return SelectionExpression.createSelectedByTarget(targetId);
    }

    @Override
    public ISelectionExpression createSelectedByExpressionAND(ISelectionExpression[] operands) {
        return this.createSelectedByExpression(SelectionOperator.AND(), operands);
    }

    @Override
    public ISelectionExpression createSelectedByExpressionOR(ISelectionExpression[] operands) {
        return this.createSelectedByExpression(SelectionOperator.OR(), operands);
    }

    @Override
    public ISelectionExpression createSelectedByExpressionXOR(ISelectionExpression[] operands) {
        return this.createSelectedByExpression(SelectionOperator.XOR(), operands);
    }

    @Override
    public ISelectionExpression createSelectedByExpressionNOT(ISelectionExpression operand) {
        return this.createSelectedByExpression(SelectionOperator.NOT(), new ISelectionExpression[]{operand});
    }

    private ISelectionExpression createSelectedByExpression(SelectionOperator op, ISelectionExpression[] operands) {
        ISelectionExpression[] iSelectionExpressionArray = operands;
        int n = operands.length;
        int n2 = 0;
        while (n2 < n) {
            ISelectionExpression operand = iSelectionExpressionArray[n2];
            op.addOperand(operand);
            ++n2;
        }
        return SelectionExpression.createSelectedByOperator(op);
    }
}

