/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IRequiredShareableEntity;
import com.ibm.cic.common.core.model.internal.BuilderDataContainer;
import com.ibm.cic.common.core.utils.Util;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.osgi.service.resolver.VersionRange;

public class RequiredShareableEntity
extends BuilderDataContainer
implements IRequiredShareableEntity {
    private VersionRange tolerance;
    private final IIdentity shareableId;
    private Set selectorIds;
    private boolean requiresInstallContext;
    private IContentSelector parent;

    public RequiredShareableEntity(IIdentity shareableId) {
        this.shareableId = shareableId;
        this.requiresInstallContext = false;
    }

    @Override
    public void setTolerance(VersionRange tolerance) {
        this.tolerance = tolerance;
    }

    public boolean hasSelectorIds() {
        return this.selectorIds != null && !this.selectorIds.isEmpty();
    }

    @Override
    public Set getSelectorIds() {
        if (this.selectorIds == null) {
            this.selectorIds = new LinkedHashSet(2);
        }
        return this.selectorIds;
    }

    @Override
    public void addSelectorId(IIdentity selectorId) {
        this.getSelectorIds().add(selectorId);
    }

    @Override
    public VersionRange getTolerance() {
        return this.tolerance;
    }

    @Override
    public IIdentity getShareableId() {
        return this.shareableId;
    }

    @Override
    public boolean requiresInstallationContext() {
        return this.requiresInstallContext;
    }

    @Override
    public void setRequiresInstallationContext(boolean requiresInstallationContext) {
        this.requiresInstallContext = requiresInstallationContext;
    }

    @Override
    public IContentSelector getContainingSelector() {
        return this.parent;
    }

    void setContainingSelector(IContentSelector parent) {
        this.parent = parent;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('<').append("requiredShareableEntity").append(' ').append("shareableId").append('=').append('\'').append(this.getShareableId()).append('\'').append(' ').append("tolerance").append('=').append('\'').append(this.getTolerance()).append('\'');
        if (this.requiresInstallationContext()) {
            sb.append(' ').append("installContext").append('=').append("'true'").append('>');
        } else {
            sb.append('>');
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.shareableId.hashCode() ^ this.tolerance.hashCode() << 1 ^ Util.hashCode((Object)this.parent) << 3 ^ this.getSelectorIds().hashCode() << 4;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IRequiredShareableEntity) {
            IRequiredShareableEntity that = (IRequiredShareableEntity)obj;
            return this.requiresInstallContext == that.requiresInstallationContext() && this.shareableId.equals(that.getShareableId()) && this.tolerance.equals((Object)that.getTolerance()) && Util.equals(this.parent, that.getContainingSelector()) && this.getSelectorIds().equals(that.getSelectorIds());
        }
        return false;
    }
}

