/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingIncludes;
import com.ibm.cic.common.core.model.internal.OfferingOrFix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.Version;

public class Offering
extends OfferingOrFix
implements IOffering {
    private IFeatureGroup featureGroup;
    private List<IOfferingIncludes> includes = Collections.emptyList();

    public Offering(IIdentity id, Version version) {
        super(id, version);
    }

    @Override
    public List<IOfferingIncludes> getIncludes() {
        return this.includes;
    }

    public void addInclude(IOfferingIncludes include) {
        if (this.includes.isEmpty()) {
            this.includes = new ArrayList<IOfferingIncludes>();
        }
        this.includes.add(include);
    }

    @Override
    public IFeatureGroup getFeatureGroup() {
        return this.featureGroup;
    }

    @Override
    public void setFeatureGroup(IFeatureGroup featureGroup) {
        this.featureGroup = featureGroup;
    }

    @Override
    public List<IFeature> getFilteredFeatures(IOffering.FeatureFilter filter) {
        ArrayList<IFeature> features = new ArrayList<IFeature>();
        this.collectRelevantFeatures(this.getFeatureGroup(), features, filter);
        features.trimToSize();
        return features;
    }

    private void collectRelevantFeatures(IFeatureGroup group, List<IFeature> features, IOffering.FeatureFilter filter) {
        if (group == null) {
            return;
        }
        List children = group.getChildren();
        for (Object child : children) {
            if (child instanceof IFeature) {
                this.collectRelevantFeature((IFeature)child, features, filter);
                continue;
            }
            if (!(child instanceof IFeatureGroup)) continue;
            this.collectRelevantFeatures((IFeatureGroup)child, features, filter);
        }
    }

    private void collectRelevantFeature(IFeature feature, List features, IOffering.FeatureFilter filter) {
        if (filter == null || filter.canAccept(feature)) {
            features.add(feature);
        }
    }

    @Override
    public boolean isResolved() {
        return this.getAssembly() != null;
    }
}

