/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.expander;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IIncludedSuFragment;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IRequiredShareableEntity;
import com.ibm.cic.common.core.model.ISelectableNode;
import com.ibm.cic.common.core.model.ISelectionExpressionManipulator;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.IncludedShareableEntitySelector;
import com.ibm.cic.common.core.model.Walker;
import com.ibm.cic.common.core.model.expander.SimpleContextState;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

class SimpleSelectorExpander {
    private SimpleContextState state = new SimpleContextState();

    SimpleSelectorExpander(IContent content, IProgressMonitor monitor) {
        if (content instanceof IOffering) {
            IOffering offering = (IOffering)content;
            this.expand(offering.getAssembly(), new SplitProgressMonitor(monitor, NLS.bind((String)Messages.SimpleSelectorExpander_Analyzing, (Object)offering.getName()), 1).next());
        } else if (content instanceof IFix) {
            SimpleSelectorExpander.addFixSEs(this.state, FixSeCollector.collect((IFix)content, monitor));
        } else {
            this.expand((IShareableEntity)content, monitor);
        }
    }

    SimpleContextState getState() {
        return this.state;
    }

    private void expand(IShareableEntity se, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        this.state.addCandidate(se);
        this.addRSEs(se);
        if (se instanceof IAssembly) {
            this.expandAssembly((IAssembly)se, monitor);
        }
    }

    private void expandAssembly(IAssembly asm, IProgressMonitor monitor) {
        List children = asm.getChildren();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, children.size());
        for (ISelectableNode child : children) {
            if (child instanceof IIncludedSuFragment) {
                IIncludedSuFragment isuf = (IIncludedSuFragment)child;
                ISuFragment fragment = isuf.getSuFragment();
                if (fragment != null) {
                    boolean pushed = this.pushInstallationContext(asm, isuf);
                    this.state.addFragment(fragment);
                    this.popInstallationContext(pushed);
                }
                pm.next();
                continue;
            }
            if (child instanceof IIncludedShareableEntity) {
                IIncludedShareableEntity ise = (IIncludedShareableEntity)child;
                this.state.addInclude(ise, asm);
                IShareableEntity se = ise.getShareableEntity();
                if (se == null) continue;
                Set includedSelectors = ise.getIncludedShareableEntitySelectors();
                pm.splitNext(includedSelectors.size());
                for (IncludedShareableEntitySelector ises : includedSelectors) {
                    boolean pushed = this.pushInstallationContext(asm, ises);
                    this.expand(se, pm.next());
                    this.popInstallationContext(pushed);
                }
                continue;
            }
            throw new AssertionError(child);
        }
        pm.done();
    }

    private void addRSEs(IShareableEntity se) {
        Set selectors = se.getSelectors();
        for (IContentSelector selector : selectors) {
            Set rses = selector.getRequiredShareableEntities();
            for (IRequiredShareableEntity rse : rses) {
                this.state.addRequire(rse, se);
            }
        }
    }

    private boolean pushInstallationContext(IShareableEntity se, ISelectionExpressionManipulator exprParent) {
        SimpleContextState subContext = this.state.getIC(se, exprParent);
        if (subContext == null) {
            return false;
        }
        this.state = subContext;
        return true;
    }

    private void popInstallationContext(boolean pushed) {
        if (pushed) {
            this.state = (SimpleContextState)this.state.getParent();
        }
    }

    private static void addFixSEs(SimpleContextState state, List<IShareableEntity> ses) {
        for (IShareableEntity iShareableEntity : ses) {
            state.addCandidate(iShareableEntity);
        }
        for (SimpleContextState simpleContextState : state.getSubContexts()) {
            SimpleSelectorExpander.addFixSEs(simpleContextState, ses);
        }
    }

    private static class FixSeCollector
    extends Walker {
        private final List<IShareableEntity> ses = new ArrayList<IShareableEntity>(32);

        private FixSeCollector() {
        }

        static List<IShareableEntity> collect(IFix fix, IProgressMonitor monitor) {
            return new FixSeCollector().doCollect(fix, monitor);
        }

        private List<IShareableEntity> doCollect(IFix fix, IProgressMonitor monitor) {
            try {
                this.walkIncludes(fix, monitor);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
            return this.ses;
        }

        @Override
        public void doAssembly(IAssembly assembly) throws Exception {
            this.ses.add(assembly);
        }

        @Override
        public void doShareableUnit(IShareableUnit su) throws Exception {
            this.ses.add(su);
        }

        @Override
        protected boolean canHaveUnresolvedIncludes() {
            return true;
        }
    }
}

