/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.expander;

import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.expander.SimpleContextState;
import com.ibm.cic.common.core.model.expander.SimpleSelectorExpander;
import com.ibm.cic.common.logging.Logger;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

class ContextStateCache {
    private static final Logger log = Logger.getLogger();
    public static final ContextStateCache INSTANCE = new ContextStateCache();
    private final Map<IContent, SoftValue> cache = new LinkedHashMap<IContent, SoftValue>();
    private final ReferenceQueue<SimpleContextState> queue = new ReferenceQueue();

    private ContextStateCache() {
    }

    public SimpleContextState get(IContent content, IProgressMonitor monitor) {
        SimpleContextState state = this.getFromCache(content);
        if (state == null) {
            log.debug("Cache miss for {0}", content);
            state = new SimpleSelectorExpander(content, monitor).getState();
            this.putInCache(content, state);
        } else {
            log.debug("Cache hit for {0}", content);
        }
        return state;
    }

    public void clear() {
        this.cache.clear();
    }

    private SimpleContextState getFromCache(IContent content) {
        SoftReference ref = this.cache.get(content);
        if (ref == null) {
            return null;
        }
        SimpleContextState result = (SimpleContextState)ref.get();
        if (result == null) {
            this.cleanup();
            return null;
        }
        return result;
    }

    private void putInCache(IContent content, SimpleContextState state) {
        this.cleanup();
        this.cache.put(content, new SoftValue(state, content, this.queue));
    }

    private void cleanup() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            log.debug("Cleanup {0}", sv.content);
            this.cache.remove(sv.content);
        }
    }

    private static class SoftValue
    extends SoftReference<SimpleContextState> {
        final IContent content;

        SoftValue(SimpleContextState state, IContent content, ReferenceQueue<SimpleContextState> queue) {
            super(state, queue);
            this.content = content;
        }
    }
}

