/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.adapterdata.impl;

import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.osgi.framework.Version;

public abstract class ArtifactKeyUtil {
    public static Collection getSortedArtifactKeysSet() {
        return new TreeSet(new ArtifactKeyComparator());
    }

    public static String toCombinedString(IArtifactKey key) {
        String[] segments = new String[]{key.getPath().toString(), key.getNamespace(), key.getQualifier(), key.getId().getId(), key.getVersion().equals((Object)Version.emptyVersion) ? "" : key.getVersion().toString()};
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < segments.length) {
            sb.append(segments[i]);
            if (i != segments.length - 1) {
                sb.append(',');
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isSameArtifactKeyIgnoreVersion(IArtifactKey xk, IArtifactKey yk) {
        return xk.getNamespace().equals(yk.getNamespace()) && xk.getQualifier().equals(yk.getQualifier()) && xk.getId().equals(yk.getId()) && xk.getPath().equals((Object)yk.getPath());
    }

    public static boolean isSameArtifactIgnoreVersion(IArtifact x, IArtifact y) {
        return ArtifactKeyUtil.isSameArtifactKeyIgnoreVersion(x.getKey(), y.getKey());
    }

    public static class ArtifactKeyComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            IArtifactKey a = (IArtifactKey)o1;
            IArtifactKey b = (IArtifactKey)o2;
            if (a == b) {
                return 0;
            }
            int r = a.getNamespace().compareTo(b.getNamespace());
            if (r != 0) {
                return r;
            }
            r = a.getQualifier().compareTo(b.getQualifier());
            if (r != 0) {
                return r;
            }
            r = a.getId().getId().compareTo(b.getId().getId());
            if (r != 0) {
                return r;
            }
            r = a.getVersion().compareTo(b.getVersion());
            if (r != 0) {
                return r;
            }
            r = a.getPath().toString().compareTo(b.getPath().toString());
            return r;
        }
    }
}

