/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model;

import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.internal.CICWriter;
import com.ibm.cic.common.core.model.utils.ContentCollection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class Writer {
    public static final String OFFERING_EXT = ".offering";
    public static final String FIX_EXT = ".fix";
    public static final String ASSEMBLY_EXT = ".assembly";
    public static final String SU_EXT = ".su";
    public static final String SU_FRAGMENT_EXT = ".suFragment";
    public static final String IU_EXT = ".iu";

    public static void writeOffering(IOffering offering, File outputFile) throws IOException {
        new CICWriter().writeOffering(offering, outputFile);
    }

    public static void writeOffering(IOffering offering, OutputStream output) {
        new CICWriter().writeOffering(offering, output);
    }

    public static void writeFix(IFix fix, File outputFile) throws IOException {
        new CICWriter().writeFix(fix, outputFile);
    }

    public static void writeFix(IFix fix, OutputStream output) {
        new CICWriter().writeFix(fix, output);
    }

    public static void write(IContent unit, File outputFile) throws IOException {
        new CICWriter().write(unit, outputFile);
    }

    public static void write(IContent unit, OutputStream output) {
        new CICWriter().write(unit, output);
    }

    public static void writeJar(IContent theUnit, File jarFile) throws IOException {
        try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(jarFile));){
            ContentCollection contentCollection = new ContentCollection(theUnit);
            for (IContent content : contentCollection) {
                ZipEntry ze = new ZipEntry(Writer.getFileName(content));
                jos.putNextEntry(ze);
                Writer.write(content, jos);
                jos.closeEntry();
            }
        }
    }

    public static void writeDir(IContent theUnit, File outputDir) throws IOException {
        CICWriter modelWriter = new CICWriter();
        outputDir.mkdir();
        ContentCollection contentCollection = new ContentCollection(theUnit);
        for (IContent content : contentCollection) {
            modelWriter.write(content, new File(outputDir, Writer.getFileName(content)));
        }
    }

    public static String getFileName(IContent unit) {
        return String.valueOf(Writer.getName(unit)) + Writer.getFileExt(unit.getClass());
    }

    public static String getName(IContent unit) {
        return String.valueOf(unit.getIdentity().getId()) + '_' + unit.getVersion();
    }

    public static String getFileExt(IContent unit) {
        return Writer.getFileExt(unit.getClass());
    }

    public static String getFileExt(Class elementClass) {
        return String.valueOf('.') + CicConstants.getFileExt(elementClass);
    }
}

