/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model;

import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class InstallableUnitPair {
    private IInstallableUnit from;
    private IInstallableUnit to;

    public InstallableUnitPair(IInstallableUnit from, IInstallableUnit to) {
        this.from = from;
        this.to = to;
        this.check();
    }

    private InstallableUnitPair() {
        this.from = null;
        this.to = null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InstallableUnitPair)) {
            return false;
        }
        InstallableUnitPair that = (InstallableUnitPair)obj;
        return Util.equals(this.from, that.from) && Util.equals(this.to, that.to);
    }

    public int hashCode() {
        return Util.hashCode((Object)this.from) + 31 * Util.hashCode((Object)this.to);
    }

    public String toString() {
        if (this.from == null && this.to == null) {
            return "null";
        }
        return this.toString(this.getIdentity());
    }

    public String toQualifiedString() {
        if (this.from == null && this.to == null) {
            return "null";
        }
        return this.toString(this.getQualifiedId());
    }

    private String toString(IIdentity identity) {
        return NLS.bind("{0} {1}->{2}", identity, this.from == null ? null : this.from.getVersion(), this.to == null ? null : this.to.getVersion());
    }

    public InstallableUnitPair reverse() {
        return new InstallableUnitPair(this.to, this.from);
    }

    public boolean isIncreasing() {
        return this.to != null && this.to.compareVersion(this.from) > 0;
    }

    public boolean isIdentical() {
        return this.to != null && this.to.compareVersion(this.from) == 0;
    }

    public boolean isInstall() {
        return this.from == null;
    }

    public boolean isUninstall() {
        return this.to == null;
    }

    public boolean isUpdate() {
        return this.from != null && this.isIncreasing();
    }

    public boolean isRollback() {
        return this.to != null && !this.isIncreasing();
    }

    public IInstallableUnit getFrom() {
        return this.from;
    }

    public void setFrom(IInstallableUnit from) {
        this.from = from;
        this.check();
    }

    public IInstallableUnit getTo() {
        return this.to;
    }

    public void setTo(IInstallableUnit to) {
        this.to = to;
        this.check();
    }

    public IIdentity getIdentity() {
        return (this.from != null ? this.from : this.to).getIdentity();
    }

    public IIdentity getQualifiedId() {
        return (this.from != null ? this.from : this.to).getQualifiedId();
    }

    public String getName() {
        return (this.from != null ? this.from : this.to).getName();
    }

    public String getAdapterId() {
        return (this.from != null ? this.from : this.to).getAdapterId();
    }

    public IInstallableUnitContainer getParent() {
        return (this.from != null ? this.from : this.to).getParent();
    }

    public static InstallableUnitPair[] fromPairs(IInstallableUnit[] from) {
        InstallableUnitPair[] pairs = new InstallableUnitPair[from.length];
        int i = 0;
        while (i < from.length) {
            pairs[i] = new InstallableUnitPair(from[i], null);
            ++i;
        }
        return pairs;
    }

    public static InstallableUnitPair[] toPairs(IInstallableUnit[] to) {
        InstallableUnitPair[] pairs = new InstallableUnitPair[to.length];
        int i = 0;
        while (i < to.length) {
            pairs[i] = new InstallableUnitPair(null, to[i]);
            ++i;
        }
        return pairs;
    }

    public static InstallableUnitPair[] reverse(InstallableUnitPair[] pairs) {
        InstallableUnitPair[] reversed = new InstallableUnitPair[pairs.length];
        int i = 0;
        while (i < pairs.length) {
            reversed[pairs.length - (i + 1)] = pairs[i].reverse();
            ++i;
        }
        return reversed;
    }

    public static java.util.List getAllToIUs(List pairs) {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(pairs.size());
        Iterator i = pairs.iterator();
        while (i.hasNext()) {
            InstallableUnitPair pair = (InstallableUnitPair)i.next();
            IInstallableUnit to = pair.getTo();
            if (to == null) continue;
            result.add(to);
        }
        return result;
    }

    public static java.util.List<IInstallableUnit> getAllFromIUs(List pairs) {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(pairs.size());
        Iterator i = pairs.iterator();
        while (i.hasNext()) {
            InstallableUnitPair pair = (InstallableUnitPair)i.next();
            IInstallableUnit from = pair.getFrom();
            if (from == null) continue;
            result.add(from);
        }
        return result;
    }

    private void check() {
        if (this.from == null && this.to == null) {
            throw new IllegalArgumentException("Both IUs are null");
        }
        if (this.from != null && this.to != null && !this.from.getQualifiedId().equals(this.to.getQualifiedId())) {
            throw new IllegalArgumentException("Incompatible IUs: " + this.from + ' ' + this.to);
        }
    }

    public IInstallableUnit getLatest() {
        if (this.to != null && this.to.compareVersion(this.from) >= 0) {
            return this.to;
        }
        return this.from;
    }

    /* synthetic */ InstallableUnitPair(InstallableUnitPair installableUnitPair) {
        this();
    }

    public static class List {
        protected Map map;

        public List(int initialCapacity) {
            this.map = new LinkedHashMap(initialCapacity);
        }

        public List(InstallableUnitPair[] pairs) {
            this(pairs.length);
            this.addAll(pairs);
        }

        public String toString() {
            if (this.map.size() == 0) {
                return "(empty)";
            }
            StringBuffer sb = new StringBuffer(50 * this.map.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                sb.append(i.next()).append('\n');
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Iterator iterator() {
            return this.map.values().iterator();
        }

        public InstallableUnitPair add(InstallableUnitPair pair) {
            return this.map.put(pair.getQualifiedId(), pair);
        }

        public IInstallableUnit addTo(IInstallableUnit iu) {
            InstallableUnitPair pair = this.getPair(iu);
            IInstallableUnit prev = pair.getTo();
            pair.setTo(iu);
            return prev;
        }

        public IInstallableUnit addFrom(IInstallableUnit iu) {
            InstallableUnitPair pair = this.getPair(iu);
            IInstallableUnit prev = pair.getFrom();
            pair.setFrom(iu);
            return prev;
        }

        public void addAllTo(IInstallableUnit[] ius) {
            IInstallableUnit[] iInstallableUnitArray = ius;
            int n = ius.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallableUnit iu = iInstallableUnitArray[n2];
                this.addTo(iu);
                ++n2;
            }
        }

        public void addAllTo(Collection ius) {
            for (IInstallableUnit iu : ius) {
                this.addTo(iu);
            }
        }

        public void addAllFrom(IInstallableUnit[] ius) {
            IInstallableUnit[] iInstallableUnitArray = ius;
            int n = ius.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallableUnit iu = iInstallableUnitArray[n2];
                this.addFrom(iu);
                ++n2;
            }
        }

        public void addAllFrom(Collection ius) {
            for (IInstallableUnit iu : ius) {
                this.addFrom(iu);
            }
        }

        public void removeIdentical() {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                InstallableUnitPair pair = (InstallableUnitPair)i.next();
                if (!pair.isIdentical()) continue;
                i.remove();
            }
        }

        public boolean removeTo(IInstallableUnit iu) {
            IIdentity id = iu.getQualifiedId();
            InstallableUnitPair pair = this.get(id);
            if (pair == null || !iu.equals(pair.getTo())) {
                return false;
            }
            if (pair.getFrom() == null) {
                this.map.remove(id);
                return true;
            }
            pair.setTo(null);
            return true;
        }

        public boolean removeFrom(IInstallableUnit iu) {
            IIdentity id = iu.getQualifiedId();
            InstallableUnitPair pair = this.get(id);
            if (pair == null || !iu.equals(pair.getFrom())) {
                return false;
            }
            if (pair.getTo() == null) {
                this.map.remove(id);
                return true;
            }
            pair.setFrom(null);
            return true;
        }

        public void addAll(List pairs) {
            Iterator i = pairs.iterator();
            while (i.hasNext()) {
                InstallableUnitPair pair = (InstallableUnitPair)i.next();
                this.add(pair);
            }
        }

        public void addAll(InstallableUnitPair[] pairs) {
            InstallableUnitPair[] installableUnitPairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                InstallableUnitPair pair = installableUnitPairArray[n2];
                this.add(pair);
                ++n2;
            }
        }

        public InstallableUnitPair[] getPairs() {
            InstallableUnitPair[] pairs = new InstallableUnitPair[this.map.size()];
            this.map.values().toArray(pairs);
            return pairs;
        }

        public List reverse() {
            List reversed = new List(this.size());
            InstallableUnitPair[] pairs = this.getPairs();
            int i = pairs.length - 1;
            while (i >= 0) {
                reversed.add(pairs[i].reverse());
                --i;
            }
            return reversed;
        }

        public List reverseList() {
            List reversed = new List(this.size());
            InstallableUnitPair[] pairs = this.getPairs();
            int i = pairs.length - 1;
            while (i >= 0) {
                reversed.add(pairs[i]);
                --i;
            }
            return reversed;
        }

        public InstallableUnitPair get(IIdentity qualifiedId) {
            return (InstallableUnitPair)this.map.get(qualifiedId);
        }

        private InstallableUnitPair getPair(IInstallableUnit iu) {
            IIdentity id = iu.getQualifiedId();
            InstallableUnitPair pair = this.get(id);
            if (pair == null) {
                pair = new InstallableUnitPair(null);
                this.map.put(id, pair);
            }
            return pair;
        }
    }

    public static class UnmodifiableList
    extends List {
        public UnmodifiableList(List pairs) {
            super(pairs.size());
            Iterator i = pairs.iterator();
            while (i.hasNext()) {
                InstallableUnitPair pair = (InstallableUnitPair)i.next();
                this.add(new UnmodifiablePair(pair));
            }
            this.map = Collections.unmodifiableMap(this.map);
        }
    }

    private static class UnmodifiablePair
    extends InstallableUnitPair {
        public UnmodifiablePair(InstallableUnitPair pair) {
            super(pair.getFrom(), pair.getTo());
        }

        @Override
        public void setFrom(IInstallableUnit from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTo(IInstallableUnit to) {
            throw new UnsupportedOperationException();
        }
    }
}

