/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.volrepo;

import com.ibm.cic.common.core.internal.volrepo.IDiskMounter;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.volrepo.DiskTagFile;

public class MountedDisk
implements IDiskMounter.IMountedDisk {
    private final DiskTagFile.DiskTagProperties dtp;
    private final ICicLocation diskRoot;

    public MountedDisk(DiskTagFile.DiskTagProperties dtp, ICicLocation diskRoot) {
        this.dtp = dtp;
        this.diskRoot = diskRoot;
    }

    @Override
    public String getDiskLayoutVersion() {
        String dtpVersion = this.dtp.getProperty("layoutVersion");
        if (dtpVersion == null) {
            dtpVersion = "0";
        }
        return dtpVersion;
    }

    @Override
    public DiskTagFile.DiskTagProperties getDiskTagProperties() {
        return this.dtp;
    }

    @Override
    public String getDiskSetId() {
        return this.dtp.getProperty("diskSetId");
    }

    @Override
    public int getDiskIndex() {
        return this.dtp.getDiskNumber() - 1;
    }

    @Override
    public ICicLocation getRoot() {
        return this.diskRoot;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDiskMounter.IMountedDisk) {
            IDiskMounter.IMountedDisk rhs = (IDiskMounter.IMountedDisk)obj;
            return rhs.getDiskSetId().equals(this.getDiskSetId()) && rhs.getDiskIndex() == this.getDiskIndex() && rhs.getRoot().equals(this.getRoot());
        }
        return false;
    }

    public int hashCode() {
        return (17 * this.getDiskSetId().hashCode() + this.getDiskIndex()) * 17 + this.getRoot().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("dtp=");
        sb.append(this.dtp.toString());
        sb.append(" root=");
        sb.append(this.getRoot().toString());
        return sb.toString();
    }
}

