/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.utils;

import com.ibm.cic.common.core.internal.utils.CicCommonCoreHeartBeat;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreTrace;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Plugin;

public class CicCommonCoreDateTrace
extends CicCommonCoreTrace {
    private final CicCommonCoreHeartBeat heartBeat;

    public CicCommonCoreDateTrace(Plugin plugin, CicCommonCoreHeartBeat heartBeat) {
        super(plugin);
        this.heartBeat = heartBeat;
    }

    public CicCommonCoreDateTrace(Plugin plugin, CicCommonCoreHeartBeat heartBeat, String option) {
        super(plugin, option);
        this.heartBeat = heartBeat;
    }

    protected String getTimeStamp() {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
            return formatter.format(new Date());
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }

    public void heartbeat() {
        if (this.enabled) {
            this.println("");
        }
    }

    @Override
    public void println(String userMsg) {
        if (this.enabled) {
            long beaten;
            if (this.heartBeat != null && (beaten = this.heartBeat.beaten()) > 0L) {
                String msg = MessageFormat.format("HEARTBEAT elapsed {0}: {1}", Long.toString(beaten / 1000L), this.getTimeStamp());
                super.println(msg);
            }
            if (userMsg.length() > 0) {
                String msg = MessageFormat.format("{0}:{1}", this.getTimeStamp(), userMsg);
                super.println(msg);
            }
        }
    }
}

