/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.downloads.IDownloadIncomplete;
import java.io.File;
import java.util.Collection;
import java.util.Collections;

public class DownloadedIncompleteUsingFile
implements IDownloadIncomplete {
    private final File file;

    public DownloadedIncompleteUsingFile(File file) {
        this.file = file;
    }

    @Override
    public long getFailedDownloadBytes() {
        return 0L;
    }

    @Override
    public Collection getFailedDownloads() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public long getFragmentBytes() {
        return this.file.length();
    }

    @Override
    public void releaseFailedDownloads() {
    }

    @Override
    public void releaseFragments() {
        FileUtil.rm(this.file);
    }

    @Override
    public long getTotalBytes() {
        return this.getFragmentBytes() + this.getFailedDownloadBytes();
    }

    @Override
    public void releaseAll() {
        this.releaseFragments();
        this.releaseFailedDownloads();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DownloadedIncompleteUsingFile ");
        sb.append(this.file);
        return sb.toString();
    }
}

