/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialPromptConversation;
import com.ibm.cic.common.downloads.CredentialPrompter;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.ICredentialPrompter;
import com.ibm.cic.common.downloads.ICredentialValidator;
import com.ibm.cic.common.downloads.INonsecureConnectionPrompter;
import com.ibm.cic.common.downloads.NonsecureConnectionPrompter;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PrompterUtils {

    private static class SilentCredentialPrompter {
        private ICredentialPrompter previousPrompter;
        private final LinkedHashSet<String> prompts = new LinkedHashSet();

        public SilentCredentialPrompter() {
            this.previousPrompter = CredentialPrompter.INSTANCE.getPrompter();
            ICredentialPrompter silentPrompter = new ICredentialPrompter(){

                @Override
                public IStatus askUserIdAndPassword(ICredentialValidator validator, String connectMessage, CredentialRequested requested, CredentialInfo previous, CredentialInfo[] ret) {
                    CredentialPromptConversation c = new CredentialPromptConversation(validator, connectMessage, requested, previous);
                    SilentCredentialPrompter.this.prompts.add(c.getConnectMessage());
                    return Status.CANCEL_STATUS;
                }
            };
            CredentialPrompter.INSTANCE.setPrompter(silentPrompter);
        }

        public Collection<String> getPrompts() {
            return Collections.unmodifiableSet(this.prompts);
        }

        public void restore() {
            CredentialPrompter.INSTANCE.setPrompter(this.previousPrompter);
        }
    }

    public static class SilentDownloadUserPrompts {
        private SilentCredentialPrompter silentCredentialPrompter = null;
        private final SilentNonsecureConnectionPrompter silentNonsecurePrompter;

        public SilentDownloadUserPrompts(boolean staySecure) {
            if (CredentialPrompter.INSTANCE.getPrompter() == null) {
                this.silentCredentialPrompter = new SilentCredentialPrompter();
            }
            this.silentNonsecurePrompter = new SilentNonsecureConnectionPrompter(staySecure);
        }

        public Collection<String> getPrompts() {
            if (this.silentCredentialPrompter != null) {
                return this.silentCredentialPrompter.getPrompts();
            }
            return Collections.emptyList();
        }

        public void restore() {
            if (this.silentCredentialPrompter != null) {
                this.silentCredentialPrompter.restore();
            }
            this.silentNonsecurePrompter.restore();
        }
    }

    public static class SilentNonsecureConnectionPrompter {
        private INonsecureConnectionPrompter previousPrompter;
        private boolean staySecure = false;

        public SilentNonsecureConnectionPrompter(boolean staySecure) {
            this.staySecure = staySecure;
            this.previousPrompter = NonsecureConnectionPrompter.INSTANCE.getPrompter();
            INonsecureConnectionPrompter rememberStaySecurePrompter = new INonsecureConnectionPrompter(){

                @Override
                public int promptEnterNonsecureSSLMode(String host, X509Certificate[] certificates, String authType, CertificateException ce) {
                    if (SilentNonsecureConnectionPrompter.this.staySecure) {
                        return 3;
                    }
                    return 4;
                }
            };
            NonsecureConnectionPrompter.INSTANCE.setPrompter(rememberStaySecurePrompter);
        }

        public void restore() {
            NonsecureConnectionPrompter.INSTANCE.setPrompter(this.previousPrompter);
        }
    }
}

