/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ConsoleRepositoryUtils;
import com.ibm.cic.common.core.downloads.RememberDownloadUserPrompts;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ConsolePromptRepositoryUtils {
    public static IRepository openExistingRepository(IRepositoryGroup group, IRepositoryInfo repInfo, IProgressMonitor monitor) throws CoreException {
        RememberDownloadUserPrompts prompts = new RememberDownloadUserPrompts();
        try {
            IRepository iRepository = RepositoryUtils.openExistingRepository(group, repInfo, monitor);
            return iRepository;
        }
        finally {
            prompts.forget();
        }
    }

    public static IStatus openServiceRepositories(IRepositoryGroup group, IOffering[] offerings, IProgressMonitor monitor) {
        RememberDownloadUserPrompts prompts = new RememberDownloadUserPrompts();
        try {
            CicMultiStatus cicMultiStatus = ConsoleRepositoryUtils.openServiceRepositories(new ServiceRepositoryUtils.DefaultOpenServiceRepo(){

                @Override
                public IRepository openServiceRepository(IRepositoryGroup destinationGroup, IOffering offering, IRepositoryInfo repInfo) throws CoreException {
                    return RepositoryUtils.openExistingRepository(destinationGroup, repInfo, (IProgressMonitor)new NullProgressMonitor());
                }
            }, group, offerings, monitor);
            return cicMultiStatus;
        }
        finally {
            prompts.forget();
        }
    }
}

