/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.utils.UserNames;
import org.eclipse.osgi.util.NLS;

class Util {
    Util() {
    }

    public static UserNames getUserNames(IArtifact artifact, IContentLocator locator) {
        if (artifact != null) {
            return new UserNames(artifact.toUserString(), locator.getUserNames().getPureSystemName());
        }
        return locator.getUserNames();
    }

    public static String getLocalizedMessage(UserNames repoNames, UserNames locNames, String[] keys) {
        int index;
        Object[] args;
        String context;
        String string = context = repoNames != null ? repoNames.getPureSystemName() : null;
        if (context == null) {
            if (locNames.hasDistinctSystemName()) {
                args = new Object[]{locNames.getLogicalName(), locNames.getSystemName()};
                index = 1;
            } else {
                args = new Object[]{locNames.getLogicalName()};
                index = 0;
            }
        } else if (locNames.hasDistinctSystemName()) {
            args = new Object[]{locNames.getLogicalName(), locNames.getSystemName(), context};
            index = 3;
        } else {
            args = new Object[]{locNames.getLogicalName(), context};
            index = 2;
        }
        String msg = NLS.bind((String)keys[index], (Object[])args);
        return msg;
    }

    public static String getLocalizedMessage(UserNames repoNames, String artifact, String[] keys) {
        int index;
        Object[] args;
        String context;
        String string = context = repoNames != null ? repoNames.getPureSystemName() : null;
        if (context == null) {
            args = new Object[]{artifact};
            index = 0;
        } else {
            args = new Object[]{artifact, context};
            index = 1;
        }
        String msg = NLS.bind((String)keys[index], (Object[])args);
        return msg;
    }

    public static String getLocalizedMessage(UserNames names, String[] keys) {
        int index;
        Object[] args;
        String sysName = names.getPureSystemName();
        if (sysName == null) {
            args = new Object[]{names.getLogicalName()};
            index = 0;
        } else {
            args = new Object[]{names.getLogicalName(), sysName};
            index = 1;
        }
        String msg = NLS.bind((String)keys[index], (Object[])args);
        return msg;
    }
}

