/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.impl.ArtifactListVersionInfo;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTableOfContents;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactKey;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.MetaInfo;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.XMLParser;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ArtifactListParser {
    private static final CicCommonCorePluginTrace trace = ComIbmCicCommonCorePlugin.getTrace();

    public static List parseArtifactList(File file) throws CoreException, ParserConfigurationException, SAXException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            List list = ArtifactListParser.parseArtifactList(file.toString(), in);
            return list;
        }
        finally {
            FileUtil.close(in);
        }
    }

    public static IStatus parseArtifacts(Collection collection, File file) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            IStatus iStatus = ArtifactListParser.parseArtifacts(collection, file.toString(), in);
            return iStatus;
        }
        finally {
            FileUtil.close(in);
        }
    }

    public static IStatus parseArtifacts(Collection collection, String location, InputStream input) throws ParserConfigurationException, SAXException, IOException {
        trace.entering(location);
        ArtifactListHandler listHandler = new ArtifactListHandler(collection);
        listHandler.parse(input);
        IStatus status = listHandler.getStatus();
        if (status == null) {
            status = Status.OK_STATUS;
        }
        trace.exiting();
        return status;
    }

    public static List parseArtifactList(String location, InputStream input) throws CoreException, ParserConfigurationException, SAXException, IOException {
        trace.entering(location);
        LinkedList list = new LinkedList();
        IStatus status = ArtifactListParser.parseArtifacts(list, location, input);
        if (status.matches(4)) {
            throw new CoreException(status);
        }
        trace.exiting();
        return list;
    }

    private static class ArtifactListHandler
    extends XMLParser
    implements ArtifactListXMLConstants,
    ArtifactListVersionInfo {
        private static final int IGNORED_ELEMENT_STATE = 0;
        private static final int NO_CONTENT_STATE = 1;
        private static final int INITIAL_STATE = 2;
        private static final int ALIST_STATE = 3;
        private static final String[] STATE_NAMES = new String[]{"IGNORED", "NO CONTENT", "INITIAL", "alist"};
        private static final String ATTR_ROOT = "root";
        private static final String ATTR_VERSION = "version";
        private Version version;
        private Version effectiveVersion;
        private final Collection artifactKeys;

        ArtifactListHandler(Collection collection) {
            super(ComIbmCicCommonCorePlugin.getBundleContext(), ComIbmCicCommonCorePlugin.getPluginId());
            this.artifactKeys = collection;
            this.stateStack = new XMLParser.StateStack(STATE_NAMES);
        }

        synchronized Collection parse(InputStream in) throws SAXException, IOException, ParserConfigurationException {
            this.status = null;
            this.getParser().parse(in, (DefaultHandler)this);
            return this.artifactKeys;
        }

        @Override
        public void processingInstruction(String target, String data) {
            if ("alist".equals(target)) {
                this.version = MetaInfo.extractVersion(data);
            }
        }

        private void checkVersionCompatibility() {
            if (this.version == null) {
                this.checkRequiredAttribute(ATTR_ROOT, ATTR_VERSION, null);
                this.stateStack.push(0, null);
                return;
            }
            try {
                this.effectiveVersion = this.version;
                if (!ALIST_TOLERANCE.isIncluded(this.effectiveVersion)) {
                    this.addError(NLS.bind(Messages.ArtifactListParser_incompatible_version, (Object)this.version, (Object)ALIST_TOLERANCE));
                    this.stateStack.push(0, null);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.invalidAttributeValue(ATTR_ROOT, ATTR_VERSION, this.version.toString());
                this.stateStack.push(0, null);
            }
        }

        @Override
        public void startDocument() {
            this.stateStack.clear();
            this.stateStack.push(2, null);
        }

        @Override
        public void endDocument() {
        }

        private void handleInitialState(String element, Attributes attributes) {
            if (element.equals("alist")) {
                this.stateStack.push(3, this.artifactKeys);
            } else {
                this.unexpectedElementError(element, attributes);
            }
            this.checkVersionCompatibility();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attributes) {
            this.trace(name, attributes);
            switch (this.stateStack.peekState()) {
                case 0: {
                    this.stateStack.push(0, "error: " + name);
                    break;
                }
                case 2: {
                    this.handleInitialState(name, attributes);
                    break;
                }
                case 3: {
                    this.handleAlistState(name, attributes);
                    break;
                }
                case 1: {
                    this.unexpectedElementError(name, attributes);
                    break;
                }
                default: {
                    throw new XMLParser.BadStateError(this);
                }
            }
        }

        private void handleAlistState(String element, Attributes attributes) {
            if (element.equals("af")) {
                this.parseArtifactAttributes(attributes);
            } else {
                this.unexpectedElement(element, attributes);
                this.stateStack.push(1, null);
            }
        }

        private void parseArtifactAttributes(Attributes attributes) {
            String strNs = null;
            String strQual = null;
            String strId = null;
            Version elemVersion = null;
            Path elemPath = null;
            int i = 0;
            while (i < attributes.getLength()) {
                String attrName = attributes.getLocalName(i);
                String attrValue = attributes.getValue(i).trim();
                if (attrName.equals("n")) {
                    strNs = attrValue;
                } else if (attrName.equals("q")) {
                    strQual = attrValue;
                } else if (attrName.equals("id")) {
                    strId = attrValue;
                } else if (attrName.equals("v")) {
                    try {
                        elemVersion = new Version(attrValue);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.invalidAttributeValue("alist", attrName, attrValue);
                    }
                } else if (attrName.equals("p")) {
                    elemPath = new Path(attrValue);
                } else {
                    this.unexpectedAttribute("alist", attrName, attrValue);
                }
                ++i;
            }
            this.checkRequiredAttribute("alist", "n", strNs);
            this.checkRequiredAttribute("alist", "q", strQual);
            this.checkRequiredAttribute("alist", "id", strId);
            this.checkRequiredAttribute("alist", "v", elemVersion);
            Object parent = this.stateStack.peekObject();
            switch (this.stateStack.peekState()) {
                case 3: {
                    Path path;
                    Collection list = (Collection)parent;
                    Path path2 = path = elemPath == null ? Path.EMPTY : elemPath;
                    if (strNs != null && strQual != null && strId != null && elemVersion != null) {
                        ArtifactKey key = new ArtifactKey((IPath)path, strNs, strQual, new SimpleIdentity(strId), elemVersion);
                        list.add(key);
                    }
                    this.stateStack.push(1, null);
                    break;
                }
                default: {
                    throw new XMLParser.BadStateError(this, "af");
                }
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            this.trace(name, null);
            this.stateStack.pop();
        }

        @Override
        protected String getErrorMessage() {
            return Messages.ArtifactListParser_Error_Parsing_Artifact_List;
        }

        @Override
        protected Logger getLogger() {
            return Logger.getLogger(ArtifactListParser.class);
        }

        @Override
        protected Object getRootObject() {
            return null;
        }

        @Override
        protected String processCharacters(String trimmedChars) {
            return null;
        }
    }

    static interface ArtifactListXMLConstants
    extends ArtifactTableOfContents.XMLConstants {
        public static final String ELEM_ALIST = "alist";
    }
}

