/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractContentLocator;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractPathReadArtifactRepository;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractWriteArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTableOfContents;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactTocUpdate;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.internal.artifactrepo.ArtifactSession;
import com.ibm.cic.common.core.internal.artifactrepo.FileArtifactLocator;
import com.ibm.cic.common.core.internal.repository.DigestTableOfContents;
import com.ibm.cic.common.core.internal.repository.TableOfContents;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractPathWriteArtifactRepository
extends AbstractWriteArtifactRepo
implements IArtifactTocUpdate {
    private final AbstractPathReadArtifactRepository pathReadReposotory = new AbstractPathReadArtifactRepository(){

        @Override
        public IRepository getRepository() {
            return AbstractPathWriteArtifactRepository.this.getRepository();
        }

        @Override
        protected IPath getRepositoryPath(IArtifactKey key) throws CoreException {
            return AbstractPathWriteArtifactRepository.this.getRepositoryPath(key);
        }

        @Override
        protected IPath getRepositoryPath() throws CoreException {
            return AbstractPathWriteArtifactRepository.this.getRepositoryPath();
        }
    };

    protected abstract IPath getRepositoryPath(IArtifactKey var1) throws CoreException;

    protected abstract IPath getRepositoryPath() throws CoreException;

    @Override
    public IStatus initializeArtifactRepository(IRepositoryInfo repInfo) {
        return this.pathReadReposotory.initializeArtifactRepository(repInfo);
    }

    public abstract void createArtifactRepository(IRepositoryInfo var1) throws Exception;

    public abstract void deleteArtifactRepository();

    protected void doCreateArtifactRepository(IRepositoryInfo repInfo) throws Exception {
        if (UserOptions.getDontWriteAtoc()) {
            return;
        }
        Path basepath = new Path(repInfo.getLocationStr());
        try {
            ArtifactTableOfContents.Parameters atocParams = AbstractPathWriteArtifactRepository.getAtocParameters(repInfo);
            ArtifactTableOfContents.createToc(atocParams, (IPath)basepath, new ArtifactTableOfContents.IOnAtocSaved(){

                @Override
                public void onSave(IPath basePath, IPath fullPath, IContentInfo contentInfo, IProgressMonitor m) {
                    AbstractPathWriteArtifactRepository.this.onSave(basePath, fullPath, contentInfo, m);
                }
            });
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.create_artifact_toc_failed, (Object)basepath.toString());
            ICicStatus status = Statuses.ERROR.get(e, msg, new Object[0]);
            log.debug(status);
            throw new CoreException((IStatus)status);
        }
    }

    protected void doDeleteArtifactRepository() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            IReadArtifactRepo.IArtifactToc atoc = this.pathReadReposotory.readArtifactToc(null, (IProgressMonitor)monitor);
            if (atoc != null && atoc.getSummary().getCount() == 0) {
                IPath basepath = this.getRepositoryPath();
                ArtifactTableOfContents.Parameters atocParams = AbstractPathWriteArtifactRepository.getAtocParameters(this.getRepository().getRepositoryInfo());
                ArtifactTableOfContents.removeEmptyToc(atocParams, basepath);
            }
        }
        catch (CoreException e) {
            log.debug(e.getStatus());
        }
    }

    @Override
    protected IStatus doGetArtifactLocator(IArtifactSession session, IArtifact artifact, IContentInfo tocContentInfo, IProgressMonitor monitor, IArtifactLocator[] result) {
        return this.pathReadReposotory.doGetArtifactLocator(session, artifact, tocContentInfo, monitor, result);
    }

    @Override
    protected IStatus doAddArtifact(IArtifactSession session, IArtifact artifact, IContentLocator sourceLocator, IProgressMonitor monitor, IArtifactLocator[] outTargetLocator) {
        IPath targetPath;
        try {
            targetPath = this.getRepositoryPath(artifact.getKey());
        }
        catch (CoreException e) {
            return this.createAddArtifactError(artifact, e.getStatus());
        }
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{10, 1, 2});
        IDownloadedFile dlUncached = sourceLocator.downloadToFile(session, targetPath, pm.next());
        try {
            ICicStatus status = dlUncached.getStatus();
            if (status.matches(8)) {
                ICicStatus iCicStatus = status;
                return iCicStatus;
            }
            if (!status.isOK()) {
                session.log(status);
                if (status.matches(4)) {
                    IStatus iStatus = this.createAddArtifactError(artifact, status);
                    return iStatus;
                }
            }
            if (outTargetLocator == null) {
                ICicStatus iCicStatus = status;
                return iCicStatus;
            }
            ArrayList<IStatus> statusKeep = new ArrayList<IStatus>();
            statusKeep.add(status);
            SimpleContentInfo outContentInfo = new SimpleContentInfo();
            String[] digests = this.getTocPreferredDigests(session, pm.next());
            IStatus statusCompute = AbstractContentLocator.computeOutContentInfo(status, session, artifact, sourceLocator, dlUncached, pm.next(), digests, outContentInfo);
            if (!statusCompute.isOK()) {
                statusKeep.add(statusCompute);
            }
            if (statusCompute.matches(12)) {
                File file = dlUncached.getFile();
                if (file != null) {
                    FileUtil.rm(file);
                }
                if (statusCompute.matches(4)) {
                    IStatus iStatus = this.createAddArtifactError(artifact, statusKeep.toArray(new IStatus[statusKeep.size()]));
                    return iStatus;
                }
                if (statusCompute.matches(8)) {
                    IStatus iStatus = statusCompute;
                    return iStatus;
                }
            }
            IArtifact artifactForToc = this.getArtifactForTocLogIssues(artifact, sourceLocator, dlUncached, targetPath, outContentInfo);
            outTargetLocator[0] = new FileArtifactLocator(this.getRepository(), artifactForToc, outContentInfo, targetPath.toFile());
            ICicStatus iCicStatus = status;
            return iCicStatus;
        }
        catch (CoreException e) {
            IStatus iStatus = this.createAddArtifactError(artifact, e.getStatus());
            return iStatus;
        }
        finally {
            pm.done();
        }
    }

    protected abstract void doRemoveArtifactFile(IArtifactLocator var1, IPath var2, IProgressMonitor var3) throws CoreException;

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.pathReadReposotory.readArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) {
        return this.pathReadReposotory.readCachedArtifactToc(session, tocCache, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return this.pathReadReposotory.getArtifactTocCapabilities();
    }

    @Override
    protected IStatus doRemoveArtifact(IArtifactSession session, IArtifactLocator locator, IProgressMonitor monitor) {
        try {
            IPath targetPath = this.getRepositoryPath(locator.getArtifactKey());
            this.doRemoveArtifactFile(locator, targetPath, monitor);
        }
        catch (CoreException e) {
            return this.createRemoveArtifactError(locator.getArtifactKey(), e.getStatus(), null);
        }
        return Status.OK_STATUS;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IArtifactTocUpdate.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    private void onSave(IPath basePath, IPath fullPath, IContentInfo contentInfo, IProgressMonitor monitor) {
        ICicLocation digestTocLocation = this.getRepository().getLocation().append("");
        IPath relativePath = PathUtil.makeRelative((IPath)new Path(digestTocLocation.toString()), fullPath);
        TableOfContents.TocEntry tocEntry = new TableOfContents.TocEntry(relativePath.toString(), null, contentInfo);
        Set<TableOfContents.TocEntry> entriesToAdd = Collections.singleton(tocEntry);
        DigestTableOfContents.addTocEntries(digestTocLocation, entriesToAdd, monitor);
    }

    @Override
    public IStatus updateArtifactTocAddOrChange(IArtifactSession session, IArtifact[] artifacts, IProgressMonitor monitor) {
        if (UserOptions.getDontWriteAtoc()) {
            return Status.OK_STATUS;
        }
        IStatus status = this.getRepository().getStatus(false, monitor);
        if (status.isOK()) {
            IPath basepath;
            try {
                basepath = this.getRepositoryPath();
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            status = Status.OK_STATUS;
            try {
                ArtifactTableOfContents.Parameters atocParams = AbstractPathWriteArtifactRepository.getAtocParameters(this.getRepository().getRepositoryInfo());
                ArtifactTableOfContents.addOrUpdateTocArtifacts(session, atocParams, basepath, artifacts, new ArtifactTableOfContents.IOnAtocSaved(){

                    @Override
                    public void onSave(IPath basePath, IPath fullPath, IContentInfo contentInfo, IProgressMonitor m) {
                        AbstractPathWriteArtifactRepository.this.onSave(basePath, fullPath, contentInfo, m);
                    }
                }, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                ArtifactSession.asSessionAtoc(session).setArtifactToc(this, null);
            }
            catch (Exception e) {
                String msg = NLS.bind((String)Messages.update_artifact_toc_failed, (Object)basepath.toString());
                status = Statuses.ERROR.get(122, e, msg, new Object[0]);
            }
        }
        return status;
    }

    @Override
    public IStatus updateArtifactTocRemove(IArtifactSession session, IArtifact[] artifacts, IProgressMonitor monitor) {
        monitor.beginTask("", 1);
        try {
            if (UserOptions.getDontWriteAtoc()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            IStatus status = this.getRepository().getStatus(false, monitor);
            if (status.isOK()) {
                IPath basepath;
                try {
                    basepath = this.getRepositoryPath();
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    monitor.done();
                    return iStatus;
                }
                status = Status.OK_STATUS;
                try {
                    ArtifactTableOfContents.Parameters atocParams = AbstractPathWriteArtifactRepository.getAtocParameters(this.getRepository().getRepositoryInfo());
                    ArtifactTableOfContents.removeTocEntries(session, atocParams, basepath, artifacts, new ArtifactTableOfContents.IOnAtocSaved(){

                        @Override
                        public void onSave(IPath basePath, IPath fullPath, IContentInfo contentInfo, IProgressMonitor m) {
                            AbstractPathWriteArtifactRepository.this.onSave(basePath, fullPath, contentInfo, m);
                        }
                    }, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                    ArtifactSession.asSessionAtoc(session).setArtifactToc(this, null);
                    monitor.worked(1);
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)Messages.update_artifact_toc_failed, (Object)basepath.toString());
                    status = Statuses.ERROR.get(122, e, msg, new Object[0]);
                }
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }
}

