/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.base;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.base.ArtifactsByDiskOperation;
import com.ibm.cic.common.core.artifactrepo.base.GetArtifactFiles;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperationMultiple;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractDiskOperation;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GetArtifactFilesByDisk
extends ArtifactsByDiskOperation {
    private static final IArtifactOperationMultiple INSTANCE = new GetArtifactFilesByDisk();

    protected GetArtifactFilesByDisk() {
        super(true);
    }

    @Override
    public IMultiArtifactOperationArguments createArguments() {
        return new GetArtifactFiles.GetFilesArguments();
    }

    private static IArtifactOperation.IOperationContext createOperationTarget(IReadArtifactRepo repo) {
        return new GetArtifactFiles.GetContext(repo);
    }

    public static void getArtifactFiles(IReadArtifactRepo repo, IArtifactSession session, IMultiArtifactOperationArguments args, IProgressMonitor monitor) {
        INSTANCE.execute(session, GetArtifactFilesByDisk.createOperationTarget(repo), MultiArtifactOperationOptions.newBreakOnErrorOptions(), args, monitor);
    }

    @Override
    protected void doExecute(IArtifactSession session, IArtifactOperation.IOperationContext target, IMultiArtifactOperationArguments args, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
        if (!(target instanceof GetArtifactFiles.GetContext)) {
            throw new IllegalArgumentException();
        }
        GetArtifactFiles.GetContext getTarget = (GetArtifactFiles.GetContext)target;
        IReadArtifactRepo repo = getTarget.getRepo();
        if (repo == null) {
            throw new IllegalArgumentException();
        }
        GetArtifactFilesDiskOperation diskOperation = new GetArtifactFilesDiskOperation(args);
        super.doExecuteDiskOperation(session, diskOperation, target, args, options, monitor);
    }

    private static class GetArtifactFilesDiskOperation
    extends AbstractDiskOperation
    implements IVolumeAccessByDisk.IDiskOperation {
        private final IMultiArtifactOperationArguments args;

        GetArtifactFilesDiskOperation(IMultiArtifactOperationArguments args) {
            super(INSTANCE);
            this.args = args;
        }

        @Override
        public IArtifact getArtifact(IArtifactOperation.IArtifactOperationRecord record) {
            IArtifactOperation.IArtifactOperationInput input = record.getInput();
            if (input instanceof GetArtifactFiles.GetFilesInput) {
                GetArtifactFiles.GetFilesInput getInput = (GetArtifactFiles.GetFilesInput)input;
                IArtifact artifact = getInput.getArtifact();
                return artifact;
            }
            return null;
        }

        @Override
        public IStatus useDisk(IArtifactSession session, IRepository repo, IVolumeAccessByDisk.IDisk disk, IVolumeAccessByDisk.IDiskSetDisks allUsedDisks, IMultiArtifactOperationArguments diskArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, diskArgs.getRecordCount());
            try {
                for (IArtifactOperation.IArtifactOperationRecord record : diskArgs.getRecords()) {
                    GetArtifactFiles.GetFilesInput fileInput = (GetArtifactFiles.GetFilesInput)record.getInput();
                    IArtifact artifact = fileInput.getArtifact();
                    IPath destination = fileInput.getDestination();
                    IStatus status = RepoAs.IArtifactGet(repo).getArtifactFile(session, artifact, destination, spm.next());
                    if (StatusCodes.isContentNotFound(status)) {
                        record.getHistory().setHistoryStatus(session, status);
                        continue;
                    }
                    if (status.matches(8)) {
                        this.args.setFailedOperationStatus(status);
                        IStatus iStatus = status;
                        return iStatus;
                    }
                    if (!options.getContinueOnError() && status.matches(4)) {
                        record.getHistory().setHistoryStatus(session, status);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    record.getHistory().setHistoryStatus(session, status);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                spm.done();
            }
        }

        @Override
        public CicMultiStatus getMultiStatus() {
            String msg = Messages.get_artifact_files_failed_multistatus;
            CicMultiStatus statusFailed = Statuses.ST.createMultiStatus(3, msg, new Object[0]);
            return statusFailed;
        }

        @Override
        public IRepository getSourceRepo(IArtifactOperation.IOperationContext context) {
            return (IRepository)((GetArtifactFiles.GetContext)context).getRepo();
        }

        @Override
        public IArtifactOperation.IOperationContext getSubContext(IRepository repo) {
            return new GetArtifactFiles.GetContext(repo);
        }
    }
}

