/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.base;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.base.ArtifactOperationMultiple;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperationMultiple;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactGet;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.artifactrepo.ArtifactRecords;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreDebugOptions;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreTrace;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.repository.StatusCodes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GetArtifactFiles
extends ArtifactOperationMultiple {
    public static final IArtifactOperationMultiple INSTANCE = new GetArtifactFiles();

    public GetArtifactFiles() {
        super(true);
    }

    @Override
    public IMultiArtifactOperationArguments createArguments() {
        return new GetFilesArguments();
    }

    public static IArtifactOperation.IArtifactOperationInput createGetRequest(IArtifact artifact, IPath path) {
        return new GetFilesInput(artifact, path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doExecute(IArtifactSession session, IArtifactOperation.IOperationContext target, IMultiArtifactOperationArguments multiArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
        if (!(target instanceof GetContext)) {
            throw new IllegalArgumentException();
        }
        GetContext getTarget = (GetContext)target;
        IReadArtifactRepo repo = getTarget.getRepo();
        if (repo == null) {
            throw new IllegalArgumentException();
        }
        monitor.beginTask("", multiArgs.getRecords().size());
        try {
            IArtifactGet aget = (IArtifactGet)repo.getAdapter(IArtifactGet.class);
            for (IArtifactOperation.IArtifactOperationRecord dlRecord : multiArgs.getRecords()) {
                IArtifactOperation.IArtifactOperationInput dlInput;
                IStatus status = dlRecord.getLastStatus();
                if (status != IArtifactOperation.STATUS_OK_REQUESTED || !((dlInput = dlRecord.getInput()) instanceof GetFilesInput)) continue;
                MultiArtifactOperationOptions.ProcessRecordListener fireRecordProcessing = options.getFireEvents();
                fireRecordProcessing.onBeforeRecord(options, dlRecord);
                GetFilesInput getFilesInput = (GetFilesInput)dlInput;
                IStatus dlStatus = aget.getArtifactFile(session, getFilesInput.getArtifact(), getFilesInput.getDestination(), (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
                dlRecord.getHistory().setHistoryStatus(session, dlStatus);
                fireRecordProcessing.onProcessedRecord(options, multiArgs, dlRecord, true);
                if (dlStatus.getSeverity() == 8) {
                    multiArgs.setCanceled();
                    return;
                }
                if (StatusCodes.isContentNotFound(dlStatus) || options.getContinueOnError() || !dlStatus.matches(4)) continue;
                return;
            }
            return;
        }
        finally {
            monitor.done();
        }
    }

    static class GetContext
    extends IArtifactOperation.AbstractOperationContext {
        private final IReadArtifactRepo repo;

        public GetContext(IReadArtifactRepo repo) {
            this.repo = repo;
        }

        public IReadArtifactRepo getRepo() {
            return this.repo;
        }

        @Override
        public void release() {
        }
    }

    static class GetFilesArguments
    extends ArtifactRecords {
        private static final CicCommonCoreTrace trace = new CicCommonCoreTrace(ComIbmCicCommonCorePlugin.getDefault(), CicCommonCoreDebugOptions.REPOSITORY_DUPLICATE_GET_ARTIFACT_FILES);
        private final Map<IArtifactKey, List<IPath>> requestMap = new HashMap<IArtifactKey, List<IPath>>();

        GetFilesArguments() {
        }

        private boolean isRequested(IArtifact artifact, IPath downloadLocation) {
            return this.findRequest(artifact, downloadLocation) != null;
        }

        private void addRequest(IArtifact artifact, IPath downloadLocation) {
            IArtifactKey key = artifact.getKey();
            List<IPath> requests = this.requestMap.get(key);
            if (requests == null) {
                requests = new ArrayList<IPath>();
                this.requestMap.put(key, requests);
            }
            requests.add(downloadLocation);
        }

        private IPath findRequest(IArtifact artifact, IPath downloadLocation) {
            IArtifactKey key = artifact.getKey();
            List<IPath> requests = this.requestMap.get(key);
            if (requests == null) {
                return null;
            }
            for (IPath targetLocation : requests) {
                if (!targetLocation.equals((Object)downloadLocation)) continue;
                return targetLocation;
            }
            return null;
        }

        private boolean checkNotDuplicate(IArtifactOperation.IArtifactOperationInput request) {
            if (request instanceof GetFilesInput) {
                GetFilesInput getFile = (GetFilesInput)request;
                IPath downloadLocation = getFile.getDestination();
                IArtifact artifact = getFile.getArtifact();
                if (downloadLocation.toFile().exists() && GetFilesArguments.trace.enabled) {
                    trace.println("Already downloaded? Artifact '" + artifact.toUserString() + "' location='" + downloadLocation.toString() + "'");
                }
                if (this.isRequested(artifact, downloadLocation)) {
                    if (GetFilesArguments.trace.enabled) {
                        trace.println("Ignoring duplicate download: " + artifact.toUserString() + " to " + downloadLocation.toString());
                    }
                } else {
                    this.addRequest(artifact, downloadLocation);
                    return true;
                }
            }
            return false;
        }

        @Override
        public IArtifactOperation.IArtifactOperationRecord addInput(IArtifactOperation.IArtifactOperationInput request) {
            if (this.checkNotDuplicate(request)) {
                return super.addInput(request);
            }
            return null;
        }

        @Override
        public void addRecord(IArtifactOperation.IArtifactOperationRecord record) {
            if (this.checkNotDuplicate(record.getInput())) {
                super.addRecord(record);
            }
        }
    }

    public static class GetFilesInput
    implements IArtifactOperation.IArtifactOperationInput {
        private final IArtifact artifact;
        private final IPath destination;

        GetFilesInput(IArtifact artifact, IPath destination) {
            this.artifact = artifact;
            this.destination = destination;
        }

        public IArtifact getArtifact() {
            return this.artifact;
        }

        public IPath getDestination() {
            return this.destination;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("artifact='");
            sb.append(this.artifact.toString());
            sb.append("' destination='");
            sb.append(this.destination.toString());
            sb.append("'");
            return sb.toString();
        }
    }
}

