/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.core.internal.action;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import org.w3c.dom.Document;

public class NGIAction {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public String component = null;
    public int progress = -1;
    private InstallToolkitBridge m_itb = null;
    private String[] m_asMetaDataURIs = null;
    private String[] m_asPluginPaths = null;
    private StringBuffer m_sbMessage = null;
    private final String className = "NGIAction";

    private final PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    public final void firePropertyChange(String propertyName, int i, int percent) {
        this.getPropertyChangeSupport().firePropertyChange(propertyName, i, percent);
        this.progress = percent;
    }

    public final void firePropertyChange(String propertyName, String oldComp, String newComp) {
        this.getPropertyChangeSupport().firePropertyChange(propertyName, oldComp, newComp);
        this.component = newComp;
    }

    public NGIAction(InstallToolkitBridge itb, String[] asMetaDataURIs, String[] asPluginPaths) {
        Logr.methodEntry((String)"NGIAction", (String)"NGIAction");
        this.m_itb = itb;
        this.m_asMetaDataURIs = asMetaDataURIs == null ? new String[]{} : new String[asMetaDataURIs.length];
        int i = 0;
        while (i < this.m_asMetaDataURIs.length) {
            this.m_asMetaDataURIs[i] = MacroResolver.resolveMacro((String)asMetaDataURIs[i], (InstallToolkitBridge)this.m_itb, null);
            ++i;
        }
        this.m_asPluginPaths = asPluginPaths == null ? new String[]{} : new String[asPluginPaths.length];
        i = 0;
        while (i < this.m_asPluginPaths.length) {
            this.m_asPluginPaths[i] = MacroResolver.resolveMacro((String)asPluginPaths[i], (InstallToolkitBridge)this.m_itb, null);
            ++i;
        }
        this.m_sbMessage = new StringBuffer();
        Logr.methodExit((String)"NGIAction", (String)"NGIAction");
    }

    public final int execute() throws Exception {
        try {
            Logr.methodEntry((String)"NGIAction", (String)"execute");
            FileSystemEntry[] afse = this.getAllFileSystemEntries();
            int nReturnCode = 0;
            int i = 0;
            while (nReturnCode != 1 && i < afse.length) {
                int nReturnCodeThis = this.executeThisEntry(afse[i]);
                nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority((int)nReturnCode, (int)nReturnCodeThis);
                ++i;
            }
            Logr.methodExit((String)"NGIAction", (String)"execute");
            return nReturnCode;
        }
        catch (Exception e) {
            e.printStackTrace();
            Logr.error((String)"NGIAction", (String)"execute", (String)e.getMessage(), (Exception)e);
            throw e;
        }
    }

    public String getMessage() {
        return this.m_sbMessage.toString();
    }

    public void appendMessage(Object message) {
        this.m_sbMessage.append(message.toString());
    }

    public String[] getMetaDataURIs() {
        return this.m_asMetaDataURIs;
    }

    public String[] getPluginPaths() {
        return this.m_asPluginPaths;
    }

    protected int executePlugin(NIFPlugin nifp) throws Exception {
        return 0;
    }

    private FileSystemEntry[] getAllFileSystemEntries() throws IOException, URISyntaxException {
        Vector<FileSystemEntry> vfse = new Vector<FileSystemEntry>();
        Logr.methodEntry((String)"NGIAction", (String)"getAllFileSystemEntries");
        String[] stringArray = this.m_asMetaDataURIs;
        int n = this.m_asMetaDataURIs.length;
        int n2 = 0;
        while (n2 < n) {
            String m_asMetaDataURI = stringArray[n2];
            FileSystemEntry fse = new FileSystemEntry(new URI(m_asMetaDataURI), this.m_itb);
            if (fse.exists()) {
                vfse.add(fse);
            }
            ++n2;
        }
        FileSystemEntry[] afse = new FileSystemEntry[vfse.size()];
        int i = 0;
        while (i < vfse.size()) {
            afse[i] = (FileSystemEntry)vfse.elementAt(i);
            ++i;
        }
        Logr.methodExit((String)"NGIAction", (String)"getAllFileSystemEntries");
        return afse;
    }

    private int executeThisEntry(FileSystemEntry fse) throws Exception {
        Logr.methodEntry((String)"NGIAction", (String)"executeThisEntry");
        int nReturnCode = 0;
        int i = 0;
        while (nReturnCode != 1 && i < this.m_asPluginPaths.length) {
            int nReturnCodeThis = this.exeuteThisPluginPathInThisEntry(this.m_asPluginPaths[i], fse);
            nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority((int)nReturnCode, (int)nReturnCodeThis);
            ++i;
        }
        Logr.methodExit((String)"NGIAction", (String)"executeThisEntry");
        return nReturnCode;
    }

    private int exeuteThisPluginPathInThisEntry(String sPluginPath, FileSystemEntry fse) throws Exception {
        Logr.methodEntry((String)"NGIAction", (String)"exeuteThisPluginPathInThisEntry");
        NIFPlugin[] anifp = NIFPlugin.createPlugins((Document)XMLUtils.getSimpleXMLParserFromFileSystemEntry((FileSystemEntry)fse).getDocument(), (String)sPluginPath, (InstallToolkitBridge)this.m_itb);
        int nReturnCode = 0;
        int i = 0;
        while (nReturnCode != 1 && anifp != null && i < anifp.length) {
            int nReturnCodeThis = this.executePlugin(anifp[i]);
            nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority((int)nReturnCode, (int)nReturnCodeThis);
            ++i;
        }
        Logr.methodExit((String)"NGIAction", (String)"exeuteThisPluginPathInThisEntry");
        return nReturnCode;
    }
}

