/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.utils;

import com.ibm.websphere.product.WASDirectoryException;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;

public class WASDirectoryHelper {
    public static final String ID_BASE = "BASE";
    public static final String ID_EXPRESS = "EXPRESS";
    public static final String ID_ND = "ND";
    public static final String ID_PME = "PME";
    public static final String ID_WBI = "WBI";
    public static final String ID_JDK = "JDK";
    public static final String ID_EMBEDDED_EXPRESS = "embeddedEXPRESS";
    public static final String ID_XD = "XD";
    public static final String ID_CLIENT = "CLIENT";
    public static final String ID_PLUGIN = "PLG";
    public static final String ID_IHS = "IHS";
    public static final String ID_WXD = "WXD";
    public static final String ID_NDDMZ = "NDDMZ";
    private static final String ID_SUFFIX_TRIAL = "TRIAL";
    private static final String ID_SUFFIX_NONV61 = "_NONV61";
    public static final String ID_BASE_NONV61 = "BASE_NONV61";
    public static final String ID_BASETRIAL = "BASETRIAL";
    public static final String ID_BASETRIAL_NONV61 = "BASETRIAL_NONV61";
    public static final String ID_EXPRESS_NONV61 = "EXPRESS_NONV61";
    public static final String ID_EXPRESSTRIAL = "EXPRESSTRIAL";
    public static final String ID_EXPRESSTRIAL_NONV61 = "EXPRESSTRIAL_NONV61";
    public static final String ID_ND_NONV61 = "ND_NONV61";
    public static final String ID_CLIENT_NONV61 = "CLIENT_NONV61";
    private static final char C_WINDOWS_FILE_SEPARATOR = '\\';
    private static final char C_LINUX_FILE_SEPARATOR = '/';
    private static final String S_URI_PATH_SEPARATOR = "/";
    public static final String INSTALL_ROOT_PROPERTY_NAME = "was.install.root";
    public static final String VERSION_DIR_PROPERTY_NAME = "was.version.dir";
    public static final String DTD_DIR_PROPERTY_NAME = "was.version.dtd.dir";
    public static final String LOG_DIR_PROPERTY_NAME = "was.version.log.dir";
    public static final String BACKUP_DIR_PROPERTY_NAME = "was.version.backup.dir";
    public static final String TMP_DIR_PROPERTY_NAME = "was.version.tmp.dir";
    public static final String JAVA_TMP_DIR_PROPERTY_NAME = "java.io.tmpdir";
    public static final String PROPERTIES_DIR_NAME = "properties";
    public static final String VERSION_DIR_NAME = "version";
    public static final String HISTORY_DIR_NAME = "history";
    public static final String DTD_DIR_NAME = "dtd";
    public static final String LOG_DIR_NAME = "logs";
    public static final String UPDATE_DIR_NAME = "update";
    public static final String BACKUP_DIR_NAME = "backup";
    public static final String DEFAULT_TMP_DIR_NAME = "tmp";
    public static final String FULL_INSTALL_DIR_NAME = "install";
    public static final String NIF_DIR_NAME = "nif";
    public static final String NIF_HISTORY_XML_FILENAME = "NIFHistory.xml";
    public static final String MAINTENANCE_HISTORY_XML_FILENAME = "maintenanceHistory.xml";
    public static final String S_DOT = ".";
    public static final String S_UPDATE_LOG_FILE_NAME = "updatelog";
    public static final String S_TEXT_FILE_EXT = ".txt";

    public static String normalizedProductID(String string) {
        if (ID_BASETRIAL.equalsIgnoreCase(string) || ID_BASE_NONV61.equalsIgnoreCase(string) || ID_BASETRIAL_NONV61.equalsIgnoreCase(string)) {
            return ID_BASE;
        }
        if (ID_EXPRESSTRIAL.equalsIgnoreCase(string) || ID_EXPRESS_NONV61.equalsIgnoreCase(string) || ID_EXPRESSTRIAL_NONV61.equalsIgnoreCase(string)) {
            return ID_EXPRESS;
        }
        if (ID_ND_NONV61.equalsIgnoreCase(string)) {
            return ID_ND;
        }
        if (ID_CLIENT_NONV61.equalsIgnoreCase(string)) {
            return ID_CLIENT;
        }
        return string;
    }

    public static String normalizeLocation(String string, boolean bl) {
        if (string != null) {
            if ((string = string.replace('\\', '/')).endsWith(S_URI_PATH_SEPARATOR)) {
                if (!bl) {
                    string = string.substring(0, string.length() - S_URI_PATH_SEPARATOR.length());
                }
            } else if (bl) {
                string = string + S_URI_PATH_SEPARATOR;
            }
            return string;
        }
        return null;
    }

    public static String normalizeLocationNoEndingSlash(String string) {
        return WASDirectoryHelper.normalizeLocation(string, false);
    }

    public static String normalizeLocationAccordingToPlatform(String string, boolean bl) {
        if (string != null) {
            string = string.replace('\\', File.separatorChar);
            if ((string = string.replace('/', File.separatorChar)).endsWith(File.separator)) {
                if (!bl) {
                    string = string.substring(0, string.length() - File.separator.length());
                }
            } else if (bl) {
                string = string + File.separator;
            }
        }
        return string;
    }

    public static String getInstallRootPath() throws WASDirectoryException {
        String string = System.getProperty(INSTALL_ROOT_PROPERTY_NAME);
        if (string == null) {
            throw new WASDirectoryException("WVER0001E", null, null);
        }
        string = WASDirectoryHelper.normalizeLocationAccordingToPlatform(string, false);
        return string;
    }

    public static String getVersionDirPath(String string) {
        if (string != null) {
            return WASDirectoryHelper.normalizeLocationAccordingToPlatform(string, true) + PROPERTIES_DIR_NAME + File.separator + VERSION_DIR_NAME;
        }
        return null;
    }

    public static String getLogDirPath(String string) {
        if (string != null) {
            return WASDirectoryHelper.normalizeLocationAccordingToPlatform(string, true) + LOG_DIR_NAME;
        }
        return null;
    }

    public static String getBackupDirPath(String string) {
        if (string != null) {
            String string2 = WASDirectoryHelper.getVersionDirPath(string);
            String string3 = string2 + File.separator + UPDATE_DIR_NAME + File.separator + BACKUP_DIR_NAME;
            if (new File(string3).exists()) {
                return string3;
            }
            return string2 + File.separator + NIF_DIR_NAME + File.separator + BACKUP_DIR_NAME;
        }
        return null;
    }

    public static String getHistoryDirPath(String string) {
        if (string != null) {
            String string2 = WASDirectoryHelper.getVersionDirPath(string);
            return string2 + File.separator + HISTORY_DIR_NAME;
        }
        return null;
    }

    public static String getDTDDirPath(String string) {
        if (string != null) {
            String string2 = WASDirectoryHelper.getVersionDirPath(string);
            return string2 + File.separator + DTD_DIR_NAME;
        }
        return null;
    }

    public static String getTmpDirPath() {
        String string = System.getProperty(TMP_DIR_PROPERTY_NAME);
        if (string == null && (string = System.getProperty(JAVA_TMP_DIR_PROPERTY_NAME)) == null) {
            string = DEFAULT_TMP_DIR_NAME;
        }
        string = WASDirectoryHelper.normalizeLocationAccordingToPlatform(string, false);
        return string;
    }

    public static String getCurrentTimestamp() {
        Date date = new Date(System.currentTimeMillis());
        return DateFormat.getDateTimeInstance(1, 1).format(date);
    }
}

