/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.metadata;

import com.ibm.websphere.product.history.xml.eventHistory;
import com.ibm.websphere.product.logger.WASDirectoryLogger;
import com.ibm.websphere.product.metadata.WASComponent;
import com.ibm.websphere.product.metadata.WASComponentUpdate;
import com.ibm.websphere.product.metadata.WASMaintenancePackage;
import com.ibm.websphere.product.metadata.WASMetadataHelper;
import com.ibm.websphere.product.utils.HistoryInfoEntityResolver;
import com.ibm.websphere.product.utils.SimpleXMLParser;
import com.ibm.websphere.product.utils.WASDirectoryHelper;
import com.ibm.websphere.product.xml.component.component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WASMetadata {
    private static HashMap wasMetadataInstances = new HashMap();
    private static final String S_PATH_MAINTENANCE = "maintenance-history/maintenance";
    private String installRoot = null;
    private WASDirectoryLogger logger = null;
    private long lastModifyHistoryFile = 0L;
    private eventHistory eventHistoryInstance = new eventHistory();
    private Vector historyMaintenancePackages = new Vector();
    private LinkedHashMap installedMaintenancesMap = new LinkedHashMap();
    private LinkedHashMap installedComponentsMap = new LinkedHashMap();
    private LinkedHashMap installedPTFsMap = new LinkedHashMap();
    private LinkedHashMap installedPTFAppliedMap = new LinkedHashMap();
    private LinkedHashMap installedPTFDriverMap = new LinkedHashMap();

    public static WASMetadata getWASMetadataInstance(String string) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if ((string = WASDirectoryHelper.normalizeLocationAccordingToPlatform(string, false)) == null || !new File(string).exists()) {
            return null;
        }
        WASMetadata wASMetadata = (WASMetadata)wasMetadataInstances.get(string);
        if (wASMetadata == null) {
            wASMetadata = new WASMetadata(string);
            wasMetadataInstances.put(string, wASMetadata);
        }
        return wASMetadata;
    }

    public WASMaintenancePackage[] getHistoryMaintenancePackageList() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return this.historyMaintenancePackages.toArray(new WASMaintenancePackage[this.historyMaintenancePackages.size()]);
    }

    public WASComponent[] getInstalledComponentList() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        Vector vector = new Vector(this.installedComponentsMap.values());
        return vector.toArray(new WASComponent[vector.size()]);
    }

    public WASMaintenancePackage[] getInstalledMaintenancePackageList() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        Vector vector = new Vector(this.installedMaintenancesMap.values());
        return vector.toArray(new WASMaintenancePackage[vector.size()]);
    }

    public WASComponent getInstalledComponentByName(String string) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return (WASComponent)this.installedComponentsMap.get(string);
    }

    public WASMaintenancePackage getInstalledMaintenancePackageByID(String string) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return (WASMaintenancePackage)this.installedMaintenancesMap.get(string);
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    public Vector getComponentVector() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        Vector<component> vector = new Vector<component>();
        for (int i = 0; i < this.getInstalledComponentList().length; ++i) {
            vector.add(this.getInstalledComponentList()[i].getComponent());
        }
        vector.trimToSize();
        return vector;
    }

    public eventHistory getEventHistory() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return this.eventHistoryInstance;
    }

    public Vector getPTFVector() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return new Vector(this.installedPTFsMap.values());
    }

    public Vector getPTFAppliedVector() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return new Vector(this.installedPTFAppliedMap.values());
    }

    public Vector getPTFDriverVector() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return new Vector(this.installedPTFDriverMap.values());
    }

    public void resetCachedData() {
        this.historyMaintenancePackages.clear();
        this.installedComponentsMap.clear();
        this.installedMaintenancesMap.clear();
        this.installedPTFAppliedMap.clear();
        this.installedPTFDriverMap.clear();
        this.installedPTFsMap.clear();
        this.eventHistoryInstance = new eventHistory();
        this.logger.logThisMessage(Level.INFO, this.getClass().getName(), "resetCachedData", "Reset cached data.");
    }

    protected WASMetadata(String string) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this.setInstallRoot(string);
        this.setLogger(WASDirectoryLogger.getWASDirectoryLogger(string));
        this.logger.entering(this.getClass().getName(), "WASMetadata");
        this.parseMetadataFiles();
        this.logger.exiting(this.getClass().getName(), "WASMetadata");
    }

    protected void assignComponentUpdatesToComponent() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this.logger.entering(this.getClass().getName(), "assignComponentUpdatesToComponent");
        WASMaintenancePackage[] wASMaintenancePackageArray = this.getInstalledMaintenancePackageList();
        for (int i = 0; i < wASMaintenancePackageArray.length; ++i) {
            WASMaintenancePackage wASMaintenancePackage = wASMaintenancePackageArray[i];
            WASComponentUpdate[] wASComponentUpdateArray = wASMaintenancePackage.getComponentUpdateList();
            for (int j = 0; j < wASComponentUpdateArray.length; ++j) {
                String string = wASComponentUpdateArray[j].getComponentName();
                if (string == null) continue;
                WASComponent wASComponent = this.getInstalledComponentByName(string);
                if (wASComponent != null) {
                    wASComponent.addComponentUpdateToList(wASComponentUpdateArray[j]);
                    continue;
                }
                this.logger.logThisMessage(Level.WARNING, this.getClass().getName(), "assignComponentUpdatesToComponent", "Component Update with this name: " + string + " could not associate with an existing component");
            }
        }
        this.logger.exiting(this.getClass().getName(), "assignComponentUpdatesToComponent");
    }

    protected void parseMetadataFiles() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this.logger.entering(this.getClass().getName(), "parseMetadataFiles");
        try {
            this.resetCachedData();
            File file = new File(WASMetadataHelper.getHistoryXmlPath(this.installRoot));
            if (!file.exists()) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            this.parseHistoryXmlFile(this.installRoot, fileInputStream);
            this.parseComponentFiles(this.installRoot);
            this.assignComponentUpdatesToComponent();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseMetadataFiles", fileNotFoundException.getMessage(), fileNotFoundException);
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseMetadataFiles", iOException.getMessage(), iOException);
            throw iOException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseMetadataFiles", parserConfigurationException.getMessage(), parserConfigurationException);
            throw parserConfigurationException;
        }
        catch (SAXException sAXException) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseMetadataFiles", sAXException.getMessage(), sAXException);
            throw sAXException;
        }
        this.logger.exiting(this.getClass().getName(), "parseMetadataFiles");
    }

    protected void parseHistoryXmlFile(String string, InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        this.logger.entering(this.getClass().getName(), "parseHistoryXmlFile");
        if (inputStream != null) {
            try {
                SimpleXMLParser simpleXMLParser = new SimpleXMLParser(inputStream, false);
                Vector vector = simpleXMLParser.getNodes(S_PATH_MAINTENANCE);
                for (int i = 0; i < vector.size(); ++i) {
                    Node node = (Node)vector.elementAt(i);
                    WASMaintenancePackage wASMaintenancePackage = new WASMaintenancePackage(string, node);
                    this.eventHistoryInstance.addUpdateEvent(wASMaintenancePackage.getUpdateEventForThisMaintenancePackage());
                    if (!wASMaintenancePackage.isInstallAsMaintenance()) continue;
                    this.historyMaintenancePackages.addElement(wASMaintenancePackage);
                    if (wASMaintenancePackage.getAction().equals("install") && !wASMaintenancePackage.getResult().equals("failure")) {
                        this.logger.logThisMessage(Level.INFO, this.getClass().getName(), "parseHistoryXmlFile", "This maintenance is installed: " + wASMaintenancePackage.getMaintenancePackageID() + " with status: " + wASMaintenancePackage.getResult());
                        this.installedMaintenancesMap.put(wASMaintenancePackage.getMaintenancePackageID(), wASMaintenancePackage);
                        this.installedPTFsMap.put(wASMaintenancePackage.getMaintenancePackageID(), wASMaintenancePackage.getPTFForThisMaintenancePackage());
                        this.installedPTFAppliedMap.put(wASMaintenancePackage.getMaintenancePackageID(), wASMaintenancePackage.getPTFAppliedForThisMaintenancePackage());
                        this.installedPTFDriverMap.put(wASMaintenancePackage.getMaintenancePackageID(), wASMaintenancePackage.getPTFDriverForThisMaintenancePackage());
                        continue;
                    }
                    if (!wASMaintenancePackage.getAction().equals("uninstall") || wASMaintenancePackage.getResult().equals("failure")) continue;
                    this.logger.logThisMessage(Level.INFO, this.getClass().getName(), "parseHistoryXmlFile", "This maintenance is uninstalled: " + wASMaintenancePackage.getMaintenancePackageID() + " with status: " + wASMaintenancePackage.getResult());
                    this.installedMaintenancesMap.remove(wASMaintenancePackage.getMaintenancePackageID());
                    this.installedPTFsMap.remove(wASMaintenancePackage.getMaintenancePackageID());
                    this.installedPTFAppliedMap.remove(wASMaintenancePackage.getMaintenancePackageID());
                    this.installedPTFDriverMap.remove(wASMaintenancePackage.getMaintenancePackageID());
                }
                SimpleXMLParser.deleteChildNodes(simpleXMLParser.getDocument().getDocumentElement(), vector);
                vector.clear();
                simpleXMLParser = null;
            }
            catch (IOException iOException) {
                this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseHistoryXmlFile", iOException.getMessage(), iOException);
                throw iOException;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseHistoryXmlFile", parserConfigurationException.getMessage(), parserConfigurationException);
                throw parserConfigurationException;
            }
            catch (SAXException sAXException) {
                this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseHistoryXmlFile", sAXException.getMessage(), sAXException);
                throw sAXException;
            }
        } else {
            this.logger.logThisMessage(Level.SEVERE, this.getClass().getName(), "parseHistoryXmlFile", "FileInputStream for history xml file is null!");
        }
        this.logger.exiting(this.getClass().getName(), "parseHistoryXmlFile");
    }

    protected void parseComponentFiles(String string) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this.logger.entering(this.getClass().getName(), "parseComponentFiles");
        File[] fileArray = new File(WASDirectoryHelper.getVersionDirPath(string)).listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".component");
            }
        });
        int n = 0;
        try {
            String string2 = WASDirectoryHelper.getDTDDirPath(string);
            HistoryInfoEntityResolver historyInfoEntityResolver = new HistoryInfoEntityResolver(string2);
            for (n = 0; n < fileArray.length; ++n) {
                FileInputStream fileInputStream = new FileInputStream(fileArray[n]);
                WASComponent wASComponent = new WASComponent(fileInputStream, historyInfoEntityResolver, string);
                this.installedComponentsMap.put(wASComponent.getComponentName(), wASComponent);
                ((InputStream)fileInputStream).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseComponentFiles", fileNotFoundException.getMessage(), fileNotFoundException);
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            if (n != fileArray.length) {
                this.logger.logThisMessage(Level.SEVERE, this.getClass().getName(), "parseComponentFiles", "Can not close FileInputStream of component file: " + fileArray[n]);
            }
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseComponentFiles", iOException.getMessage(), iOException);
            throw iOException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseComponentFiles", parserConfigurationException.getMessage(), parserConfigurationException);
            throw parserConfigurationException;
        }
        catch (SAXException sAXException) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseComponentFiles", sAXException.getMessage(), sAXException);
            throw sAXException;
        }
        this.logger.exiting(this.getClass().getName(), "parseComponentFiles");
    }

    protected void setInstallRoot(String string) {
        this.installRoot = string;
    }

    protected void setLogger(WASDirectoryLogger wASDirectoryLogger) {
        this.logger = wASDirectoryLogger;
    }
}

