/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sync.core.internal;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.ws.sync.core.SyncConstants;
import com.ibm.ws.sync.core.SyncLocation;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.VersionRange;

public class SyncUtil {
    public static List getAllOfferingsFromRegisteredRepositories(IProgressMonitor monitor) {
        Agent agent = Agent.getInstance();
        IRepositoryGroup repositories = agent.getRepositoryGroup();
        return UpdateOfferingUtils.getAllOfferingsUpdatesAndFixes((IRepository)repositories, (IProgressMonitor)monitor);
    }

    public static List getAllFeaturesRecursively(IFeatureGroup featureGroup) {
        ArrayList features = new ArrayList();
        List fGroups = featureGroup.getGroups();
        features.addAll(featureGroup.getFeatures());
        if (fGroups != null) {
            int i = 0;
            while (i < fGroups.size()) {
                List featuresForThisGroup = SyncUtil.getAllFeaturesRecursively((IFeatureGroup)fGroups.get(i));
                if (featuresForThisGroup != null) {
                    features.addAll(featuresForThisGroup);
                }
                ++i;
            }
        }
        return features;
    }

    public static String getMajorVersion(String version) {
        String[] sections = version.split("\\.");
        return sections[0];
    }

    public static IProfile[] getAllProfilesContainingId(String profileId) {
        Profile[] existingProfiles = Agent.getInstance().getNormalProfiles();
        ArrayList<Profile> profiles = new ArrayList<Profile>(existingProfiles.length);
        Pattern profileIdPattern = Pattern.compile(SyncConstants.profilePattern(profileId));
        Profile[] profileArray = existingProfiles;
        int n = existingProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile existingProfile = profileArray[n2];
            String existingProfileId = existingProfile.getProfileId();
            Matcher profileIdMatcher = profileIdPattern.matcher(existingProfileId);
            if (profileIdMatcher.matches()) {
                profiles.add(existingProfile);
            }
            ++n2;
        }
        profiles.trimToSize();
        return profiles.toArray(new IProfile[profiles.size()]);
    }

    public static Profile findExistingProfile(String installLocation) {
        Profile profile = null;
        Profile[] existingProfiles = Agent.getInstance().getNormalProfiles();
        File newInstallDir = new File(installLocation);
        int i = 0;
        while (i < existingProfiles.length && profile == null) {
            File installDir = new File(existingProfiles[i].getInstallLocation());
            if (newInstallDir.compareTo(installDir) == 0) {
                profile = existingProfiles[i];
            }
            ++i;
        }
        return profile;
    }

    public static Profile findProfileCollision(String installLocation) {
        Profile collisionProfile = null;
        Profile[] profiles = Agent.getInstance().getProfiles();
        int i = 0;
        while (i < profiles.length && collisionProfile == null) {
            String existingInstallLocation;
            Profile existingProfile = profiles[i];
            if (!(existingProfile.isAgentProfile() || existingProfile.isLicenseProfile() || FileUtil.filesAreSame((String)installLocation, (String)(existingInstallLocation = existingProfile.getInstallLocation())) || !FileUtil.directoriesAreRelated((String)installLocation, (String)existingInstallLocation) || existingProfile.allowRelatedInstallLocations())) {
                collisionProfile = existingProfile;
            }
            ++i;
        }
        return collisionProfile;
    }

    public static boolean isEmptyProfile(IProfile profile) {
        return profile == null || profile.getInstalledOfferings().length == 0;
    }

    public static IOffering getBaseOffering(Profile profile) {
        IOffering baseOffering = null;
        if (profile == null) {
            return baseOffering;
        }
        IOffering[] offerings = Agent.getInstance().getInstalledOfferings(profile);
        int i = 0;
        while (i < offerings.length && baseOffering == null) {
            if (Agent.isSelfContainedOffering((IOffering)offerings[i])) {
                baseOffering = offerings[i];
            }
            ++i;
        }
        return baseOffering;
    }

    public static IStatus checkAgentRequirement(SyncLocation syncLocation, boolean displayInternalAgentVersion) {
        IStatus status = Status.OK_STATUS;
        Vector<Object> offeringsOrFixesToCheck = new Vector<Object>();
        SyncLocation.InstalledOffering[] instOfferings = syncLocation.getOfferingsToInstall();
        SyncLocation.InstalledFix[] instFixes = syncLocation.getIFixesToInstall();
        Comparable[] comparableArray = instOfferings;
        int n = instOfferings.length;
        int n2 = 0;
        while (n2 < n) {
            SyncLocation.InstalledOffering instOffering = comparableArray[n2];
            IOffering offering = instOffering.getRepositoryOffering();
            if (offering != null) {
                offeringsOrFixesToCheck.add(offering);
            }
            ++n2;
        }
        comparableArray = instFixes;
        int n3 = instFixes.length;
        n2 = 0;
        while (n2 < n3) {
            Comparable instFixe = comparableArray[n2];
            IFix fix = ((SyncLocation.InstalledFix)instFixe).getRepositoryFix();
            if (fix != null) {
                offeringsOrFixesToCheck.add(fix);
            }
            ++n2;
        }
        offeringsOrFixesToCheck.addAll(Arrays.asList(syncLocation.getOfferingsAndFixesToUninstall()));
        VersionRange highestMinAgentTolerance = new VersionRange("[0.0,0.0)");
        for (IOfferingOrFix iOfferingOrFix : offeringsOrFixesToCheck) {
            VersionRange agentTolerance = new VersionRange(SyncUtil.getAgentTolerance(iOfferingOrFix));
            if (highestMinAgentTolerance.getMinimum().compareTo(agentTolerance.getMinimum()) >= 0) continue;
            status = Agent.getInstance().checkAgentRequirement(iOfferingOrFix, displayInternalAgentVersion);
            highestMinAgentTolerance = agentTolerance;
        }
        return status;
    }

    private static String getAgentTolerance(IOfferingOrFix offeringOrFix) {
        LinkedProperties properties = offeringOrFix.getProperties();
        String tolerance = properties.getProperty("im.tolerance");
        if (tolerance == null && (tolerance = properties.getProperty("agent.tolerance")) == null && (tolerance = properties.getProperty("agent.version")) == null) {
            tolerance = "[0.0,999.0)";
        }
        return tolerance;
    }

    public static String getVersionWithoutQualifier(String version) {
        StringTokenizer tokenizedVersion = new StringTokenizer(version, ".");
        String majorVersion = SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion);
        String minorVersion = SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion);
        String microVersion = SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion);
        return String.valueOf(majorVersion) + "." + minorVersion + "." + microVersion;
    }

    public static String getMajorAndMinorVersion(String version) {
        StringTokenizer tokenizedVersion = new StringTokenizer(version, ".");
        String majorVersion = SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion);
        String minorVersion = SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion);
        return String.valueOf(majorVersion) + minorVersion;
    }

    public static String convertExternalVersionToInternalVersion(String externalVersion) {
        StringTokenizer tokenizedVersion = new StringTokenizer(externalVersion, ".");
        String majorVersion = SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion);
        String minorVersion = SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion);
        String microVersion = SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion);
        String serviceVersion = SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion);
        microVersion = Integer.toString(Integer.parseInt(microVersion) * 1000 + Integer.parseInt(serviceVersion));
        return String.valueOf(majorVersion) + "." + minorVersion + "." + microVersion;
    }

    public static String convertInternalVersionToExternalVersion(String internalVersion) {
        StringTokenizer tokenizedVersion = new StringTokenizer(internalVersion, ".");
        String majorVersion = SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion);
        String minorVersion = SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion);
        String microVersion = SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion);
        int micro = Integer.parseInt(microVersion);
        int service = micro % 1000;
        microVersion = Integer.toString((micro - service) / 1000);
        return String.valueOf(majorVersion) + "." + minorVersion + "." + microVersion + "." + Integer.toString(service);
    }

    public static int compareVersion(String version1, String version2) {
        StringTokenizer tokenizedVersion1 = new StringTokenizer(version1, ".");
        StringTokenizer tokenizedVersion2 = new StringTokenizer(version2, ".");
        while (tokenizedVersion1.hasMoreTokens() || tokenizedVersion2.hasMoreTokens()) {
            int version2Digit;
            int version1Digit = Integer.parseInt(SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion1));
            if (version1Digit > (version2Digit = Integer.parseInt(SyncUtil.getNextTokenOrZeroIfNoNextToken(tokenizedVersion2)))) {
                return 1;
            }
            if (version1Digit >= version2Digit) continue;
            return -1;
        }
        return 0;
    }

    private static String getNextTokenOrZeroIfNoNextToken(StringTokenizer st) {
        try {
            if (st.hasMoreTokens()) {
                return st.nextToken();
            }
            return "0";
        }
        catch (NoSuchElementException noSuchElementException) {
            return "0";
        }
    }

    public static IFeature[] mergeFeatureLists(IFeature[] featureList1, IFeature[] featureList2) {
        TreeSet<IFeature> f1 = new TreeSet<IFeature>(new FeatureComparator());
        f1.addAll(Arrays.asList(featureList1));
        f1.addAll(Arrays.asList(featureList2));
        return f1.toArray(new IFeature[f1.size()]);
    }

    public static File getIMPropertiesFile(String installLocation, String productId) {
        return new File(String.valueOf(installLocation) + File.separatorChar + "properties/version/im" + File.separatorChar + productId + ".im.properties");
    }

    public static class FeatureComparator
    implements Comparator<IFeature> {
        @Override
        public int compare(IFeature f1, IFeature f2) {
            return f1.getIdentity().getId().compareTo(f2.getIdentity().getId());
        }
    }

    public static class VersionComparator
    implements Comparator {
        public int compare(Object version1, Object version2) {
            if (!(version1 instanceof String) && !(version2 instanceof String)) {
                return 0;
            }
            if (!(version1 instanceof String)) {
                return -1;
            }
            if (!(version2 instanceof String)) {
                return 1;
            }
            return SyncUtil.compareVersion(version1.toString(), version2.toString());
        }
    }
}

