/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sync.core.internal;

import com.ibm.cic.common.core.model.IOffering;
import com.ibm.ws.pak.core.utils.PakUtils;
import com.ibm.ws.sync.core.internal.Messages;
import com.ibm.ws.sync.core.internal.OfferingDefinitionLoader;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;

public class SyncProductVersionMap {
    private IOffering offering = null;
    private String installLocation = null;
    private ProductVersionMapEntry[] productVersionMapEntries = null;

    public SyncProductVersionMap(String installLocation, IOffering offering) {
        this.offering = offering;
        this.installLocation = installLocation;
    }

    public boolean loadPakToFeatureMapping() {
        if (this.offering == null) {
            return Boolean.FALSE;
        }
        IConfigurationElement[] syncElements = OfferingDefinitionLoader.loadSyncElements(this.offering.getIdentity().getId());
        this.productVersionMapEntries = syncElements.length > 0 ? this.getProductVersionMapEntries(syncElements) : new ProductVersionMapEntry[0];
        return Boolean.TRUE;
    }

    private ProductVersionMapEntry[] getProductVersionMapEntries(IConfigurationElement[] syncElements) {
        TreeSet<ProductVersionMapEntry> productVersionMapList = new TreeSet<ProductVersionMapEntry>();
        PakUtils pakUtils = new PakUtils();
        IConfigurationElement[] iConfigurationElementArray = syncElements;
        int n = syncElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement syncElement = iConfigurationElementArray[n2];
            String payloadId = syncElement.getAttribute("payloadId");
            String description = this.resolveProductDescription(syncElement.getAttribute("description"));
            String version = pakUtils.getPakVersionForThisPayloadId(this.installLocation, payloadId);
            productVersionMapList.add(new ProductVersionMapEntry(payloadId, description, version));
            ++n2;
        }
        return productVersionMapList.toArray(new ProductVersionMapEntry[productVersionMapList.size()]);
    }

    private String resolveProductDescription(String description) {
        String resolvedDescription = "";
        if (description != null && !"".equals(description.trim())) {
            resolvedDescription = Messages.toString(description);
        }
        return resolvedDescription;
    }

    public ProductVersionMapEntry[] getProductVersionMapEntries() {
        return this.productVersionMapEntries;
    }

    public static class ProductVersionMapEntry
    implements Comparable {
        private final String payloadId;
        private final String description;
        private String version;

        public ProductVersionMapEntry(String payloadId, String description, String version) {
            this.payloadId = payloadId != null ? payloadId : "";
            this.description = description != null ? description : "";
            this.version = version != null ? version : "";
        }

        public String getPayloadId() {
            return this.payloadId;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public int compareTo(Object arg0) {
            if (!(arg0 instanceof ProductVersionMapEntry)) {
                throw new ClassCastException("Type mismatch: Expecting an ProductVersionMapEntry object");
            }
            ProductVersionMapEntry productVersionMapEntry = (ProductVersionMapEntry)arg0;
            return this.payloadId.compareTo(productVersionMapEntry.getPayloadId());
        }

        public boolean equals(Object o) {
            if (!(o instanceof ProductVersionMapEntry)) {
                return false;
            }
            ProductVersionMapEntry productVersionMapEntry = (ProductVersionMapEntry)o;
            return this.payloadId.equals(productVersionMapEntry.getPayloadId());
        }

        public int hashCode() {
            return this.payloadId != null ? this.payloadId.hashCode() : 0;
        }
    }
}

