/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import com.ibm.security.jgss.i18n.PropertyResource;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.RealmException;
import java.io.File;
import java.security.AccessControlException;
import java.util.Objects;
import javax.security.auth.kerberos.JavaxSecurityAuthKerberosAccessImpl;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import sun.misc.JavaxSecurityAuthKerberosAccess;
import sun.misc.SharedSecrets;

public final class KeyTab {
    private final File file;

    private KeyTab(File file) {
        this.file = file;
    }

    public static KeyTab getInstance(File file) {
        if (file == null) {
            throw new NullPointerException("file must be non null");
        }
        return new KeyTab(file);
    }

    public static KeyTab getInstance() {
        return new KeyTab(null);
    }

    private com.ibm.security.krb5.internal.ktab.KeyTab takeSnapshot() {
        try {
            return com.ibm.security.krb5.internal.ktab.KeyTab.getInstance((File)this.file);
        }
        catch (AccessControlException ace) {
            if (this.file != null) {
                throw ace;
            }
            PropertyResource gpr = PropertyResource.getGeneralInstance();
            String i18nMsg = gpr.getFormattedString("KtabLoadError", (Object[])new String[]{null});
            AccessControlException ace2 = new AccessControlException(i18nMsg);
            ace2.setStackTrace(ace.getStackTrace());
            throw ace2;
        }
    }

    public KerberosKey[] getKeys(KerberosPrincipal principal) {
        try {
            EncryptionKey[] serviceKeys = this.takeSnapshot().readServiceKeys(new PrincipalName(principal.getName()));
            if (null == serviceKeys || serviceKeys.length == 0) {
                return new KerberosKey[0];
            }
            KerberosKey[] kks = new KerberosKey[serviceKeys.length];
            for (int i = 0; i < kks.length; ++i) {
                Integer tmp = serviceKeys[i].getKeyVersionNumber();
                kks[i] = new KerberosKey(principal, serviceKeys[i].getBytes(), serviceKeys[i].getEType(), tmp == null ? 0 : tmp);
                serviceKeys[i].destroy();
            }
            return kks;
        }
        catch (RealmException re) {
            return new KerberosKey[0];
        }
    }

    EncryptionKey[] getEncryptionKeys(PrincipalName principal) {
        return this.takeSnapshot().readServiceKeys(principal);
    }

    public boolean exists() {
        return !this.takeSnapshot().isMissing();
    }

    public String toString() {
        return this.file == null ? "Default keytab" : this.file.toString();
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof KeyTab)) {
            return false;
        }
        KeyTab otherKtab = (KeyTab)other;
        return Objects.equals(otherKtab.file, this.file);
    }

    static {
        SharedSecrets.setJavaxSecurityAuthKerberosAccess((JavaxSecurityAuthKerberosAccess)new JavaxSecurityAuthKerberosAccessImpl());
    }
}

