/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.ui.extensions;

import com.ibm.cic.common.ui.wizards.SkippableContainerWizardPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Control;

public abstract class BaseWizardPanel {
    private Control panelControl;
    private boolean isPanelComplete;
    private SkippableContainerWizardPage container;
    private String errorMessage;
    private String description = null;
    private boolean isDisposed = false;
    private String message = null;
    private int messageType = 0;

    public void setDescription(String description) {
        this.description = description;
        if (this.isCurrentPanel()) {
            this.container.setDescription(description);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setPageComplete(boolean complete) {
        this.isPanelComplete = complete;
        if (this.isCurrentPanel()) {
            this.container.updateButtons();
        }
    }

    public void setErrorMessage(String newMessage) {
        this.errorMessage = newMessage;
        if (this.isCurrentPanel()) {
            this.container.setErrorMessage(newMessage);
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setMessage(String message, int messageType) {
        this.message = message;
        this.messageType = messageType;
        if (this.isCurrentPanel()) {
            this.container.setMessage(message, messageType);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public abstract IStatus performFinish(IProgressMonitor var1);

    public boolean canAddPanelToWizardPage() {
        return true;
    }

    protected void setControl(Control newControl) {
        this.panelControl = newControl;
    }

    public Control getControl() {
        return this.panelControl;
    }

    public void setVisible(boolean visible) {
        if (this.panelControl != null) {
            this.panelControl.setVisible(visible);
        }
    }

    public boolean isPageComplete() {
        return this.isPanelComplete;
    }

    public void setContainer(SkippableContainerWizardPage container) {
        this.container = container;
    }

    public SkippableContainerWizardPage getContainer() {
        return this.container;
    }

    public void updateButtons() {
        if (this.container != null) {
            this.container.updateButtons();
        }
    }

    public void dispose() {
        this.isDisposed = true;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    protected boolean isCurrentPanel() {
        return this.container != null && this.container.getCurrentPanelControl() == this.panelControl;
    }

    public IStatus performCancel(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }
}

