/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.ProfileTreeNode;
import com.ibm.cic.agent.internal.ui.utils.SummaryFeatureLabelProvider;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultContentProvider;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultLabelProvider;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultTreeViewerSorter;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.FeatureSelectionPage;
import com.ibm.cic.agent.internal.ui.wizards.SummaryPage;
import com.ibm.cic.agent.internal.ui.wizards.UpdateWizard;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class UpdateSummaryPage
extends SummaryPage {
    private TreeViewer addFeatureViewer;
    private TreeViewer removeFeatureViewer;
    private boolean allFixes = false;
    private boolean isUpdateAll = false;
    private Map profileTreeNodeMap = new HashMap();
    private UpdateResultContentProvider addFeatureTreeContentProvider;

    public UpdateSummaryPage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(toolkit, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.UpdateSummaryPage");
        if (wizard instanceof UpdateWizard) {
            this.isUpdateAll = ((UpdateWizard)wizard).isUpdateAll();
        }
    }

    @Override
    protected List getSelectedJobs() {
        return super.getSortedSelectedJobs(false);
    }

    @Override
    protected void createFeatureControl(Composite container) {
        this.allFixes = AgentUIUtils.allFixJobs(this.getSelectedJobs());
        Section packagesSection = this.getToolkit().createSection(container, 512);
        packagesSection.setText(Messages.UpdateSummaryPage_title);
        Composite featureComp = this.getToolkit().createComposite((Composite)packagesSection);
        GridLayout layout = new GridLayout();
        if (this.allFixes) {
            layout.numColumns = 1;
        } else {
            layout.numColumns = 2;
            layout.makeColumnsEqualWidth = true;
        }
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        featureComp.setLayout((Layout)layout);
        packagesSection.setClient((Control)featureComp);
        packagesSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.configureAddFeatureTreeViewer(featureComp);
        this.addFeatureViewer.setInput(null);
        if (!this.allFixes) {
            Composite removeFeatureComp = this.getToolkit().createComposite(featureComp);
            GridLayout removeFeatureCompLayout = new GridLayout();
            removeFeatureCompLayout.marginHeight = 0;
            removeFeatureComp.setLayout((Layout)removeFeatureCompLayout);
            removeFeatureComp.setLayoutData((Object)new GridData(4, 4, true, true));
            int style = 68356;
            this.removeFeatureViewer = new TreeViewer(removeFeatureComp, style);
            GridData data = new GridData(1808);
            data.heightHint = this.removeFeatureViewer.getTree().getItemHeight() * 3;
            this.removeFeatureViewer.getTree().setLayoutData((Object)data);
            this.removeFeatureViewer.getTree().setLinesVisible(false);
            this.removeFeatureViewer.getTree().setHeaderVisible(true);
            TreeColumn removeFeatureCol = new TreeColumn(this.removeFeatureViewer.getTree(), 0x800000);
            removeFeatureCol.setText(Messages.UpdateSummaryPage_col2);
            removeFeatureCol.setWidth(290);
            this.removeFeatureViewer.getTree().addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    int treeWidth = ((UpdateSummaryPage)UpdateSummaryPage.this).removeFeatureViewer.getTree().getClientArea().width;
                    int scrollBarWidth = 0;
                    TreeColumn col = UpdateSummaryPage.this.removeFeatureViewer.getTree().getColumn(0);
                    col.setWidth(treeWidth - scrollBarWidth);
                }
            });
            this.removeFeatureViewer.setContentProvider((IContentProvider)new UpdateRemoveFeatureContentProvider());
            this.removeFeatureViewer.setLabelProvider((IBaseLabelProvider)new UpdateRemoveFeatureLabelProvider());
            this.removeFeatureViewer.addFilter((ViewerFilter)new UpdateRemoveFeatureFilter());
            this.removeFeatureViewer.setInput(null);
            this.removeFeatureViewer.setSorter((ViewerSorter)new UpdateResultTreeViewerSorter());
        }
    }

    private void configureAddFeatureTreeViewer(Composite parent) {
        Composite addFeatureComp = this.getToolkit().createComposite(parent);
        GridLayout addFeatureCompLayout = new GridLayout();
        addFeatureCompLayout.marginHeight = 0;
        addFeatureComp.setLayout((Layout)addFeatureCompLayout);
        addFeatureComp.setLayoutData((Object)new GridData(4, 4, true, true));
        int style = 68356;
        this.addFeatureViewer = new TreeViewer(addFeatureComp, style);
        GridData gd = new GridData(1808);
        gd.heightHint = this.addFeatureViewer.getTree().getItemHeight() * 3;
        this.addFeatureViewer.getTree().setLayoutData((Object)gd);
        this.addFeatureViewer.getTree().setLinesVisible(false);
        this.addFeatureViewer.getTree().setHeaderVisible(true);
        TreeColumn addFeatureCol = new TreeColumn(this.addFeatureViewer.getTree(), 0x800000);
        String columnTitle = Messages.UpdateSummaryPage_col1;
        if (this.allFixes) {
            columnTitle = Messages.UpdateSummaryPage_colFix;
        }
        addFeatureCol.setText(columnTitle);
        addFeatureCol.setWidth(290);
        this.addFeatureViewer.getTree().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int treeWidth = ((UpdateSummaryPage)UpdateSummaryPage.this).addFeatureViewer.getTree().getClientArea().width;
                int scrollBarWidth = 0;
                TreeColumn col = UpdateSummaryPage.this.addFeatureViewer.getTree().getColumn(0);
                col.setWidth(treeWidth - scrollBarWidth);
            }
        });
        if (!this.isUpdateAll) {
            IWizard wizard = this.getWizard();
            IWizardPage previousPage = wizard.getPreviousPage((IWizardPage)this);
            while (previousPage != null && !(previousPage instanceof FeatureSelectionPage)) {
                previousPage = wizard.getPreviousPage(previousPage);
            }
            if (previousPage != null) {
                ITreeContentProvider featureTreeContentProvider = ((FeatureSelectionPage)previousPage).getFeatureContentProvider();
                Map map = ((FeatureSelectionPage)previousPage).getJobToGroupMap();
                this.addFeatureTreeContentProvider = new UpdateResultContentProvider(featureTreeContentProvider, map);
            } else {
                this.addFeatureTreeContentProvider = new UpdateResultContentProvider();
            }
        } else {
            this.addFeatureTreeContentProvider = new UpdateResultContentProvider();
        }
        this.addFeatureViewer.setContentProvider((IContentProvider)this.addFeatureTreeContentProvider);
        this.addFeatureViewer.setLabelProvider((IBaseLabelProvider)new UpdateResultLabelProvider(DisplayKeeper.INSTANCE.getDisplay()));
        this.addFeatureViewer.addFilter((ViewerFilter)new SummaryPage.FeatureFilter());
        this.addFeatureViewer.setSorter((ViewerSorter)new UpdateResultTreeViewerSorter());
    }

    private void showUpdateAndFix() {
        this.addFeatureViewer.getTree().removeAll();
        this.profileTreeNodeMap = AgentUIUtils.generateProfileJobFeatureTree(this.getSelectedJobs());
        IWizard wizard = this.getWizard();
        if (wizard instanceof UpdateWizard) {
            ((UpdateWizard)wizard).setUpdateResultTreeRoot(this.profileTreeNodeMap.values());
        }
        boolean hasFix = AgentUIUtils.hasFixJob(this.getSelectedJobs());
        UpdateResultContentProvider contentProvider = (UpdateResultContentProvider)this.addFeatureViewer.getContentProvider();
        contentProvider.setHasFix(hasFix);
        if (!this.isUpdateAll) {
            Collection profileNodes = this.profileTreeNodeMap.values();
            if (profileNodes.size() > 0) {
                ProfileTreeNode profileNode = (ProfileTreeNode)profileNodes.iterator().next();
                this.addFeatureViewer.setInput(profileNode.getChildren());
            } else {
                this.addFeatureViewer.setInput(null);
            }
        } else {
            this.addFeatureViewer.setInput(this.profileTreeNodeMap.values());
        }
        if (this.allFixes) {
            this.addFeatureViewer.expandAll();
        } else if (this.getSelectedJobs().size() > 1) {
            if (!this.isUpdateAll) {
                this.addFeatureViewer.expandToLevel(2);
            } else {
                this.addFeatureViewer.expandToLevel(3);
            }
        } else {
            this.addFeatureViewer.expandAll();
        }
        Tree addTree = this.addFeatureViewer.getTree();
        if (addTree.getItemCount() > 0) {
            TreeItem item = addTree.getItem(0);
            addTree.setTopItem(item);
        }
        this.addFeatureViewer.getTree().setEnabled(false);
        this.addFeatureViewer.getTree().setEnabled(true);
        if (addTree.getItemCount() > 0 && !this.allFixes) {
            addTree.getColumn(0).pack();
        }
        if (!this.allFixes) {
            this.removeFeatureViewer.getTree().removeAll();
            this.removeFeatureViewer.setInput((Object)this.getSelectedJobs().toArray());
            this.removeFeatureViewer.expandAll();
            Tree removeTree = this.removeFeatureViewer.getTree();
            if (removeTree.getItemCount() > 0) {
                TreeItem item = removeTree.getItem(0);
                removeTree.setTopItem(item);
            }
            this.removeFeatureViewer.getTree().setEnabled(false);
            this.removeFeatureViewer.getTree().setEnabled(true);
            if (removeTree.getItemCount() > 0) {
                removeTree.getColumn(0).pack();
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.showUpdateAndFix();
            this.reflowFor((Control)this.addFeatureViewer.getTree());
        }
        super.setVisible(visible);
    }

    private static class UpdateRemoveFeatureContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof UpdateOfferingJob) {
                UpdateOfferingJob updateJob = (UpdateOfferingJob)parentElement;
                HashSet featuresToInstall = new HashSet(updateJob.getFeatures());
                Set featuresToRemove = Agent.getInstance().getInstalledFeatures(updateJob.getProfile(), updateJob.getUpdatedOffering());
                featuresToRemove.removeAll(featuresToInstall);
                ArrayList<IFeature> visibleFeatures = new ArrayList<IFeature>();
                for (IFeature feature : featuresToRemove) {
                    if (!feature.isVisible()) continue;
                    visibleFeatures.add(feature);
                }
                return visibleFeatures.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    private static class UpdateRemoveFeatureFilter
    extends ViewerFilter {
        private UpdateRemoveFeatureFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IContentProvider contentProvider;
            if (element instanceof AgentJob && viewer instanceof TreeViewer && (contentProvider = ((TreeViewer)viewer).getContentProvider()) instanceof ITreeContentProvider) {
                boolean hasChildren = ((ITreeContentProvider)contentProvider).hasChildren(element);
                return hasChildren;
            }
            return true;
        }
    }

    private static class UpdateRemoveFeatureLabelProvider
    extends SummaryFeatureLabelProvider {
        private UpdateRemoveFeatureLabelProvider() {
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof UpdateOfferingJob) {
                IOffering base = ((UpdateOfferingJob)element).getUpdatedOffering();
                return OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)base);
            }
            return super.getColumnText(element, columnIndex);
        }
    }
}

