/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIDisableCancelWizard;
import com.ibm.cic.agent.internal.ui.wizards.CompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.ConditionalInstallPage;
import com.ibm.cic.agent.internal.ui.wizards.RollbackCompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.RollbackSummaryPage;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.CICImages;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;

public class RollbackWizard
extends AgentUIDisableCancelWizard {
    public RollbackWizard() {
        super(null, Messages.RollbackWizard_Rollbacking, CICImages.WIZ_ROLLBACK);
    }

    public RollbackWizard(String returnPageId) {
        super(returnPageId, Messages.RollbackWizard_Rollbacking, CICImages.WIZ_ROLLBACK);
    }

    public void addPages() {
        ConditionalInstallPage conditionalRollbackPage = new ConditionalInstallPage(this.toolkit, this);
        if (!conditionalRollbackPage.shouldSkip()) {
            conditionalRollbackPage.setHelpRef("com.ibm.cic.agent.ui.ConditionalInstallPage");
            this.addPage((IWizardPage)conditionalRollbackPage);
        }
        this.addExtensionPages("com.ibm.cic.agent.ui.MissingCustomPanelRollbackWizard");
        this.addSingleConfigurationPage(com.ibm.cic.agent.internal.ui.licenses.Messages.InstallWizard_featuresTitle, "com.ibm.cic.agent.ui.MissingCustomPanelSingleConfigurationPage");
        this.addPage((IWizardPage)new RollbackSummaryPage(this.toolkit, this));
    }

    @Override
    protected AbstractJob createJob(Profile profile, IOfferingOrFix offering) {
        RollbackJob job = new RollbackJob(profile, offering);
        job.setSelected(false);
        return job;
    }

    @Override
    public CompletionPage createCompletionPage(IStatus status) {
        return new RollbackCompletionPage(this.toolkit, this, status);
    }

    @Override
    protected String getRestartMessage() {
        return Messages.RestartProfileMsg;
    }

    @Override
    protected WizardType getWizardType() {
        return WizardType.ROLLBACK;
    }

    @Override
    protected IStatus performTask(IProgressMonitor monitor) {
        AgentUI.getDefault().getCurrentWizard().setAllowExit(false);
        Agent agent = AgentUI.getDefault().getAgent();
        List selectedJobs = this.getSelectedJobs();
        IStatus status = agent.install((AgentJob[])selectedJobs.toArray(new AbstractJob[selectedJobs.size()]), this.getCollectedArtifacts(), (Agent.IDisableCancel)this, monitor);
        return status;
    }

    @Override
    public void setInput(Object[] items) {
        if (items instanceof Profile[]) {
            this.addProfiles((Profile[])items);
        } else if (items instanceof AbstractJob[]) {
            this.addJobs((AbstractJob[])items);
        }
    }

    private void addJobs(AbstractJob[] jobs) {
        List productProfiles = this.getProductProfileList();
        List agentProfile = this.getAgentProfileList();
        List wizardJobs = this.getJobs();
        productProfiles.clear();
        agentProfile.clear();
        wizardJobs.clear();
        AbstractJob[] abstractJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractJob job = abstractJobArray[n2];
            wizardJobs.add(job);
            Profile profile = job.getProfile();
            if (profile != null) {
                if (profile.getProfileKind().equals("self")) {
                    agentProfile.add(profile);
                } else if (!productProfiles.contains(profile)) {
                    productProfiles.add(profile);
                }
            }
            ++n2;
        }
    }

    private void addProfiles(Profile[] profiles) {
        List productProfiles = this.getProductProfileList();
        List agentProfile = this.getAgentProfileList();
        List wizardJobs = this.getJobs();
        productProfiles.clear();
        agentProfile.clear();
        wizardJobs.clear();
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if (profile.getProfileKind().equals("self")) {
                agentProfile.add(profile);
            } else {
                productProfiles.add(profile);
            }
            ++n2;
        }
    }

    public boolean isHelpAvailable() {
        return true;
    }

    protected String getStatusMessage(IStatus status) {
        if (status.matches(8)) {
            return Messages.RollbackCanceledMsg;
        }
        return Messages.RollbackFailedMsg;
    }

    protected String getKeepDownloadedMessage() {
        return Messages.KeepDownloadedMsgForRollback;
    }

    protected String getKeepDownloadedDlgTitle(IStatus status) {
        if (status.matches(8)) {
            return Messages.RollbackCanceledTitle;
        }
        return Messages.RollbackFailedTitle;
    }
}

