/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.dialogs.ViewLogDialog;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.internal.wizardry.AbstractCicWizardPage;
import com.ibm.cic.common.ui.services.UiServices;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ResponseFileGenCompletionPage
extends AbstractCicWizardPage {
    private final String responseFileName;
    private FormText resultText;
    private FormText viewLogText;
    private final IStatus result;
    private final AgentUILabelProvider labelProvider;

    public ResponseFileGenCompletionPage(FormToolkit toolkit, String pageTitle, String pageDes, IStatus result, String fileName) {
        super(pageTitle, toolkit, pageDes);
        this.responseFileName = fileName;
        this.result = result;
        this.labelProvider = AgentUI.getDefault().getLabelProvider();
        this.labelProvider.connect((Object)this);
    }

    public void createControl(Composite parent) {
        Composite container = this.getToolkit().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite resultComp = this.getToolkit().createComposite(container);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        resultComp.setLayout((Layout)gridLayout);
        GridData data = new GridData(0x1000000, 1, true, false);
        data.verticalIndent = 20;
        resultComp.setLayoutData((Object)data);
        Label resultImage = this.getToolkit().createLabel(resultComp, "", 0);
        if (!StatusUtil.isErrorOrCancel((IStatus)this.result)) {
            resultImage.setImage(this.labelProvider.get(CICImages.SUCCESS));
        } else {
            resultImage.setImage(this.labelProvider.get(CICImages.FAIL));
        }
        this.resultText = this.getToolkit().createFormText(resultComp, false);
        String resultMsg = Messages.ResponseFileGenerator_CompletionPage_Result_Failure;
        if (!StatusUtil.isErrorOrCancel((IStatus)this.result)) {
            StringBuffer successLink = new StringBuffer();
            successLink.append("<a href=\"\">" + this.responseFileName + "</a>");
            resultMsg = NLS.bind((String)Messages.ResponseFileGenerator_CompletionPage_Result_Success, (Object)successLink.toString());
        }
        StringBuffer resultMsgBuf = new StringBuffer();
        resultMsgBuf.append("<form><p>");
        resultMsgBuf.append(resultMsg);
        resultMsgBuf.append("</p></form>");
        this.resultText.setText(resultMsgBuf.toString(), true, false);
        HyperlinkAdapter openXMLAction = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                UiServices.getInstance().launchProgram(ResponseFileGenCompletionPage.this.responseFileName);
            }
        };
        this.resultText.setHyperlinkSettings((HyperlinkSettings)this.getToolkit().getHyperlinkGroup());
        this.resultText.addHyperlinkListener((IHyperlinkListener)openXMLAction);
        this.viewLogText = this.getToolkit().createFormText(resultComp, false);
        HyperlinkAdapter urlAction = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                File logFile = LogManager.getDefaultLogFile();
                ViewLogDialog dlg = new ViewLogDialog(window.getShell(), logFile);
                dlg.open();
            }
        };
        this.viewLogText.setHyperlinkSettings((HyperlinkSettings)this.getToolkit().getHyperlinkGroup());
        this.viewLogText.addHyperlinkListener((IHyperlinkListener)urlAction);
        StringBuffer buf = new StringBuffer();
        buf.append("<form><p>");
        buf.append("<a href=\"\">" + Messages.CompletionPage_viewLog + "</a>");
        buf.append("</p></form>");
        this.viewLogText.setText(buf.toString(), true, false);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    protected void setFocus() {
        this.setPageComplete(true);
        AgentUIUtils.reflowForControl((Control)this.viewLogText);
    }

    public void dispose() {
        this.labelProvider.disconnect((Object)this);
        super.dispose();
    }
}

