/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.DefaultLicenseSelection;
import com.ibm.cic.agent.internal.ui.utils.ProfileOfferingFeature;
import com.ibm.cic.agent.internal.ui.views.PreviewTaskDetailsPage;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIPrimaryPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.LicenseFlexWizard;
import com.ibm.cic.agent.internal.ui.wizards.LicenseImportWizard;
import com.ibm.cic.agent.internal.ui.wizards.LicensesByPackageSection;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryWizard;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;

public class LicensesByPackagePage
extends AbstractAgentUIPrimaryPage {
    private LicensesByPackageSection packageSection;
    private PreviewTaskDetailsPage detailsPage;
    private DefaultLicenseSelection defaultSelection;

    public LicensesByPackagePage(PrimaryWizard wizard) {
        super(com.ibm.cic.agent.internal.ui.licenses.Messages.ManageLicanseWizardTitle, Messages.LicenseManagementWizard_packagesDescription, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.LicensesByPackagePage");
    }

    public LicensesByPackagePage(DefaultLicenseSelection defaultSelection, PrimaryWizard wizard) {
        this(wizard);
        this.defaultSelection = defaultSelection;
    }

    @Override
    protected TreeSection createTreeSection(IFormContext context, Composite parent) {
        this.packageSection = new LicensesByPackageSection(context, parent, this.defaultSelection, this);
        return this.packageSection;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.packageSection.setFocus();
        }
        super.setVisible(visible);
    }

    @Override
    public boolean canFlipToNextPage() {
        boolean result = false;
        String errorMessage = null;
        ProfileOfferingFeature selectedProfileOfferingFeature = this.packageSection.getSelectedProfileOfferingFeature();
        if (selectedProfileOfferingFeature != null) {
            if (this.packageSection.importLicense()) {
                result = true;
            } else if (this.packageSection.configLicenseServer()) {
                result = true;
            } else if (this.packageSection.configureTeamProductLicense()) {
                result = false;
            }
        }
        this.setErrorMessage(errorMessage);
        return result;
    }

    protected boolean isExternalToolInvoked() {
        return this.packageSection.configureTeamProductLicense();
    }

    @Override
    protected IDetailsPage createDetailsSection() {
        this.detailsPage = new PreviewTaskDetailsPage();
        return this.detailsPage;
    }

    @Override
    public IWizardPage getNextPage() {
        ProfileOfferingFeature profileOffering = this.packageSection.getSelectedProfileOfferingFeature();
        final IOffering selectedOffering = profileOffering.getProfileOffering().getOffering();
        final IStatus[] prepareStatus = new IStatus[]{Status.OK_STATUS};
        if (selectedOffering != null) {
            try {
                CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        prepareStatus[0] = Agent.getInstance().prepare((IOfferingOrFix)selectedOffering, ExtensionCategory.ALL, monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                AgentUI.reportException(e);
            }
            catch (InterruptedException e) {
                AgentUI.reportException(e);
            }
        }
        if (prepareStatus[0].matches(4)) {
            this.setErrorMessageWithStatus(prepareStatus[0]);
            return this;
        }
        if (prepareStatus[0].matches(8)) {
            this.setErrorMessage(null);
            this.setMessage(Messages.LicenseManagementPage_prepareCanceled, 2);
            return this;
        }
        this.setErrorMessage(null);
        this.setMessage(null, 2);
        return super.getNextPage();
    }

    @Override
    protected AgentUIWizard createInnerWizard() {
        ProfileOfferingFeature pof = this.packageSection.getSelectedProfileOfferingFeature();
        if (this.packageSection.importLicense()) {
            if (this.defaultSelection != null) {
                return new LicenseImportWizard(pof, this.defaultSelection.getPekOffering());
            }
            return new LicenseImportWizard(pof, null);
        }
        if (this.packageSection.configLicenseServer()) {
            return new LicenseFlexWizard(pof);
        }
        this.packageSection.configureTeamProductLicense();
        return null;
    }

    @Override
    public boolean isPageComplete() {
        return this.canFlipToNextPage();
    }

    @Override
    protected int[] getWeights() {
        return new int[]{70, 30};
    }
}

