/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.ProfileOfferingFeature;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.CompletionPage;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.licensing.common.util.LicenseStatus;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LicenseFlexCompletionPage
extends CompletionPage {
    private final ProfileOfferingFeature selectedProfileOfferingFeature;
    private final IFeatureBase featureOrGroup;
    private LicenseStatus[] licstatus;
    private final List packageNames = new ArrayList();
    private final List licenseTypes = new ArrayList();
    private final List expirationDates = new ArrayList();

    public LicenseFlexCompletionPage(FormToolkit toolkit, AgentUIWizard wizard, ProfileOfferingFeature profileOfferingFeature, IStatus mainStatus) {
        super(toolkit, Messages.LicenseFlexCompletionPage_title, "", wizard, mainStatus);
        super.setHelpRef("com.ibm.cic.agent.ui.LicenseFlexCompletionPage");
        this.selectedProfileOfferingFeature = profileOfferingFeature;
        IOffering offering = this.selectedProfileOfferingFeature.getProfileOffering().getOffering();
        Profile profile = this.selectedProfileOfferingFeature.getProfileOffering().getProfile();
        this.featureOrGroup = this.selectedProfileOfferingFeature.getFeatureOrGroup();
        if (this.featureOrGroup == null) {
            ArrayList<LicenseStatus> licenseStatusList = new ArrayList<LicenseStatus>();
            IInstallableUnit iu = LicenseUtils.getOfferingIplaUnit((IOffering)offering);
            licenseStatusList.add(LicenseUtils.getRuntimeLicenseStatus((IInstallableUnit)iu));
            IFeatureBase[] featureOrGroups = AgentUIUtils.getInstalledVisibleLicensedFeatureOrGroup(offering, profile);
            if (featureOrGroups != null && featureOrGroups.length > 0) {
                IFeatureBase[] iFeatureBaseArray = featureOrGroups;
                int n = featureOrGroups.length;
                int n2 = 0;
                while (n2 < n) {
                    IFeatureBase featureOrGroup2 = iFeatureBaseArray[n2];
                    IInstallableUnit featureLicenseIU = LicenseUtils.getFeatureIplaUnit((IOffering)offering, (IFeatureBase)featureOrGroup2);
                    licenseStatusList.add(LicenseUtils.getRuntimeLicenseStatus((IInstallableUnit)featureLicenseIU));
                    ++n2;
                }
            }
            this.licstatus = licenseStatusList.toArray(new LicenseStatus[licenseStatusList.size()]);
        } else {
            IInstallableUnit iu = LicenseUtils.getFeatureIplaUnit((IOffering)offering, (IFeatureBase)this.featureOrGroup);
            LicenseStatus runtimeLicStatus = LicenseUtils.getRuntimeLicenseStatus((IInstallableUnit)iu);
            this.licstatus = new LicenseStatus[]{runtimeLicStatus};
        }
    }

    @Override
    protected Composite createDetailControl(Composite container) {
        Composite installedLicenseComp = new Composite(container, 0);
        installedLicenseComp.setLayout((Layout)new GridLayout());
        installedLicenseComp.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        Label introLabel = new Label(installedLicenseComp, 0);
        if (this.licstatus.length > 1) {
            introLabel.setText(Messages.LicenseFlexCompletionPage_configLabels);
        } else {
            introLabel.setText(Messages.LicenseFlexCompletionPage_configLabel);
        }
        Composite packageListComp = new Composite(installedLicenseComp, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        packageListComp.setLayout((Layout)layout);
        packageListComp.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        int i = 1;
        while (i <= this.licstatus.length) {
            Label pkgLabel = new Label(packageListComp, 0);
            pkgLabel.setText(Messages.LicenseFlexCompletionPage_licenseName);
            Label pkgNameLabel = new Label(packageListComp, 0);
            pkgNameLabel.setText("");
            Label typeLabel = new Label(packageListComp, 0);
            typeLabel.setText(Messages.LicenseFlexCompletionPage_licenseType);
            Label licTypeLabel = new Label(packageListComp, 0);
            licTypeLabel.setText("");
            Label expLabel = new Label(packageListComp, 0);
            expLabel.setText(Messages.LicenseFlexCompletionPage_expirationDate);
            Label expDateLabel = new Label(packageListComp, 0);
            expDateLabel.setText("");
            new Label(packageListComp, 0);
            new Label(packageListComp, 0);
            this.packageNames.add(pkgNameLabel);
            this.licenseTypes.add(licTypeLabel);
            this.expirationDates.add(expDateLabel);
            ++i;
        }
        return container;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.showResultText();
            this.showInstallDetails();
            this.reflowFor((Control)this.resultText);
            this.reflowFor(this.getControl());
        }
        super.setVisible(visible);
    }

    private void showResultText() {
        if (this.result == 0) {
            this.resultText.setText(Messages.LicenseFlexCompletionPage_result_success);
        } else if (this.result == 2) {
            this.resultText.setText(Messages.LicenseFlexCompletionPage_result_cancel);
        } else {
            this.resultText.setText(Messages.LicenseFlexCompletionPage_result_fail);
        }
    }

    private void showInstallDetails() {
        int i = 0;
        while (i < this.licstatus.length) {
            LicenseStatus ls = this.licstatus[i];
            String value = ls.getOfferingName();
            if (value != null) {
                ((Label)this.packageNames.get(i)).setText(value);
            }
            if ((value = ls.getLocalizedLicenseType()) != null) {
                ((Label)this.licenseTypes.get(i)).setText(value);
            }
            if ((value = ls.getExpireDateString()) != null) {
                ((Label)this.expirationDates.get(i)).setText(value);
            }
            ++i;
        }
    }
}

