/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.LocationCheckManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIDependenciesCheckUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.InstallLocationDetailsPage;
import com.ibm.cic.agent.internal.ui.wizards.InstallLocationSection;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class InstallLocationPage
extends AbstractAgentUIWizardPage {
    static final CustomMessageWizardPage.WarningId LOCATION_CHECK_WARNING = new CustomMessageWizardPage.WarningId();
    static final CustomMessageWizardPage.ErrorId LOCATION_CHECK_ERROR = new CustomMessageWizardPage.ErrorId();
    public static final CustomMessageWizardPage.ErrorId INSTALL_LOCATION_ERROR = new CustomMessageWizardPage.ErrorId();
    public static final CustomMessageWizardPage.WarningId INSTALL_LOCATION_WARNING = new CustomMessageWizardPage.WarningId();
    public static final CustomMessageWizardPage.ErrorId INSTALL_LOCATION_NO_PROFILE = new CustomMessageWizardPage.ErrorId();
    private InstallLocationDetailsPage detailsSection;
    private InstallLocationSection locationSection;
    private Profile[] recommendedProfiles;
    private Map profileStatusMap;
    private Map profileDependencyStatusMap;
    private IStatus detailsSectionStatus;
    private IStatus installLocationStatus;
    private IStatus applicabilityStatus;
    private IStatus locationCheckStatus;
    private boolean setInstallLocationOk = true;
    private boolean setInputOk = true;

    public InstallLocationPage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(toolkit, com.ibm.cic.agent.internal.ui.licenses.Messages.InstallLocationPage_title, Messages.InstallLocationPage_description, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.InstallLocationPage");
    }

    @Override
    protected IDetailsPage createDetailsSection() {
        this.detailsSection = new InstallLocationDetailsPage(this);
        return this.detailsSection;
    }

    @Override
    protected TreeSection createTreeSection(IFormContext context, Composite parent) {
        this.locationSection = new InstallLocationSection(context, parent, this);
        return this.locationSection;
    }

    Map getProfileDependencyStatusMap() {
        return this.profileDependencyStatusMap;
    }

    void calculateDependencyStatus() {
        Profile newProfile;
        List jobs = this.getSelectedProductJobs();
        ArrayList<Profile> allProfiles = new ArrayList<Profile>();
        Profile[] recommentedProfiles = this.getRecommendedProfiles();
        if (recommentedProfiles != null && recommentedProfiles.length > 0) {
            allProfiles.addAll(Arrays.asList(recommentedProfiles));
        }
        if ((newProfile = this.locationSection.getNewProfile()) != null) {
            allProfiles.add(newProfile);
        }
        this.profileDependencyStatusMap = AgentUIDependenciesCheckUtils.checkDependencies(jobs, allProfiles);
    }

    protected IStatus calculateRecommendedProfiles() {
        IStatus return_status = Status.OK_STATUS;
        this.profileStatusMap = new LinkedHashMap(this.getProductProfileList().size());
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        InstallLocationPage.this.recommendedProfiles = Agent.getInstance().getRecommendedProfiles(InstallLocationPage.this.getSelectedProductOfferings(), InstallLocationPage.this.profileStatusMap, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            return_status = Statuses.ERROR.get(target.getMessage(), new Object[0]);
            this.recommendedProfiles = new Profile[0];
            if (!(target instanceof CoreException)) {
                AgentUI.reportException(e, false);
            }
        }
        catch (InterruptedException e) {
            return_status = Statuses.ERROR.get(e.getMessage(), new Object[0]);
            this.recommendedProfiles = new Profile[0];
            AgentUI.reportException(e, false);
        }
        return return_status;
    }

    protected Profile[] getRecommendedProfiles() {
        return this.recommendedProfiles;
    }

    protected IStatus getRecommendedProfileStatus(Profile profile) {
        if (this.profileStatusMap != null && this.profileStatusMap.containsKey(profile)) {
            return (IStatus)this.profileStatusMap.get(profile);
        }
        return Status.OK_STATUS;
    }

    Profile getSelection() {
        List profilesList = this.getProductProfileList();
        if (profilesList.size() == 0) {
            return null;
        }
        return (Profile)profilesList.get(0);
    }

    @Override
    protected int[] getWeights() {
        return new int[]{40, 60};
    }

    void handleInstallLocationChange(String directory) {
        this.resetLocationCheckStatus();
        CicMultiStatus status = Statuses.ST.createMultiStatus(com.ibm.cic.common.core.utils.Messages.MultipleWarnings, new Object[0]);
        IStatus setInstallLocationStatus = this.setInstallLocation(directory);
        this.locationSection.refresh();
        if (StatusUtil.isErrorOrCancel((IStatus)setInstallLocationStatus)) {
            this.setInstallLocationOk = false;
            this.setErrorStateWithStatus(INSTALL_LOCATION_ERROR, setInstallLocationStatus);
            this.setWarningState(INSTALL_LOCATION_WARNING, null);
            return;
        }
        this.setInstallLocationOk = true;
        status.add(setInstallLocationStatus);
        this.installLocationStatus = this.detailsSection.validateDirectory();
        if (StatusUtil.isErrorOrCancel((IStatus)this.installLocationStatus)) {
            this.setErrorStateWithStatus(INSTALL_LOCATION_ERROR, this.installLocationStatus);
            this.setWarningState(INSTALL_LOCATION_WARNING, null);
            return;
        }
        status.add(this.installLocationStatus);
        this.applicabilityStatus = this.detailsSection.checkOfferingApplicability();
        if (StatusUtil.isErrorOrCancel((IStatus)this.applicabilityStatus)) {
            this.setErrorStateWithStatus(INSTALL_LOCATION_ERROR, this.applicabilityStatus);
            this.setWarningState(INSTALL_LOCATION_WARNING, null);
            return;
        }
        status.add(this.applicabilityStatus);
        this.applicabilityStatus = this.detailsSection.checkFixApplicability();
        if (StatusUtil.isErrorOrCancel((IStatus)this.applicabilityStatus)) {
            this.setErrorStateWithStatus(INSTALL_LOCATION_ERROR, this.applicabilityStatus);
            this.setWarningState(INSTALL_LOCATION_WARNING, null);
            return;
        }
        status.add(this.applicabilityStatus);
        this.detailsSectionStatus = this.detailsSection.validatePage();
        if (StatusUtil.isErrorOrCancel((IStatus)this.detailsSectionStatus)) {
            this.setWarningState(INSTALL_LOCATION_WARNING, null);
            this.setErrorStateWithStatus(INSTALL_LOCATION_ERROR, this.detailsSectionStatus);
            if (this.detailsSection.hasOfferingInterdependencyError() && this.detailsSectionStatus.isMultiStatus() && this.detailsSectionStatus.getChildren() != null && this.detailsSectionStatus.getChildren().length > 0 && this.getControl() != null && this.getControl().isVisible()) {
                WrapDetailUIDErrorDialog dlg = new WrapDetailUIDErrorDialog(this.getShell(), com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error, null, this.constructOfferingInterdependencyError(this.detailsSectionStatus), 15);
                dlg.open();
            }
            if (this.detailsSection.hasOfferingFixDependencyError() && this.detailsSectionStatus.isMultiStatus() && this.getControl() != null && this.getControl().isVisible()) {
                DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WrapDetailUIDErrorDialog dlg = new WrapDetailUIDErrorDialog(AgentUI.getActiveWorkbenchShell(), com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error, null, InstallLocationPage.this.detailsSectionStatus, 14);
                        dlg.open();
                    }
                });
            }
            return;
        }
        status.add(this.detailsSectionStatus);
        if (status.getSeverity() == 2) {
            IStatus[] children = status.getChildren();
            if (children != null && children.length == 1) {
                this.setWarningStateWithStatus(INSTALL_LOCATION_WARNING, children[0]);
            } else {
                status.setMessage(com.ibm.cic.common.core.utils.Messages.MultipleWarnings);
                this.setWarningStateWithStatus(INSTALL_LOCATION_WARNING, (IStatus)status);
            }
        } else {
            this.setWarningState(INSTALL_LOCATION_WARNING, null);
        }
        this.setErrorState(INSTALL_LOCATION_ERROR, null);
        this.detailsSection.updateLocationInfo();
        this.updateButtons();
    }

    void handleBitModeChange(int bits) {
        Profile profile = this.getSelection();
        AgentJob[] jobs = AgentUtil.getSelectedProductAgentJobArray((Collection)this.getSelectedJobs());
        if (bits == 32) {
            BitModeUtils.setProfilePlatformProperties((Profile)profile, (AgentJob[])jobs, (String)BitModeUtils.get32bitArch());
        } else {
            BitModeUtils.setProfilePlatformProperties((Profile)profile, (AgentJob[])jobs, (String)BitModeUtils.get64bitArch());
        }
        this.handleInstallLocationChange(BitModeUtils.getProfileInstallLocationForBitMode((Profile)profile));
    }

    private boolean hasProfileSelected() {
        return this.getSelection() != null;
    }

    protected boolean hasLocationCheckFailed() {
        if (this.locationCheckStatus == null) {
            return false;
        }
        return StatusUtil.isErrorOrCancel((IStatus)this.locationCheckStatus);
    }

    protected void setLocationCheckStatus(IStatus status) {
        this.locationCheckStatus = status;
    }

    protected void resetLocationCheckStatus() {
        this.locationCheckStatus = Status.OK_STATUS;
        this.setErrorState(LOCATION_CHECK_ERROR, null);
        this.setWarningState(LOCATION_CHECK_WARNING, null);
    }

    public boolean isPageComplete() {
        if (this.setInputOk && this.hasProfileSelected() && this.setInstallLocationOk && this.detailsSection != null && !this.hasLocationCheckFailed()) {
            return this.detailsSection.isDetailPageOk();
        }
        return false;
    }

    public IWizardPage getNextPage() {
        try {
            Status[] result = new Status[1];
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress((IStatus[])result){
                private final /* synthetic */ IStatus[] val$result;
                {
                    this.val$result = iStatusArray;
                }

                public void run(IProgressMonitor monitor) {
                    this.val$result[0] = LocationCheckManager.getInstance().initializeAndPerform(AgentUtil.getSelectedProductAgentJobArray((Collection)InstallLocationPage.this.getSelectedJobs()), monitor);
                }
            });
            this.setLocationCheckStatus((IStatus)result[0]);
            this.reportErrorOnPage((IStatus)result[0], LOCATION_CHECK_ERROR, LOCATION_CHECK_WARNING);
            if (StatusUtil.isErrorOrCancel((IStatus)result[0])) {
                return this;
            }
            this.detailsSection.saveSharedResourceLocation();
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
            return this;
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
            return this;
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && super.getNextPage() != null;
    }

    @Override
    protected void setFocus() {
        this.locationSection.setInput(this.getSelectedJobs());
        IStatus setInputStatus = this.locationSection.getCalculateRecommendedProfilStatus();
        if (StatusUtil.isErrorOrCancel((IStatus)setInputStatus)) {
            this.setInputOk = false;
            this.setErrorStateWithStatus(INSTALL_LOCATION_ERROR, setInputStatus);
            this.setWarningState(INSTALL_LOCATION_WARNING, null);
            return;
        }
        this.setInputOk = true;
        if (this.locationSection.getLocationType() == 0 && this.locationSection.getNewProfile() == null) {
            int size = this.getSelectedProductJobs().size();
            String errorMsg = size > 1 ? Messages.InstallLocationPage_NoProfile_multipleJobs : Messages.InstallLocationPage_NoProfile_singleJob;
            this.setErrorState(INSTALL_LOCATION_NO_PROFILE, errorMsg);
            return;
        }
        if (this.detailsSection.isReady()) {
            this.detailsSection.showInstalledOfferings();
            this.detailsSection.showDiskSpaceInfo();
            if (this.setInstallLocationOk) {
                CicMultiStatus multiStatus = Statuses.ST.createMultiStatus();
                IStatus dirStatus = this.detailsSection.validateDirectory();
                if (StatusUtil.isErrorOrCancel((IStatus)dirStatus)) {
                    this.setWarningState(INSTALL_LOCATION_WARNING, null);
                    this.setErrorStateWithStatus(INSTALL_LOCATION_ERROR, dirStatus);
                } else {
                    multiStatus.add(dirStatus);
                    IStatus appStatus = this.detailsSection.checkOfferingApplicability();
                    if (!StatusUtil.isErrorOrCancel((IStatus)appStatus)) {
                        appStatus = this.detailsSection.checkFixApplicability();
                    }
                    if (StatusUtil.isErrorOrCancel((IStatus)appStatus)) {
                        this.setWarningState(INSTALL_LOCATION_WARNING, null);
                        this.setErrorStateWithStatus(INSTALL_LOCATION_ERROR, appStatus);
                    } else {
                        multiStatus.add(appStatus);
                        if (StatusUtil.isErrorOrCancel((IStatus)this.installLocationStatus) || StatusUtil.isErrorOrCancel((IStatus)this.applicabilityStatus)) {
                            this.detailsSectionStatus = this.detailsSection.validatePage();
                            if (StatusUtil.isErrorOrCancel((IStatus)this.detailsSectionStatus)) {
                                this.setWarningState(INSTALL_LOCATION_WARNING, null);
                                this.setErrorStateWithStatus(INSTALL_LOCATION_ERROR, this.detailsSectionStatus);
                            } else {
                                multiStatus.add(this.detailsSectionStatus);
                                if (multiStatus.matches(2)) {
                                    IStatus[] children = multiStatus.getChildren();
                                    if (children != null && children.length == 1) {
                                        this.setWarningStateWithStatus(INSTALL_LOCATION_WARNING, children[0]);
                                    } else {
                                        multiStatus.setMessage(com.ibm.cic.common.core.utils.Messages.MultipleWarnings);
                                        this.setWarningStateWithStatus(INSTALL_LOCATION_WARNING, (IStatus)multiStatus);
                                    }
                                    this.setErrorState(INSTALL_LOCATION_ERROR, null);
                                } else {
                                    this.setWarningState(INSTALL_LOCATION_WARNING, null);
                                    this.setErrorState(INSTALL_LOCATION_ERROR, null);
                                }
                            }
                            this.locationSection.refresh();
                            this.detailsSection.updateLocationInfo();
                        }
                    }
                    this.applicabilityStatus = appStatus;
                }
                this.installLocationStatus = dirStatus;
                if (this.detailsSectionStatus != null && StatusUtil.isErrorOrCancel((IStatus)this.detailsSectionStatus) && this.detailsSection.hasOfferingInterdependencyError() && this.getControl() != null && this.getControl().isVisible()) {
                    boolean allExtensionOfferings = true;
                    IOffering[] offerings = this.getSelectedProductOfferings();
                    if (offerings.length == 0) {
                        allExtensionOfferings = false;
                    } else {
                        int i = 0;
                        while (i < offerings.length) {
                            if (!Agent.isExtensionOffering((IOfferingOrFix)offerings[i])) {
                                allExtensionOfferings = false;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (allExtensionOfferings) {
                        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = AgentUI.getActiveWorkbenchShell();
                                if (shell != null && !shell.isDisposed()) {
                                    WrapDetailUIDErrorDialog dlg = new WrapDetailUIDErrorDialog(shell, com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error, null, InstallLocationPage.this.constructOfferingInterdependencyError(InstallLocationPage.this.detailsSectionStatus), 15);
                                    dlg.open();
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    private IStatus constructOfferingInterdependencyError(IStatus statusFromCore) {
        TreeItem[] items;
        TreeViewer viewer;
        if (statusFromCore.getCode() != 402 && statusFromCore.getCode() != 401) {
            return statusFromCore;
        }
        String msgFromCore = statusFromCore.getMessage();
        int profileNum = 0;
        if (this.locationSection != null && (viewer = this.locationSection.getTreeViewer()) != null && (items = viewer.getTree().getItems()) != null) {
            profileNum = items.length;
        }
        CicMultiStatus result = Statuses.ST.createMultiStatusFromStatus(statusFromCore);
        if (statusFromCore.getCode() == 401) {
            result.setMessage(String.valueOf(msgFromCore) + (profileNum > 1 ? Messages.InstallLocationPage_offeringInterdependencyError_multipleProfiles : Messages.InstallLocationPage_offeringInterdependencyError_singleProfile));
        } else {
            result.setMessage(String.valueOf(msgFromCore) + (profileNum > 1 ? Messages.InstallLocationPage_offeringInterdependencyErrorPackageOnly_multipleProfiles : Messages.InstallLocationPage_offeringInterdependencyErrorPackageOnly_singleProfile));
        }
        return result;
    }

    private IStatus setInstallLocation(String location) {
        Profile profile = this.getSelection();
        String oldLocation = profile.getInstallLocation();
        if (location.equals(oldLocation)) {
            IStatus status = SharedUIUtils.checkBitModeArtifacts((List)this.getSelectedJobsWithoutAgentJob(), (Profile)profile);
            return status;
        }
        IStatus setLocationStatus = profile.setInstallLocation(location);
        if (!StatusUtil.isErrorOrCancel((IStatus)setLocationStatus)) {
            profile.setNeedsRequalification();
            IStatus status = SharedUIUtils.checkBitModeArtifacts((List)this.getSelectedJobsWithoutAgentJob(), (Profile)profile);
            if (!status.isOK()) {
                return status;
            }
        }
        return setLocationStatus;
    }

    void setSelection(Profile profile) {
        List profilesList = this.getProductProfileList();
        profilesList.clear();
        Map profileLocaleLangs = this.getProfileLocalLanguagesMap();
        if (profile != null) {
            profilesList.add(profile);
            profileLocaleLangs.put(profile, null);
            this.updateJobsProfile(profile);
        }
    }

    private void updateJobsProfile(Object object) {
        int length = Integer.MAX_VALUE;
        Profile profile = (Profile)object;
        for (AbstractJob job : this.getSelectedProductJobs()) {
            job.setProfile(profile);
            int pathLength = PlatformUtils.getMaxInstallLocationLengthForOffering((IOffering)job.getOffering());
            if (pathLength >= length) continue;
            length = pathLength;
        }
        profile.setMaxInstallLocationLength(length);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.resetLocationCheckStatus();
        }
        super.setVisible(visible);
    }
}

