/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.internal.ui.parts.TreeFilterBoxPart;
import com.ibm.cic.agent.internal.ui.utils.FixNode;
import com.ibm.cic.agent.internal.ui.utils.VersionNode;
import com.ibm.cic.agent.internal.ui.wizards.CheckboxTreeMasterSection;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class CheckboxTreeFilterSection
extends CheckboxTreeMasterSection {
    protected TreeFilterBoxPart filterBoxPart;

    public CheckboxTreeFilterSection(IFormContext context, Composite parent, int sectionStyle, String[] buttonLabels, int buttonsOrientation) {
        super(context, parent, sectionStyle, buttonLabels, buttonsOrientation);
    }

    public CheckboxTreeFilterSection(IFormContext context, Composite parent, String[] buttonLabels) {
        super(context, parent, buttonLabels);
    }

    public void restoreCheckState() {
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        Tree tree = viewer.getTree();
        if (tree.getItemCount() == 0) {
            return;
        }
        tree.setRedraw(false);
        viewer.expandAll();
        TreeItem[] items = tree.getItems();
        this.checkLeafItems(viewer, items);
        tree.setRedraw(true);
    }

    protected void checkLeafItems(CheckboxTreeViewer viewer, TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            TreeItem[] children = items[i].getItems();
            if (children == null || children.length == 0) {
                FixNode fixNode;
                Object data = items[i].getData();
                if (data instanceof VersionNode) {
                    VersionNode vNode = (VersionNode)data;
                    if (vNode.isSelected() && !items[i].getChecked()) {
                        items[i].setChecked(true);
                        this.updateParents(viewer, vNode.getParent(), true);
                    }
                } else if (data instanceof FixNode && (fixNode = (FixNode)data).isSelected() && !items[i].getChecked()) {
                    items[i].setChecked(true);
                    this.updateParents(viewer, fixNode.getParent(), true);
                }
            } else {
                this.checkLeafItems(viewer, children);
            }
            ++i;
        }
    }

    @Override
    protected Object[] getChildren(Object element) {
        Object[] result = super.getChildren(element);
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        ViewerFilter[] filters = viewer.getFilters();
        if (filters != null) {
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                Object[] filteredResult = filter.filter((Viewer)viewer, element, result);
                result = filteredResult;
                ++n2;
            }
        }
        return result;
    }

    class TreeViewerWithFilterPartAdapter
    extends TreeSection.PartAdapter {
        private boolean filterOffering;

        public TreeViewerWithFilterPartAdapter(String[] buttonLabels, int buttonsOrientation) {
            super(buttonLabels, buttonsOrientation);
            this.filterOffering = false;
        }

        public TreeViewerWithFilterPartAdapter(String[] buttonLabels, int buttonsOrientation, boolean filterOffering) {
            this(buttonLabels, buttonsOrientation);
            this.filterOffering = filterOffering;
        }

        @Override
        protected void createMainControl(Composite parent, int style, int span, FormToolkit toolkit) {
            Composite mainContainer = toolkit.createComposite(parent);
            GridLayout mainLayout = new GridLayout();
            mainLayout.verticalSpacing = 0;
            mainLayout.marginHeight = 0;
            mainLayout.marginWidth = 0;
            mainContainer.setLayout((Layout)mainLayout);
            GridData mainData = new GridData(1808);
            mainData.horizontalSpan = span;
            mainContainer.setLayoutData((Object)mainData);
            CheckboxTreeFilterSection.this.filterBoxPart = new TreeFilterBoxPart(CheckboxTreeFilterSection.this, this.filterOffering);
            CheckboxTreeFilterSection.this.filterBoxPart.createFilterBoxControl(mainContainer, toolkit);
            super.createMainControl(mainContainer, style, 1, toolkit);
            CheckboxTreeFilterSection.this.filterBoxPart.setFilterTreeViewer(this.getTreeViewer());
        }
    }
}

