/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.console.manager.InstalledOfferingsState;
import com.ibm.cic.agent.core.console.manager.SelectedLicensesState;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.BaseJobContentProvider;
import com.ibm.cic.agent.internal.ui.utils.FixNode;
import com.ibm.cic.agent.internal.ui.utils.PackageNode;
import com.ibm.cic.agent.internal.ui.utils.UpdateAgentUtils;
import com.ibm.cic.agent.internal.ui.utils.VersionNode;
import com.ibm.cic.agent.internal.ui.wizards.CheckboxTreeFilterSection;
import com.ibm.cic.agent.internal.ui.wizards.IOfferingsInRepPage;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.internal.dialogs.YesNoErrorDialog;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.StructuredViewerPart;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.framework.Version;

public class AvailableOfferingSection
extends CheckboxTreeFilterSection {
    private BaseJobContentProvider contentProvider;
    private InstalledOfferingsState installedOfferings;
    private final Map packages;
    private RecommendedFilter recommendedFilter;
    private final IOfferingsInRepPage wizardPage;
    private boolean showAll;
    private Button showAllButton;
    private final boolean isWizardMode;
    private boolean firstTimeShowAll;
    private final boolean[] searchForUpdateWasCanceled;
    private final boolean[] installNewerIM;
    private boolean checkForUpdateButtonWasClicked;
    private boolean isInstallFlow;

    public AvailableOfferingSection(IFormContext context, Composite parent, IOfferingsInRepPage wizardPage, boolean isInstall) {
        String[] stringArray;
        if (isInstall) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = Messages.AvailableOfferingSection_checkForLatest_new;
        } else {
            stringArray = new String[]{};
        }
        super(context, parent, 4096, stringArray, 256);
        this.showAll = false;
        this.firstTimeShowAll = true;
        this.searchForUpdateWasCanceled = new boolean[1];
        this.installNewerIM = new boolean[1];
        this.checkForUpdateButtonWasClicked = false;
        this.isInstallFlow = true;
        this.wizardPage = wizardPage;
        this.packages = new HashMap();
        this.isWizardMode = AgentInput.getInstance().getMode() == 1 && AgentInput.getInstance().getWizardSubMode() != 8;
        this.configureViewer((TreeViewer)this.getCheckboxTreeViewer());
        this.getSection().setText(Messages.AvailableOfferingSection_header);
        this.isInstallFlow = isInstall;
    }

    public AvailableOfferingSection(IFormContext context, Composite parent, IOfferingsInRepPage wizardPage) {
        this(context, parent, wizardPage, true);
    }

    @Override
    protected StructuredViewerPart createViewerPart(String[] buttonLabels) {
        return new CheckboxTreeFilterSection.TreeViewerWithFilterPartAdapter(this, buttonLabels, this.buttonsOrientation, true);
    }

    private void buildVersionTree(List jobs) {
        for (AbstractJob job : jobs) {
            IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
            if (!(offeringOrFix instanceof IOffering)) continue;
            IOffering offering = (IOffering)offeringOrFix;
            IIdentity identity = offering.getIdentity();
            PackageNode packageNode = (PackageNode)this.packages.get(identity);
            if (packageNode == null) {
                packageNode = new PackageNode(offering, this.isInstallFlow);
                if (this.installedOfferings.isInstalled(identity)) {
                    packageNode.setInstalled(true);
                }
                this.packages.put(identity, packageNode);
            }
            if (packageNode.containsVersion(job)) continue;
            VersionNode versionNode = packageNode.addVersion(job);
            if (!this.installedOfferings.isInstalled(offering)) continue;
            versionNode.setInstalled(true);
            packageNode.setInstalled(true);
        }
        this.detectRecommendedVersions();
    }

    private void detectRecommendedVersions() {
        for (PackageNode packageNode : this.packages.values()) {
            Iterator versions = packageNode.getVersionNodes().iterator();
            VersionNode recommendedVersionNode = null;
            VersionNode latestUnavailableVersionNode = null;
            while (versions.hasNext()) {
                Version currentVersion;
                VersionNode versionNode = (VersionNode)versions.next();
                if (versionNode.isUnavailable() && recommendedVersionNode == null) {
                    if (latestUnavailableVersionNode == null) {
                        latestUnavailableVersionNode = versionNode;
                    } else {
                        Version latestVersion = latestUnavailableVersionNode.getOffering().getVersion();
                        currentVersion = versionNode.getOffering().getVersion();
                        if (currentVersion.compareTo(latestVersion) > 0) {
                            latestUnavailableVersionNode = versionNode;
                        }
                    }
                }
                if (!versionNode.canBeInstalled()) continue;
                if (recommendedVersionNode == null) {
                    recommendedVersionNode = versionNode;
                    continue;
                }
                Version recommendedVersion = recommendedVersionNode.getOffering().getVersion();
                currentVersion = versionNode.getOffering().getVersion();
                if (currentVersion.compareTo(recommendedVersion) <= 0) continue;
                recommendedVersionNode.setRecommended(false);
                recommendedVersionNode = versionNode;
            }
            if (recommendedVersionNode == null && latestUnavailableVersionNode != null) {
                recommendedVersionNode = latestUnavailableVersionNode;
            }
            if (recommendedVersionNode == null) continue;
            recommendedVersionNode.setRecommended(true);
            packageNode.setOffering(recommendedVersionNode.getOffering());
        }
    }

    private TreeItem getFirstCheckedItem(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        if (tree.getItemCount() > 0) {
            TreeItem[] items;
            TreeItem[] treeItemArray = items = tree.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getChecked()) {
                    TreeItem[] packageItems;
                    TreeItem[] treeItemArray2 = packageItems = item.getItems();
                    int n3 = packageItems.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeItem packageItem = treeItemArray2[n4];
                        if (packageItem.getChecked()) {
                            return packageItem;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void primeSelection() {
        TreeViewer viewer = this.getTreePart().getTreeViewer();
        if (viewer != null) {
            TreeItem firstCheckedPkgItem = this.getFirstCheckedItem(viewer);
            if (firstCheckedPkgItem != null) {
                viewer.setSelection((ISelection)new StructuredSelection(firstCheckedPkgItem.getData()));
            } else {
                Tree tree = viewer.getTree();
                if (tree.getItemCount() > 0) {
                    TreeItem item = tree.getItem(0);
                    viewer.setSelection((ISelection)new StructuredSelection(item.getData()));
                }
            }
        }
    }

    @Override
    protected void buttonSelected(int index) {
        if (index == 0) {
            this.searchForUpdateWasCanceled[0] = false;
            this.installNewerIM[0] = false;
            this.checkForUpdateButtonWasClicked = true;
            this.searchForOtherVersionsExtensions();
        }
    }

    private void checkDefaultJobs() {
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        for (PackageNode nextPackage : this.packages.values()) {
            for (VersionNode versionNode : nextPackage.getVersionNodes()) {
                if (!versionNode.isSelected()) continue;
                AbstractJob job = versionNode.getJob();
                IStatus precheckStatus = Status.OK_STATUS;
                if (job != null) {
                    precheckStatus = AgentUIUtils.runPrecheckBundles((AgentJob)job);
                }
                if (!StatusUtil.isErrorOrCancel((IStatus)precheckStatus) && versionNode.canBeInstalled()) {
                    this.elementChecked(viewer, versionNode, true);
                    this.uncheckSiblings(viewer, versionNode);
                    this.updateParents(viewer, versionNode.getParent(), true);
                    continue;
                }
                versionNode.setSelected(false);
            }
        }
    }

    @Override
    protected void checkItem(CheckboxTreeViewer viewer, Object element, boolean checked, boolean grayed) {
        super.checkItem(viewer, element, checked, grayed);
        if (element instanceof VersionNode) {
            ((VersionNode)element).setSelected(checked);
            if (checked) {
                this.uncheckSiblings(viewer, element);
            }
            viewer.update(element, null);
        }
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        this.contentProvider = new BaseJobContentProvider();
        viewer.setLabelProvider((IBaseLabelProvider)new JobLabelProvider(DisplayKeeper.INSTANCE.getDisplay()));
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setSorter((ViewerSorter)new OfferingSorter());
        this.recommendedFilter = new RecommendedFilter();
        viewer.addFilter((ViewerFilter)this.recommendedFilter);
        viewer.addFilter((ViewerFilter)new PekFilter());
        viewer.addFilter((ViewerFilter)new NewAgentFilter());
        this.createColumns(viewer);
        this.createInstalledOfferings();
        this.buildVersionTree(this.wizardPage.getJobs());
        viewer.setInput((Object)this.getRootNodes());
        viewer.expandAll();
        this.setTopItemVisible(viewer);
        if (this.isWizardMode) {
            this.getTreePart().setButtonEnabled(0, false);
        } else {
            this.getTreePart().setButtonEnabled(0, !this.installedOfferings.isEmpty());
        }
        if (this.isInstallFlow) {
            this.checkDefaultJobs();
            this.wizardPage.setSelection(this.getSelectedJobs());
        }
        final TreeViewer finalViewer = viewer;
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                AvailableOfferingSection.this.changeCheckForUpdateButtonStatus(finalViewer);
            }
        });
        this.filterBoxPart.setFilterContainerVisible(true);
        if (this.isWizardMode) {
            List selectedJobs = AgentUIUtils.getSelectedJobs(this.wizardPage.getJobs());
            int selectedPkgNum = selectedJobs.size();
            if (selectedPkgNum == 1) {
                this.filterBoxPart.setSelectionHint(Messages.AvailableOfferingSection_pkgSelected_single);
            } else if (selectedPkgNum > 1) {
                this.filterBoxPart.setSelectionHint(NLS.bind((String)Messages.AvailableOfferingSection_pkgSelected_multi, (Object)selectedPkgNum));
            }
        }
        AgentUIUtils.showOrHideFilterBoxAsync(finalViewer, this.filterBoxPart);
    }

    private void setTopItemVisible(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        if (tree.getItemCount() > 0) {
            TreeItem item = tree.getItem(0);
            tree.setTopItem(item);
        }
    }

    protected void checkJobsToleranceForAgent() {
        if (!this.isWizardMode) {
            return;
        }
        if (!this.uncheckJobsThatDontTolerateAgent()) {
            return;
        }
        this.wizardPage.setSelection(this.getSelectedJobs());
        this.checkForAgentUpdate();
    }

    private boolean checkForAgentUpdate(IStatus[] status, boolean mandatoryUpdate, IProgressMonitor monitor) {
        AbstractJob selectedAgentJob = this.getSelectedAgentJob();
        if (selectedAgentJob != null) {
            AbstractJob[] updateAgentJob = new AbstractJob[1];
            status[0] = UpdateAgentUtils.checkForNewerVersionAgent(selectedAgentJob, updateAgentJob, monitor);
            if (updateAgentJob[0] != null && status[0] instanceof CicMultiStatus) {
                if (status[0].isOK()) {
                    this.installNewerIM[0] = true;
                    this.wizardPage.getProcessedOfferings().add(updateAgentJob[0].getOffering());
                    List selectedJobList = this.wizardPage.getJobs();
                    selectedJobList.clear();
                    selectedJobList.add(updateAgentJob[0]);
                    return true;
                }
                if (status[0].getCode() == -50) {
                    status[0] = Statuses.ST.createMultiStatusWithChild(Status.CANCEL_STATUS, null, new Object[0]);
                    return mandatoryUpdate;
                }
            }
        } else {
            status[0] = UpdateAgentUtils.checkForAgentUpdateNDisplayServiceRepStatus(monitor);
            if (StatusUtil.isCancel((IStatus)status[0])) {
                return mandatoryUpdate;
            }
            if (StatusUtil.isError((IStatus)status[0]) || status[0].getCode() != -51) {
                return true;
            }
        }
        return false;
    }

    private void checkForAgentUpdate() {
        final IStatus[] status = new IStatus[]{Status.OK_STATUS};
        this.installNewerIM[0] = false;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                AvailableOfferingSection.this.checkForAgentUpdate(status, true, monitor);
            }
        };
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, runnable);
            if (StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                return;
            }
            if (this.installNewerVersionOfIM()) {
                return;
            }
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
    }

    private boolean uncheckJobsThatDontTolerateAgent() {
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        boolean uncheckedJob = false;
        List rootNodes = this.getRootNodesInOrder();
        for (PackageNode nextPackage : rootNodes) {
            for (VersionNode versionNode : nextPackage.getVersionNodes()) {
                if (!versionNode.isSelected() || versionNode.getToleranceStatus().isOK()) continue;
                if (!uncheckedJob) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)versionNode));
                    uncheckedJob = true;
                }
                this.elementChecked(viewer, versionNode, false);
                this.updateParents(viewer, versionNode.getParent(), false);
            }
        }
        return uncheckedJob;
    }

    private List getRootNodesInOrder() {
        Object[] expandedElements;
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        ArrayList<Object> rootNodes = new ArrayList<Object>();
        Object[] objectArray = expandedElements = viewer.getExpandedElements();
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof PackageNode) {
                rootNodes.add(object);
            }
            ++n2;
        }
        return rootNodes;
    }

    private void uncheckInstalledJobs(List installedSelectedJobs) {
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        for (PackageNode nextPackage : this.packages.values()) {
            for (VersionNode versionNode : nextPackage.getVersionNodes()) {
                AbstractJob job = versionNode.getJob();
                if (!versionNode.isSelected() || !installedSelectedJobs.contains(job)) continue;
                this.elementChecked(viewer, versionNode, false);
                this.updateParents(viewer, versionNode.getParent(), false);
            }
        }
    }

    protected void checkInstalledOfferings() {
        List installedSelectedJobs = this.getInstalledSelectedJobs();
        if (installedSelectedJobs.size() > 0) {
            ArrayList<AbstractJob> installedSingletonJobs = new ArrayList<AbstractJob>();
            ArrayList<AbstractJob> installedNonSingletonJobs = new ArrayList<AbstractJob>();
            int i = 0;
            while (i < installedSelectedJobs.size()) {
                AbstractJob job = (AbstractJob)installedSelectedJobs.get(i);
                IOffering selectedOffering = job.getOffering();
                if (selectedOffering != null) {
                    IOffering installedOffering = this.installedOfferings.getInstalled(selectedOffering.getIdentity());
                    if (this.isSingletonOffering(selectedOffering) || this.isSingletonOffering(installedOffering)) {
                        installedSingletonJobs.add(job);
                    } else if (OfferingProperty.showHasBeenInstalledDialog((IOffering)selectedOffering)) {
                        installedNonSingletonJobs.add(job);
                    }
                }
                ++i;
            }
            boolean continueInstall = true;
            if (installedSingletonJobs.size() > 0 || installedNonSingletonJobs.size() > 0) {
                continueInstall = this.confirmInstalledOfferings(installedSingletonJobs, installedNonSingletonJobs);
            }
            if (!continueInstall) {
                this.uncheckInstalledJobs(installedSelectedJobs);
                this.wizardPage.setSelection(this.getSelectedJobs());
            } else if (installedSingletonJobs.size() > 0) {
                this.uncheckInstalledJobs(installedSingletonJobs);
                this.wizardPage.setSelection(this.getSelectedJobs());
            }
        }
    }

    private List getInstalledSelectedJobs() {
        AbstractJob[] selectedJobs;
        ArrayList<AbstractJob> return_result = new ArrayList<AbstractJob>();
        AbstractJob[] abstractJobArray = selectedJobs = this.getSelectedJobs();
        int n = selectedJobs.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractJob job = abstractJobArray[n2];
            IOffering offering = job.getOffering();
            if (offering != null && !AgentUI.getDefault().getAgent().isAgentOffering((IOfferingOrFix)offering) && !LicenseUtils.isPEKOffering((IOffering)offering) && (this.installedOfferings.isInstalled(offering) || this.installedOfferings.isInstalled(offering.getIdentity()))) {
                return_result.add(job);
            }
            ++n2;
        }
        return return_result;
    }

    protected void resetTreeViewer() {
        this.packages.clear();
        this.buildVersionTree(this.wizardPage.getJobs());
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        viewer.setInput((Object)this.getRootNodes());
        viewer.expandAll();
        this.setTopItemVisible((TreeViewer)viewer);
        this.checkDefaultJobs();
        this.wizardPage.setSelection(this.getSelectedJobs());
        this.primeSelection();
        AgentUIUtils.showOrHideFilterBoxAsync((TreeViewer)viewer, this.filterBoxPart);
    }

    private boolean confirmInstalledOfferings(List installedSingletonJobs, List installedNonSingletonJobs) {
        IOffering offering;
        String whatToDoMsg;
        boolean displaySingletonOfferingErrorDlg = false;
        ArrayList installedSingletonOfferingInstance = new ArrayList();
        ArrayList installedNonSingletonOfferingInstance = new ArrayList();
        int installedSingletonOfferingNum = 0;
        String singletonMsg = "";
        if (installedSingletonJobs.size() > 0) {
            StringBuffer singletonOfferingNames = new StringBuffer();
            int i = 0;
            while (i < installedSingletonJobs.size()) {
                AbstractJob job = (AbstractJob)installedSingletonJobs.get(i);
                IOffering offering2 = job.getOffering();
                if (offering2 != null) {
                    ++installedSingletonOfferingNum;
                    if (singletonOfferingNames.length() > 0) {
                        singletonOfferingNames.append(", ");
                    }
                    singletonOfferingNames.append(offering2.getName());
                    List installedOfferingList = this.installedOfferings.getInstalledList(offering2.getIdentity());
                    if (!installedOfferingList.isEmpty()) {
                        installedSingletonOfferingInstance.addAll(installedOfferingList);
                        Version currentSelectedOfferingVer = offering2.getVersion();
                        for (IOffering installedOffering : installedOfferingList) {
                            Version installedOfferingVer = installedOffering.getVersion();
                            if (installedOfferingVer.compareTo(currentSelectedOfferingVer) >= 0 || displaySingletonOfferingErrorDlg) continue;
                            displaySingletonOfferingErrorDlg = true;
                        }
                    }
                }
                ++i;
            }
            singletonMsg = installedSingletonOfferingNum > 1 ? NLS.bind((String)Messages.AvailableOfferingPage_singleton_multiple, (Object)singletonOfferingNames.toString()) : NLS.bind((String)Messages.AvailableOfferingPage_installedPkg_singleton, (Object)singletonOfferingNames.toString());
        }
        int installedNonSingletonOfferingNum = 0;
        String nonSingletonMsg = "";
        if (installedNonSingletonJobs.size() > 0) {
            StringBuffer offeringNames = new StringBuffer();
            int i = 0;
            while (i < installedNonSingletonJobs.size()) {
                AbstractJob job = (AbstractJob)installedNonSingletonJobs.get(i);
                IOffering offering3 = job.getOffering();
                if (offering3 != null) {
                    ++installedNonSingletonOfferingNum;
                    if (offeringNames.length() > 0) {
                        offeringNames.append(", ");
                    }
                    offeringNames.append(offering3.getName());
                    List installedOfferingList = this.installedOfferings.getInstalledList(offering3.getIdentity());
                    if (!installedOfferingList.isEmpty()) {
                        installedNonSingletonOfferingInstance.addAll(installedOfferingList);
                    }
                }
                ++i;
            }
            nonSingletonMsg = NLS.bind((String)Messages.AvailableOfferingPage_singlePkgIntalled, (Object)offeringNames.toString());
            if (installedNonSingletonOfferingNum > 1) {
                nonSingletonMsg = NLS.bind((String)Messages.AvailableOfferingPage_multiplePkgInstalled, (Object)offeringNames.toString());
            }
        }
        StringBuffer msgToDisplay = new StringBuffer();
        if (installedSingletonOfferingNum > 0) {
            msgToDisplay = new StringBuffer(singletonMsg);
        }
        if (installedNonSingletonOfferingNum == 0) {
            if (displaySingletonOfferingErrorDlg) {
                whatToDoMsg = Messages.AvailableOfferingPage_singletonPkg_whatToDo;
                if (this.isWizardMode) {
                    whatToDoMsg = Messages.AvailableOfferingPage_singletonPkg_whatToDo_wzdMode;
                }
                msgToDisplay.append("\n\n");
                msgToDisplay.append(whatToDoMsg);
                CicMultiStatus displayStatus = Statuses.ERROR.getMultiStatus(msgToDisplay.toString(), new Object[0]);
                int i = 0;
                while (i < installedSingletonOfferingInstance.size()) {
                    offering = (IOffering)installedSingletonOfferingInstance.get(i);
                    ICicStatus status = Statuses.ERROR.get(Messages.AvailableOfferingPage_installedPkg_singleton, new Object[]{AgentUIUtils.getOfferingOrFixLabel((IOfferingOrFix)offering)});
                    displayStatus.add((IStatus)status);
                    ++i;
                }
                WrapDetailUIDErrorDialog.openError((Shell)this.getCheckboxTreeViewer().getTree().getShell(), (String)Messages.AvailableOfferingPage_alreadyInstalledDialogTitle, null, (IStatus)displayStatus);
            }
            return false;
        }
        if (msgToDisplay.length() > 0) {
            msgToDisplay.append("\n\n");
        }
        msgToDisplay.append(nonSingletonMsg);
        whatToDoMsg = Messages.AvailableOfferingPage_pkgInstalled_whatToDo;
        if (this.isWizardMode) {
            whatToDoMsg = Messages.AvailableOfferingPage_pkgInstalled_whatToDo_wizardMode;
        }
        msgToDisplay.append("\n\n");
        msgToDisplay.append(whatToDoMsg);
        CicMultiStatus status = Statuses.OK.getMultiStatus(msgToDisplay.toString(), new Object[0]);
        int i = 0;
        while (i < installedSingletonOfferingInstance.size()) {
            offering = (IOffering)installedSingletonOfferingInstance.get(i);
            status.add((IStatus)Statuses.WARNING.get(Messages.AvailableOfferingPage_installedPkg_singleton, new Object[]{AgentUIUtils.getOfferingOrFixLabel((IOfferingOrFix)offering)}));
            ++i;
        }
        i = 0;
        while (i < installedNonSingletonOfferingInstance.size()) {
            offering = (IOffering)installedNonSingletonOfferingInstance.get(i);
            status.add((IStatus)Statuses.WARNING.get(Messages.AvailableOfferingPage_singlePkgIntalled, new Object[]{AgentUIUtils.getOfferingOrFixLabel((IOfferingOrFix)offering)}));
            ++i;
        }
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        YesNoErrorDialog dialog = new YesNoErrorDialog(viewer.getTree().getShell(), Messages.AvailableOfferingPage_alreadyInstalledDialogTitle, null, (IStatus)status, 2, Messages.AvailableOfferingPage_offeringInstalledDlg_Continue, Messages.AvailableOfferingPage_offeringInstalledDlg_Cancel);
        return dialog.open() == 2;
    }

    private boolean containSingletonOffering(List offeringList) {
        int i = 0;
        while (i < offeringList.size()) {
            IOffering offering = (IOffering)offeringList.get(i);
            if (AgentUtil.isSingletonOffering((IOffering)offering)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isSingletonOffering(IOffering offering) {
        return AgentUtil.isSingletonOffering((IOffering)offering);
    }

    private void confirmInstalledSingletonOfferings(List installedOfferingList, String message) {
        CicMultiStatus status = Statuses.ERROR.getMultiStatus(message, new Object[0]);
        int i = 0;
        while (i < installedOfferingList.size()) {
            IOffering offering = (IOffering)installedOfferingList.get(i);
            String childStatusMsg = NLS.bind((String)Messages.AvailableOfferingPage_installedPkg_singleton, (Object)AgentUIUtils.getOfferingOrFixLabel((IOfferingOrFix)offering));
            status.add((IStatus)new Status(4, "com.ibm.cic.agent.ui", childStatusMsg));
            ++i;
        }
        WrapDetailUIDErrorDialog.openError((Shell)this.wizardPage.getShell(), (String)Messages.AvailableOfferingPage_alreadyInstalledDialogTitle, null, (IStatus)status);
    }

    private boolean confirmInstalledOfferings(List installedOfferingList, String message) {
        CicMultiStatus status = Statuses.OK.getMultiStatus(message, new Object[0]);
        int i = 0;
        while (i < installedOfferingList.size()) {
            IOffering installedOffering = (IOffering)installedOfferingList.get(i);
            status.add((IStatus)new Status(2, "com.ibm.cic.agent.ui", 0, NLS.bind((String)Messages.AvailableOfferingPage_installedOffering, (Object)AgentUIUtils.getOfferingOrFixLabel((IOfferingOrFix)installedOffering)), null));
            ++i;
        }
        YesNoErrorDialog dialog = new YesNoErrorDialog(this.wizardPage.getShell(), Messages.AvailableOfferingPage_alreadyInstalledDialogTitle, null, (IStatus)status, 2, Messages.AvailableOfferingPage_offeringInstalledDlg_Continue, Messages.AvailableOfferingPage_offeringInstalledDlg_Cancel);
        return dialog.open() == 2;
    }

    private TreeColumn createColumn(Tree tree, String name, TableLayout tableLayout, int width) {
        TreeColumn column = new TreeColumn(tree, 0x800000);
        column.setText(name);
        column.setResizable(true);
        if (tableLayout == null) {
            column.setWidth(width);
        } else {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(width, width, true));
        }
        return column;
    }

    private void createColumns(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        this.createColumn(tree, Messages.AvailableOfferingSection_columnPackage, tableLayout, 300);
        this.createColumn(tree, Messages.AvailableOfferingSection_columnInstalled, tableLayout, 100);
        this.createColumn(tree, Messages.AvailableOfferingSection_columnVendor, tableLayout, 100);
        this.createColumn(tree, Messages.AvailableOfferingSection_columnLicense, tableLayout, 100);
        tree.setLayout((Layout)tableLayout);
    }

    @Override
    protected Control createFilterButtons(Composite parent) {
        Composite buttonsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        buttonsGroup.setLayout((Layout)layout);
        GridData gd = new GridData(1, 1, false, false);
        buttonsGroup.setLayoutData((Object)gd);
        this.showAllButton = this.getToolkit().createButton(buttonsGroup, Messages.AvailableOfferingSection_showAllVersions, 32);
        this.showAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AvailableOfferingSection.this.handleShowAllPressed(e);
            }

            public void widgetSelected(SelectionEvent e) {
                AvailableOfferingSection.this.handleShowAllPressed(e);
            }
        });
        return buttonsGroup;
    }

    private void createInstalledOfferings() {
        this.installedOfferings = new InstalledOfferingsState(this.isInstallFlow);
    }

    private void checkIfFoundFixes(List newFixes, IProgressMonitor monitor) {
        Agent agent = AgentUI.getDefault().getAgent();
        AbstractJob[] selectedJobs = this.getSelectedJobs();
        if (selectedJobs == null || selectedJobs.length == 0) {
            return;
        }
        Set processedOfferings = this.wizardPage.getProcessedOfferings();
        monitor.beginTask("", selectedJobs.length);
        AbstractJob[] abstractJobArray = selectedJobs;
        int n = selectedJobs.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractJob selectedJob = abstractJobArray[n2];
            IOffering pOffering = selectedJob.getOffering();
            if (pOffering != null) {
                SubProgressMonitor smonitor = new SubProgressMonitor(monitor, 1, 4);
                for (IFix fix : agent.findFixes(true, pOffering, (IProgressMonitor)smonitor)) {
                    if (!processedOfferings.add(fix)) continue;
                    newFixes.add(fix);
                }
            }
            ++n2;
        }
        monitor.done();
    }

    private boolean isOtherVersion(IOffering offering1, IOffering offering2) {
        IIdentity id1 = offering1.getIdentity();
        Version version1 = offering1.getVersion();
        IIdentity id2 = offering2.getIdentity();
        Version version2 = offering2.getVersion();
        return id1.equals(id2) && !version1.equals((Object)version2);
    }

    private boolean isOtherVersionOrExtension(IOffering offering, IOffering[] selectedOfferings, List newUpdates) {
        if (this.isWizardMode) {
            if (selectedOfferings == null || selectedOfferings.length == 0) {
                return false;
            }
            if (Agent.isExtensionOffering((IOfferingOrFix)offering)) {
                return true;
            }
            IOffering[] iOfferingArray = selectedOfferings;
            int n = selectedOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering selectedOffering = iOfferingArray[n2];
                if (this.isOtherVersion(offering, selectedOffering)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (Agent.isExtensionOffering((IOfferingOrFix)offering)) {
            return true;
        }
        if (selectedOfferings != null) {
            IOffering[] iOfferingArray = selectedOfferings;
            int n = selectedOfferings.length;
            int n3 = 0;
            while (n3 < n) {
                IOffering selectedOffering = iOfferingArray[n3];
                if (this.isOtherVersion(offering, selectedOffering)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    private void addNewOfferings(List newOfferings, List newUpdates, IOffering[] selectedOfferings, IProgressMonitor monitor) {
        Agent agent = AgentUI.getDefault().getAgent();
        IRepositoryGroup repositories = agent.getRepositoryGroup();
        List offerings = UpdateOfferingUtils.getAllOfferingsAndTheirUpdates((boolean)true, (IRepository)repositories, (boolean)true, (IProgressMonitor)monitor);
        ArrayList<AbstractJob> newJobs = new ArrayList<AbstractJob>();
        List jobs = this.wizardPage.getJobs();
        Set processedOfferings = this.wizardPage.getProcessedOfferings();
        block0: for (IOffering offering : offerings) {
            if (SharedUIUtils.isHiddenAgentOffering((IOfferingOrFix)offering, (boolean)false) || !this.isOtherVersionOrExtension(offering, selectedOfferings, newUpdates) || !processedOfferings.add(offering)) continue;
            newOfferings.add(offering);
            AbstractJob newJob = this.wizardPage.createJob((IOfferingOrFix)offering);
            newJobs.add(newJob);
            jobs.add(newJob);
            if (selectedOfferings == null) continue;
            IOffering[] iOfferingArray = selectedOfferings;
            int n = selectedOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering selectedOffering = iOfferingArray[n2];
                if (selectedOffering.getIdentity().equals(offering.getIdentity()) && selectedOffering.compareVersion((IContent)offering) < 0) {
                    newUpdates.add(offering);
                    continue block0;
                }
                ++n2;
            }
        }
        this.resetSupportCurrentPlatform();
        this.buildVersionTree(newJobs);
    }

    private void resetSupportCurrentPlatform() {
        Collection packageNodes = this.packages.values();
        for (PackageNode pkgNode : packageNodes) {
            List<FixNode> versionNodes = pkgNode.getFixNodes();
            int i = 0;
            while (i < versionNodes.size()) {
                VersionNode vNode = (VersionNode)((Object)versionNodes.get(i));
                vNode.resetSupportCurrentPlatform();
                List fixNodes = vNode.getFixes();
                int j = 0;
                while (j < fixNodes.size()) {
                    FixNode fNode = (FixNode)fixNodes.get(j);
                    fNode.resetSupportCurrentPlatform();
                    ++j;
                }
                ++i;
            }
        }
    }

    private AbstractJob getSelectedAgentJob() {
        AbstractJob[] jobs = this.getSelectedJobs();
        if (AgentUtil.hasInstallAgentJob((AgentJob[])jobs)) {
            return this.getInstallAgentJob(jobs);
        }
        if (this.isWizardMode && AgentInstall.getInstance().isAgentInstallerRunning()) {
            InstallJob job = new InstallJob((IOfferingOrFix)Agent.getInstance().getAgentOffering());
            job.setProfile(Agent.getInstance().getAgentProfile());
            job.setSelected(true);
            return job;
        }
        return null;
    }

    private AbstractJob getInstallAgentJob(AbstractJob[] jobs) {
        if (jobs == null || jobs.length == 0) {
            return null;
        }
        AbstractJob[] abstractJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractJob job = abstractJobArray[n2];
            IOffering offering = job.getOffering();
            if (AgentUI.getDefault().getAgent().isAgentOffering((IOfferingOrFix)offering)) {
                return job;
            }
            ++n2;
        }
        return null;
    }

    private boolean installNewerVersionOfIM() {
        if (!this.installNewerIM[0]) {
            return false;
        }
        this.wizardPage.setSelection(this.wizardPage.getJobs().toArray());
        IWizardPage nextPage = this.wizardPage.getNextPage();
        this.wizardPage.getWizard().getContainer().showPage(nextPage);
        nextPage.setPreviousPage(null);
        this.wizardPage.getWizard().getContainer().updateButtons();
        return true;
    }

    private void searchForOtherVersionsExtensions() {
        final ArrayList newFixes = new ArrayList();
        final ArrayList newOfferings = new ArrayList();
        final ArrayList newUpdates = new ArrayList();
        boolean showAllChecked = this.showAllButton.getSelection();
        final Agent agent = AgentUI.getDefault().getAgent();
        RepositoryGroup tempGroup = new RepositoryGroup("searchForOtherVersionsExtensions");
        final IRepositoryGroup repositories = agent.getRepositoryGroup();
        ServiceRepositoryUtils.moveServiceRepositories((IRepositoryGroup)tempGroup, (IRepositoryGroup)repositories);
        final IStatus[] updateIMStatus = new IStatus[]{Status.OK_STATUS};
        final IStatus[] loadServiceRepStatus = new IStatus[]{Status.OK_STATUS};
        final Map[] repLocationMsgMap = new Map[]{new HashMap()};
        CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.getTreePart().getTreeViewer();
        final ISelection selection = viewer.getSelection();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("", 4);
                SubProgressMonitor smonitor = new SubProgressMonitor(monitor, 1, 4);
                try {
                    if (!AvailableOfferingSection.this.isWizardMode || !Agent.getInstance().searchForAgentUpdate()) {
                        updateIMStatus[0] = Statuses.OK.getMultiStatus();
                    } else {
                        boolean mandatoryUpdate = false;
                        if (AvailableOfferingSection.this.checkForAgentUpdate(updateIMStatus, mandatoryUpdate, (IProgressMonitor)smonitor)) {
                            return;
                        }
                    }
                }
                finally {
                    smonitor.done();
                }
                smonitor = new SubProgressMonitor(monitor, 1, 4);
                IOffering[] selectedOfferings = AvailableOfferingSection.this.getSelectedOfferings();
                ArrayList<IOffering> offeringsToSearchServiceRep = new ArrayList<IOffering>();
                if (!AvailableOfferingSection.this.isWizardMode && AvailableOfferingSection.this.installedOfferings != null && !AvailableOfferingSection.this.installedOfferings.isEmpty()) {
                    offeringsToSearchServiceRep = new ArrayList(AvailableOfferingSection.this.installedOfferings.getOfferings());
                }
                ArrayList<IOffering> selectedOfferingWithoutAgent = new ArrayList<IOffering>();
                if (selectedOfferings != null && selectedOfferings.length > 0) {
                    IOffering[] iOfferingArray = selectedOfferings;
                    int n = selectedOfferings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IOffering selectedOffering = iOfferingArray[n2];
                        IOffering offering = selectedOffering;
                        if (!agent.isAgentOffering((IOfferingOrFix)offering)) {
                            offeringsToSearchServiceRep.add(offering);
                            selectedOfferingWithoutAgent.add(offering);
                        }
                        ++n2;
                    }
                }
                if (selection != null && !selection.isEmpty() && selection instanceof StructuredSelection) {
                    StructuredSelection structuredSelection = (StructuredSelection)selection;
                    for (Object object : structuredSelection) {
                        IOffering selectedOffering;
                        if (object instanceof PackageNode) {
                            List versionNodeList = ((PackageNode)object).getVersionNodes();
                            int i = 0;
                            while (i < versionNodeList.size()) {
                                IOffering selectedOffering2 = ((VersionNode)versionNodeList.get(i)).getOffering();
                                if (selectedOffering2 != null && !offeringsToSearchServiceRep.contains(selectedOffering2) && !agent.isAgentOffering((IOfferingOrFix)selectedOffering2)) {
                                    offeringsToSearchServiceRep.add(selectedOffering2);
                                    if (!selectedOfferingWithoutAgent.contains(selectedOffering2)) {
                                        selectedOfferingWithoutAgent.add(selectedOffering2);
                                    }
                                }
                                ++i;
                            }
                            continue;
                        }
                        if (!(object instanceof VersionNode) || (selectedOffering = ((VersionNode)object).getOffering()) == null || offeringsToSearchServiceRep.contains(selectedOffering) || agent.isAgentOffering((IOfferingOrFix)selectedOffering)) continue;
                        offeringsToSearchServiceRep.add(selectedOffering);
                        if (selectedOfferingWithoutAgent.contains(selectedOffering)) continue;
                        selectedOfferingWithoutAgent.add(selectedOffering);
                    }
                }
                loadServiceRepStatus[0] = ServiceRepositoryUtils.loadServiceRepositoriesIfPrefIsSet((Map)repLocationMsgMap[0], (IRepositoryGroup)repositories, (IOffering[])offeringsToSearchServiceRep.toArray(new IOffering[offeringsToSearchServiceRep.size()]), (IProgressMonitor)smonitor);
                smonitor = new SubProgressMonitor(monitor, 1, 4);
                int size = selectedOfferingWithoutAgent.size();
                IOffering[] selectedOfferingsWithoutAgentArray = selectedOfferingWithoutAgent.toArray(new IOffering[size]);
                AvailableOfferingSection.this.addNewOfferings(newOfferings, newUpdates, selectedOfferingsWithoutAgentArray, (IProgressMonitor)smonitor);
                smonitor = new SubProgressMonitor(monitor, 1, 4);
                AvailableOfferingSection.this.checkIfFoundFixes(newFixes, (IProgressMonitor)smonitor);
                if (monitor.isCanceled()) {
                    ((AvailableOfferingSection)AvailableOfferingSection.this).searchForUpdateWasCanceled[0] = true;
                }
                monitor.done();
            }
        };
        try {
            ISelection viewerSelection;
            int rootNodesSize = this.packages.size();
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, runnable);
            if (StatusUtil.isErrorOrCancel((IStatus)updateIMStatus[0])) {
                return;
            }
            if (this.installNewerVersionOfIM()) {
                return;
            }
            if (rootNodesSize < this.packages.size()) {
                viewer.setInput((Object)this.getRootNodes());
                viewerSelection = viewer.getSelection();
                if (!viewerSelection.isEmpty()) {
                    this.wizardPage.refreshDetailPage();
                }
                viewer.expandAll();
                this.checkDefaultJobs();
                this.wizardPage.setSelection(this.getSelectedJobs());
            } else {
                viewer.refresh();
                viewerSelection = viewer.getSelection();
                if (!viewerSelection.isEmpty()) {
                    this.wizardPage.refreshDetailPage();
                }
                viewer.expandAll();
            }
            this.showFilterBoxIfNeeded((TreeViewer)viewer);
            String message = com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_noUpdateMessage;
            if (this.searchForUpdateWasCanceled[0]) {
                message = Messages.AvailableOfferingSection_noUpdateBeforeCancel;
            }
            int newOfferingCount = newOfferings.size();
            int newUpdateCount = newUpdates.size();
            int newFixCount = newFixes.size();
            if (newOfferingCount > 0 || newFixCount > 0) {
                String repStatusMessage;
                String offeringMessage = "";
                String fixMessage = "";
                if (newOfferingCount > 1) {
                    offeringMessage = !this.searchForUpdateWasCanceled[0] ? NLS.bind((String)Messages.AvailableOfferingSection_updateFoundMessage_new, (Object)String.valueOf(newOfferingCount)) : NLS.bind((String)Messages.AvailableOfferingSection_updateFoundBeforeCancel, (Object)String.valueOf(newOfferingCount));
                } else if (newOfferingCount == 1) {
                    offeringMessage = !this.searchForUpdateWasCanceled[0] ? NLS.bind((String)Messages.AvailableOfferingSection_oneUpdateFoundMsg, (Object)String.valueOf(newOfferingCount)) : NLS.bind((String)Messages.AvailableOfferingSection_oneUpdateFoundBeforeCancel, (Object)String.valueOf(newOfferingCount));
                }
                if (offeringMessage.length() > 0 && !showAllChecked) {
                    offeringMessage = String.valueOf(offeringMessage) + " " + Messages.AvailableOfferingSection_clickShowAllAction;
                }
                if (newFixCount > 1) {
                    fixMessage = !this.searchForUpdateWasCanceled[0] ? NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_fixesFound, (Object)String.valueOf(newFixCount)) : NLS.bind((String)Messages.AvailableOfferingSection_fixesFoundBeforeCancel, (Object)String.valueOf(newFixCount));
                } else if (newFixCount == 1) {
                    fixMessage = !this.searchForUpdateWasCanceled[0] ? NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_oneFixFound, (Object)String.valueOf(newFixCount)) : NLS.bind((String)Messages.AvailableOfferingSection_oneFixFoundBeforeCancel, (Object)String.valueOf(newFixCount));
                }
                if (fixMessage.length() > 0) {
                    fixMessage = String.valueOf(fixMessage) + " " + Messages.AvailableOfferingSection_fixesFoundAction;
                }
                if (offeringMessage.length() > 0) {
                    message = offeringMessage;
                    if (fixMessage.length() > 0) {
                        message = String.valueOf(message) + "\n\n";
                        message = String.valueOf(message) + fixMessage;
                    }
                } else {
                    message = fixMessage;
                }
                if (newUpdateCount > 0) {
                    this.reselectPackages();
                }
                if (this.uncheckJobsThatDontTolerateAgent()) {
                    this.wizardPage.setSelection(this.getSelectedJobs());
                }
                if ((repStatusMessage = CommonSharedUIUtils.constructRepositoryMessages((Map)repLocationMsgMap[0], (boolean)true)).length() > 0) {
                    message = String.valueOf(message) + "\n\n";
                    message = String.valueOf(message) + repStatusMessage;
                }
                MessageDialog.openInformation((Shell)viewer.getTree().getShell(), (String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_updateTitle_new, (String)message);
            } else if (loadServiceRepStatus[0].isOK()) {
                String repStatusMessage = CommonSharedUIUtils.constructRepositoryMessages((Map)repLocationMsgMap[0], (boolean)true);
                if (repStatusMessage.length() > 0) {
                    message = String.valueOf(message) + "\n\n";
                    message = String.valueOf(message) + repStatusMessage;
                }
                MessageDialog.openInformation((Shell)viewer.getTree().getShell(), (String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_updateTitle_new, (String)message);
            } else if (loadServiceRepStatus[0].isMultiStatus() && loadServiceRepStatus[0].getChildren() != null && loadServiceRepStatus[0].getChildren().length > 0) {
                IStatus[] children;
                message = String.valueOf(message) + "\n\n" + Messages.AvailableOfferingSection_noUpdateServiceRepMsg;
                String repStatusMessage = CommonSharedUIUtils.constructRepositoryMessages((Map)repLocationMsgMap[0], (boolean)true);
                if (repStatusMessage.length() > 0) {
                    message = String.valueOf(message) + "\n\n";
                    message = String.valueOf(message) + repStatusMessage;
                }
                CicMultiStatus displayStatus = Statuses.OK.getMultiStatus(message, new Object[0]);
                IStatus[] iStatusArray = children = loadServiceRepStatus[0].getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus element = iStatusArray[n2];
                    String msg = element.getMessage();
                    Status child = new Status(1, "com.ibm.cic.agent.ui", msg);
                    displayStatus.add((IStatus)child);
                    ++n2;
                }
                WrapDetailUIDErrorDialog dlg = new WrapDetailUIDErrorDialog(viewer.getTree().getShell(), com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_updateTitle_new, null, (IStatus)displayStatus, 1);
                dlg.open();
            } else {
                String repStatusMessage = CommonSharedUIUtils.constructRepositoryMessages((Map)repLocationMsgMap[0], (boolean)true);
                if (repStatusMessage.length() > 0) {
                    message = String.valueOf(message) + "\n\n";
                    message = String.valueOf(message) + repStatusMessage;
                }
                MessageDialog.openInformation((Shell)viewer.getTree().getShell(), (String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_updateTitle_new, (String)message);
            }
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
    }

    private void reselectPackages() {
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        block0: for (PackageNode nextPackage : this.packages.values()) {
            for (VersionNode versionNode : nextPackage.getVersionNodes()) {
                if (!versionNode.isSelected()) continue;
                if (versionNode.isRecommended()) continue block0;
                this.unselectJobs(nextPackage);
                this.elementChecked(viewer, nextPackage, true);
                continue block0;
            }
        }
        this.wizardPage.setSelection(this.getSelectedJobs());
    }

    private void unselectJobs(PackageNode packageNode) {
        List versionNodes = packageNode.getVersionNodes();
        if (versionNodes != null && !versionNodes.isEmpty()) {
            int i = 0;
            while (i < versionNodes.size()) {
                VersionNode versionNode = (VersionNode)versionNodes.get(i);
                versionNode.setSelected(false);
                ++i;
            }
        }
    }

    @Override
    protected void elementChecked(CheckboxTreeViewer viewer, Object element, boolean checked) {
        if (this.recommendedFilter.select((Viewer)viewer, null, element)) {
            if (element instanceof PackageNode) {
                this.packageChecked(viewer, element, checked);
            } else if (element instanceof VersionNode) {
                this.versionNodeChecked(viewer, element, checked);
            } else {
                super.elementChecked(viewer, element, checked);
            }
        }
        this.changeCheckForUpdateButtonStatus((TreeViewer)viewer);
    }

    private void changeCheckForUpdateButtonStatus(TreeViewer viewer) {
        ISelection selection = viewer.getSelection();
        if (this.isWizardMode) {
            this.getTreePart().setButtonEnabled(0, this.hasSelectedJob() || this.hasSelectedOfferings(selection));
        } else {
            this.getTreePart().setButtonEnabled(0, !this.installedOfferings.isEmpty() || this.hasSelectedJob() || this.hasSelectedOfferings(selection));
        }
    }

    private boolean hasSelectedOfferings(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            for (Object object : structuredSelection) {
                if (!(object instanceof VersionNode) && !(object instanceof PackageNode)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean uncheckAgentOffering(Object element, boolean checked) {
        if (checked) {
            return false;
        }
        if (element instanceof PackageNode) {
            return ((PackageNode)element).isAgentPackageNode();
        }
        if (element instanceof VersionNode) {
            return ((VersionNode)element).isAgentVersionNode();
        }
        return false;
    }

    private void packageChecked(CheckboxTreeViewer viewer, Object element, boolean checked) {
        Object[] children = this.getChildren(element);
        if (children.length > 0) {
            if (checked) {
                VersionNode selectedVersion = null;
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element2 = objectArray[n2];
                    VersionNode child = (VersionNode)element2;
                    if (child.isRecommended()) {
                        selectedVersion = child;
                        break;
                    }
                    ++n2;
                }
                if (selectedVersion != null) {
                    this.elementChecked(viewer, selectedVersion, checked);
                }
                this.updateItem(viewer, element, checked);
            } else {
                super.elementChecked(viewer, element, checked);
            }
        }
    }

    private void versionNodeChecked(CheckboxTreeViewer viewer, Object element, boolean checked) {
        super.elementChecked(viewer, element, checked);
    }

    @Override
    protected ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.getCheckboxTreeViewer().getLabelProvider();
    }

    private Object[] getRootNodes() {
        return this.packages.values().toArray();
    }

    protected AbstractJob[] getSelectedJobs() {
        SelectedLicensesState selectedLicensesState = new SelectedLicensesState(this.installedOfferings, this.wizardPage.getJobs());
        this.wizardPage.setOfferingOrFixLicenseTypeMap(selectedLicensesState.getOfferingOrFixLicenseTypeMap());
        return selectedLicensesState.getSelectedJobs();
    }

    private boolean hasSelectedJob() {
        for (AbstractJob job : this.wizardPage.getJobs()) {
            if (!job.isSelected()) continue;
            return true;
        }
        return false;
    }

    private void searchOtherVersions() {
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    int scale = 1000;
                    monitor.beginTask("", 10 * scale);
                    ArrayList<IOffering> currentDisplayedOfferings = new ArrayList<IOffering>();
                    List jobs = AvailableOfferingSection.this.wizardPage.getJobs();
                    int i = 0;
                    while (i < jobs.size()) {
                        AbstractJob job = (AbstractJob)jobs.get(i);
                        IOffering offering = job.getOffering();
                        if (offering != null) {
                            currentDisplayedOfferings.add(offering);
                        }
                        ++i;
                    }
                    if (currentDisplayedOfferings.isEmpty()) {
                        monitor.done();
                        return;
                    }
                    monitor.worked(2 * scale);
                    SubProgressMonitor smonitor = new SubProgressMonitor(monitor, 8 * scale, 4);
                    Agent agent = AgentUI.getDefault().getAgent();
                    IRepositoryGroup repositories = agent.getRepositoryGroup();
                    List offerings = UpdateOfferingUtils.getAllOfferingsAndTheirUpdates((IRepository)repositories, (boolean)true, (IProgressMonitor)smonitor);
                    ArrayList<AbstractJob> newJobs = new ArrayList<AbstractJob>();
                    Set processedOfferings = AvailableOfferingSection.this.wizardPage.getProcessedOfferings();
                    for (IOffering offering : offerings) {
                        if (SharedUIUtils.isHiddenAgentOffering((IOfferingOrFix)offering, (boolean)false) || !AvailableOfferingSection.this.isOtherVersionOfDisplayedOfferings(offering, currentDisplayedOfferings) || !processedOfferings.add(offering)) continue;
                        AbstractJob newJob = AvailableOfferingSection.this.wizardPage.createJob((IOfferingOrFix)offering);
                        newJobs.add(newJob);
                        jobs.add(newJob);
                    }
                    AvailableOfferingSection.this.buildVersionTree(newJobs);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
    }

    private boolean isOtherVersionOfDisplayedOfferings(IOffering offering, List currentDisplayedOfferings) {
        int i = 0;
        while (i < currentDisplayedOfferings.size()) {
            if (this.isOtherVersion(offering, (IOffering)currentDisplayedOfferings.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void handleShowAllPressed(SelectionEvent e) {
        this.showAll = ((Button)e.getSource()).getSelection();
        if (this.showAll && this.isWizardMode && this.firstTimeShowAll) {
            this.firstTimeShowAll = false;
            this.searchOtherVersions();
        }
        CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.getTreePart().getTreeViewer();
        viewer.refresh();
        if (this.showAll) {
            Object[] packageNodes;
            Object[] objectArray = packageNodes = this.getRootNodes();
            int n = packageNodes.length;
            int n2 = 0;
            while (n2 < n) {
                Object packageNode = objectArray[n2];
                PackageNode pkgNode = (PackageNode)packageNode;
                List versionNodes = pkgNode.getVersionNodes();
                int j = 0;
                while (j < versionNodes.size()) {
                    VersionNode vNode = (VersionNode)versionNodes.get(j);
                    if (vNode.isSelected()) {
                        this.checkItem(viewer, vNode, true, false);
                        this.updateParents(viewer, vNode.getParent(), true);
                    }
                    ++j;
                }
                ++n2;
            }
        }
        viewer.expandAll();
        this.showFilterBoxIfNeeded((TreeViewer)viewer);
        this.setTopItemVisible((TreeViewer)viewer);
        this.wizardPage.refreshDetailPage();
    }

    private boolean isOtherVersionInstalled(VersionNode versionNode) {
        if (versionNode.getParent().isInstalled()) {
            return true;
        }
        IIdentity id = versionNode.getParent().getIdentity();
        return this.installedOfferings.isInstalled(id);
    }

    @Override
    protected void onCheckStateChange(CheckStateChangedEvent event) {
        Object selectedItem;
        StructuredSelection strutSelection;
        if (this.isInstallFlow) {
            if (this.uncheckAgentOffering(event.getElement(), event.getChecked())) {
                CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.getTreePart().getTreeViewer();
                viewer.setChecked(event.getElement(), true);
                return;
            }
            if (this.checkIfGrayedItemWasChecked(event)) {
                CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.getTreePart().getTreeViewer();
                viewer.setChecked(event.getElement(), false);
                return;
            }
            if (event.getChecked()) {
                boolean checked = this.checkJobsToleranceForAgentOnCheckStateChanged(event);
                if (checked) {
                    checked = this.checkInstalledOfferingsOnCheckStateChange(event);
                }
                if (!checked) {
                    event = new CheckStateChangedEvent(event.getCheckable(), event.getElement(), checked);
                }
            }
        }
        super.onCheckStateChange(event);
        boolean resetSelection = true;
        ISelection currentSelection = this.getCheckboxTreeViewer().getSelection();
        if (currentSelection != null && currentSelection instanceof StructuredSelection && (strutSelection = (StructuredSelection)currentSelection).size() == 1 && (selectedItem = strutSelection.getFirstElement()).equals(event.getElement())) {
            resetSelection = false;
        }
        if (resetSelection) {
            this.getCheckboxTreeViewer().setSelection((ISelection)new StructuredSelection(event.getElement()));
        }
        Object[] selectedJobs = this.getSelectedJobs();
        this.wizardPage.setSelection(selectedJobs);
        if (selectedJobs == null || selectedJobs.length == 0) {
            this.filterBoxPart.setSelectionHint(null);
        } else if (selectedJobs.length == 1) {
            this.filterBoxPart.setSelectionHint(Messages.AvailableOfferingSection_pkgSelected_single);
        } else {
            this.filterBoxPart.setSelectionHint(NLS.bind((String)Messages.AvailableOfferingSection_pkgSelected_multi, (Object)selectedJobs.length));
        }
    }

    private boolean checkIfGrayedItemWasChecked(CheckStateChangedEvent event) {
        if (event.getChecked()) {
            Object element = event.getElement();
            if (element instanceof PackageNode) {
                boolean allGrayed = true;
                List versions = ((PackageNode)element).getChildren();
                int i = 0;
                while (i < versions.size() && allGrayed) {
                    VersionNode versionNode = (VersionNode)versions.get(i);
                    if (versionNode.canBeInstalled()) {
                        allGrayed = false;
                    }
                    ++i;
                }
                return allGrayed;
            }
            if (element instanceof VersionNode) {
                VersionNode versionNode = (VersionNode)element;
                return !versionNode.canBeInstalled();
            }
        }
        return false;
    }

    private boolean checkJobsToleranceForAgentOnCheckStateChanged(CheckStateChangedEvent event) {
        IStatus sta;
        AgentJob job;
        IStatus status = Status.OK_STATUS;
        Object element = event.getElement();
        VersionNode checkedNode = null;
        if (element instanceof VersionNode) {
            VersionNode versionNode = (VersionNode)element;
            status = versionNode.getToleranceStatus();
            checkedNode = versionNode;
        } else if (element instanceof PackageNode) {
            PackageNode packageNode = (PackageNode)element;
            VersionNode recommendedVersion = packageNode.getRecommendedVersion();
            if (recommendedVersion != null && recommendedVersion.canBeInstalled()) {
                status = recommendedVersion.getToleranceStatus();
            }
            checkedNode = recommendedVersion;
        }
        if (checkedNode != null && (job = (AgentJob)checkedNode.getAdapter(AbstractJob.class)) != null && StatusUtil.isErrorOrCancel((IStatus)(sta = AgentUIUtils.runPrecheckBundles(job)))) {
            return false;
        }
        if (!status.isOK()) {
            this.wizardPage.getDetailPage().getObjectDescription(element);
            DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AvailableOfferingSection.this.checkForAgentUpdate();
                }
            });
            return false;
        }
        return true;
    }

    private String constructedPkgInstalledMsg(String pkgInstalledMsg) {
        String return_result = String.valueOf(pkgInstalledMsg) + "\n\n";
        return_result = this.isWizardMode ? String.valueOf(return_result) + Messages.AvailableOfferingPage_pkgInstalled_whatToDo_wizardMode : String.valueOf(return_result) + Messages.AvailableOfferingPage_pkgInstalled_whatToDo;
        return return_result;
    }

    private String constructSingletonPkgInstalledMsg(String pkgInstalledMsg) {
        String return_result = String.valueOf(pkgInstalledMsg) + "\n\n";
        return_result = this.isWizardMode ? String.valueOf(return_result) + Messages.AvailableOfferingPage_singletonPkg_whatToDo_wzdMode : String.valueOf(return_result) + Messages.AvailableOfferingPage_singletonPkg_whatToDo;
        return return_result;
    }

    private boolean checkInstalledOfferingsOnCheckStateChange(CheckStateChangedEvent event) {
        PackageNode packageNode;
        boolean checked = true;
        Object element = event.getElement();
        if (element instanceof VersionNode) {
            VersionNode versionNode = (VersionNode)element;
            if (versionNode.isInstalled()) {
                IOffering offering = versionNode.getOffering();
                ArrayList<IOffering> installedOfferingList = new ArrayList<IOffering>();
                installedOfferingList.add(offering);
                if (!this.isSingletonOffering(offering)) {
                    String message;
                    boolean continueInstall;
                    if (OfferingProperty.showHasBeenInstalledDialog((IOffering)offering) && !(continueInstall = this.confirmInstalledOfferings(installedOfferingList, message = this.constructedPkgInstalledMsg(Messages.AvailableOfferingPage_packageInstalled)))) {
                        checked = false;
                    }
                } else {
                    String message = NLS.bind((String)Messages.AvailableOfferingPage_installedPkg_singleton, (Object)offering.getName());
                    String constructedMsg = this.constructSingletonPkgInstalledMsg(message);
                    this.confirmInstalledSingletonOfferings(installedOfferingList, constructedMsg);
                    checked = false;
                }
            } else if (this.isOtherVersionInstalled(versionNode)) {
                IOffering offering = versionNode.getOffering();
                List installedOfferingList = this.installedOfferings.getInstalledList(offering.getIdentity());
                if (!this.isSingletonOffering(offering) && !this.containSingletonOffering(installedOfferingList)) {
                    String message;
                    boolean continueInstall;
                    if (OfferingProperty.showHasBeenInstalledDialog((IOffering)offering) && !(continueInstall = this.confirmInstalledOfferings(installedOfferingList, message = this.constructedPkgInstalledMsg(Messages.AvailableOfferingPage_anotherVersionInstalled)))) {
                        checked = false;
                    }
                } else {
                    String message = NLS.bind((String)Messages.AvailableOfferingPage_anotherPkg_singleton, (Object)offering.getName());
                    String constructedMsg = this.constructSingletonPkgInstalledMsg(message);
                    this.confirmInstalledSingletonOfferings(installedOfferingList, constructedMsg);
                    checked = false;
                }
            }
        } else if (element instanceof PackageNode && ((packageNode = (PackageNode)element).isInstalled() || this.installedOfferings.isInstalled(packageNode.getIdentity()))) {
            IOffering offering = packageNode.getRecommendedVersion().getOffering();
            List installedOfferingList = this.installedOfferings.getInstalledList(packageNode.getIdentity());
            if (!this.isSingletonOffering(offering) && !this.containSingletonOffering(installedOfferingList)) {
                String message;
                boolean continueInstall;
                if (OfferingProperty.showHasBeenInstalledDialog((IOffering)offering) && !(continueInstall = this.confirmInstalledOfferings(installedOfferingList, message = this.constructedPkgInstalledMsg(Messages.AvailableOfferingPage_packageInstalled)))) {
                    checked = false;
                }
            } else {
                String message = NLS.bind((String)Messages.AvailableOfferingPage_installedPkg_singleton, (Object)offering.getName());
                String constructedMsg = this.constructSingletonPkgInstalledMsg(message);
                this.confirmInstalledSingletonOfferings(installedOfferingList, constructedMsg);
                checked = false;
            }
        }
        return checked;
    }

    private void uncheckSiblings(CheckboxTreeViewer viewer, Object element) {
        Object parent = this.getContentProvider().getParent(element);
        if (parent != null) {
            Object[] siblings;
            Object[] objectArray = siblings = this.getContentProvider().getChildren(parent);
            int n = siblings.length;
            int n2 = 0;
            while (n2 < n) {
                Object sibling = objectArray[n2];
                if (sibling != element) {
                    this.elementChecked(viewer, sibling, false);
                    ((VersionNode)sibling).setSelected(false);
                }
                ++n2;
            }
        }
    }

    @Override
    protected void updateItem(CheckboxTreeViewer viewer, Object element, boolean preferredState) {
        if (element instanceof PackageNode) {
            Object[] children = this.getChildren(element);
            boolean containsSelected = false;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                boolean checked = viewer.getChecked(child);
                containsSelected |= checked;
                ++n2;
            }
            this.checkItem(viewer, element, containsSelected, false);
        } else {
            super.updateItem(viewer, element, preferredState);
        }
    }

    IOffering[] getSelectedOfferings() {
        ArrayList<IOffering> offerings = new ArrayList<IOffering>();
        AbstractJob[] selections = this.getSelectedJobs();
        if (selections != null) {
            AbstractJob[] abstractJobArray = selections;
            int n = selections.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractJob selection = abstractJobArray[n2];
                AbstractJob job = selection;
                IOffering offering = job.getOffering();
                if (offering != null) {
                    offerings.add(offering);
                }
                ++n2;
            }
        }
        return offerings.toArray(new IOffering[offerings.size()]);
    }

    private String getLicenseTypeLabel(IOffering offering, boolean isInstalled, boolean isSelected, List jobs) {
        IOffering[] pekOfferings;
        if (!isSelected && isInstalled) {
            return LicenseUtils.getRuntimeLicenseKinds((IOffering)offering);
        }
        LinkedList<IOffering> offeringsPool = new LinkedList<IOffering>();
        for (AbstractJob job : jobs) {
            IOffering joffering = job.getOffering();
            if (joffering == null || !LicenseUtils.isPEKOffering((IOffering)joffering)) continue;
            offeringsPool.add(joffering);
        }
        if (offeringsPool.size() > 0 && (pekOfferings = AgentUtil.getApplicablePekOfferings((IOffering)offering, offeringsPool)).length != 0) {
            return LicenseUtils.getLicenseKinds((IOffering[])pekOfferings, (boolean)true);
        }
        if (isInstalled) {
            return LicenseUtils.getRuntimeLicenseKinds((IOffering)offering);
        }
        return LicenseUtils.getLicenseKinds((IOffering)offering, (boolean)true);
    }

    public boolean isCheckForUpdateButtonWasClicked() {
        return this.checkForUpdateButtonWasClicked;
    }

    public void setCheckForUpdateButtonWasClicked(boolean checkForUpdateButtonWasClicked) {
        this.checkForUpdateButtonWasClicked = checkForUpdateButtonWasClicked;
    }

    public boolean isShowAllChecked() {
        return this.showAll;
    }

    private void showFilterBoxIfNeeded(TreeViewer viewer) {
        ScrollBar vScrollbar = viewer.getTree().getVerticalBar();
        if (vScrollbar != null && vScrollbar.isVisible()) {
            this.filterBoxPart.showFilterBox();
        }
    }

    class JobLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private final Color disabledColor;
        private final AgentUILabelProvider agentLabelProvider;

        public JobLabelProvider(Display display) {
            this.disabledColor = CommonUIUtils.createDisabledColor((Display)display);
            this.agentLabelProvider = AgentUI.getDefault().getLabelProvider();
            this.agentLabelProvider.connect((Object)this);
        }

        public void dispose() {
            this.agentLabelProvider.disconnect((Object)this);
            super.dispose();
            this.disabledColor.dispose();
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            block13: {
                block14: {
                    if (columnIndex == 0) {
                        return this.getText(element);
                    }
                    if (!AvailableOfferingSection.this.isInstallFlow) break block13;
                    if (!(element instanceof VersionNode)) break block14;
                    VersionNode versionNode = (VersionNode)element;
                    IOffering offering = versionNode.getOffering();
                    switch (columnIndex) {
                        case 1: {
                            if (versionNode.isUnavailable()) {
                                return Messages.AvailableOfferingSection_notEntitled;
                            }
                            if (versionNode.isInstalled()) {
                                return Messages.AvailableOfferingSection_isInstalled;
                            }
                            if (versionNode.isSelected()) {
                                return Messages.AvailableOfferingSection_willBeInstalled;
                            }
                            break block13;
                        }
                        case 2: {
                            return offering.getProperties().getProperty("vendor.name", "");
                        }
                        case 3: {
                            if (versionNode.isAgentVersionNode()) {
                                return Messages.AvailableOfferingPage_agentLicensenType;
                            }
                            if (!versionNode.isUnavailable()) {
                                return AvailableOfferingSection.this.getLicenseTypeLabel(offering, versionNode.isInstalled(), versionNode.isSelected(), AvailableOfferingSection.this.wizardPage.getJobs());
                            }
                            break block13;
                        }
                    }
                    break block13;
                }
                if (element instanceof PackageNode) {
                    PackageNode pkgNode = (PackageNode)element;
                    if (columnIndex == 1 && pkgNode.isInstalled()) {
                        return Messages.AvailableOfferingSection_isInstalled;
                    }
                }
            }
            return "";
        }

        public Color getForeground(Object element, int columnIndex) {
            if (!AvailableOfferingSection.this.isInstallFlow) {
                return null;
            }
            VersionNode versionNode = null;
            if (element instanceof PackageNode) {
                PackageNode pkgNode = (PackageNode)element;
                if (pkgNode.isAgentPackageNode()) {
                    return this.disabledColor;
                }
                if (AvailableOfferingSection.this.installedOfferings.isInstalled(pkgNode.getIdentity())) {
                    VersionNode version = pkgNode.getRecommendedVersion();
                    IOffering offering = version.getOffering();
                    IOffering installedOffering = AvailableOfferingSection.this.installedOfferings.getInstalled(pkgNode.getIdentity());
                    if (offering != null && installedOffering != null && (AvailableOfferingSection.this.isSingletonOffering(offering) || AvailableOfferingSection.this.isSingletonOffering(installedOffering))) {
                        return this.disabledColor;
                    }
                }
                boolean returnDisabled = true;
                Iterator I = pkgNode.getVersionNodes().iterator();
                while (I.hasNext() && returnDisabled) {
                    VersionNode ver = (VersionNode)I.next();
                    if (!ver.canBeInstalled()) continue;
                    returnDisabled = false;
                }
                if (returnDisabled) {
                    return this.disabledColor;
                }
            } else if (element instanceof VersionNode) {
                IOffering installedOffering;
                versionNode = (VersionNode)element;
                if (versionNode.isAgentVersionNode()) {
                    return this.disabledColor;
                }
                IOffering offering = versionNode.getOffering();
                if (versionNode.isUnavailable()) {
                    return this.disabledColor;
                }
                if (AvailableOfferingSection.this.installedOfferings.isInstalled(offering.getIdentity()) && (installedOffering = AvailableOfferingSection.this.installedOfferings.getInstalled(offering.getIdentity())) != null && (AvailableOfferingSection.this.isSingletonOffering(offering) || AvailableOfferingSection.this.isSingletonOffering(installedOffering))) {
                    return this.disabledColor;
                }
                if (!versionNode.canBeInstalled()) {
                    return this.disabledColor;
                }
            } else if (element instanceof FixNode) {
                FixNode fixNode = (FixNode)element;
                Object parent = fixNode.getParent();
                if (parent instanceof VersionNode) {
                    IOffering installedOffering;
                    IOffering offering = ((VersionNode)parent).getOffering();
                    if (((VersionNode)parent).isUnavailable()) {
                        return this.disabledColor;
                    }
                    if (AvailableOfferingSection.this.installedOfferings.isInstalled(offering.getIdentity()) && (installedOffering = AvailableOfferingSection.this.installedOfferings.getInstalled(offering.getIdentity())) != null && (AvailableOfferingSection.this.isSingletonOffering(offering) || AvailableOfferingSection.this.isSingletonOffering(installedOffering))) {
                        return this.disabledColor;
                    }
                }
                if (!fixNode.canBeInstalled()) {
                    return this.disabledColor;
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof PackageNode) {
                IOffering offering = ((PackageNode)element).getOffering();
                return this.agentLabelProvider.getOfferingImage(offering, false);
            }
            if (element instanceof VersionNode) {
                IOffering offering = ((VersionNode)element).getOffering();
                return this.agentLabelProvider.getOfferingImage(offering, true);
            }
            if (element instanceof FixNode) {
                return this.agentLabelProvider.get(CommonImages.DESC_FIX_OBJ);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof FixNode) {
                IFix fix = ((FixNode)element).getJob().getFix();
                String name = fix.getName();
                String version = AgentUIUtils.getDisplayableVersion((IOfferingOrFix)fix);
                return String.valueOf(name) + " " + version;
            }
            if (element instanceof VersionNode) {
                String version = AgentUIUtils.getDisplayableVersion((IOfferingOrFix)((VersionNode)element).getJob().getOffering());
                return NLS.bind((String)Messages.AvailableOfferingSection_version, (Object)version);
            }
            if (element instanceof PackageNode) {
                VersionNode node = (VersionNode)((PackageNode)element).getVersionNodes().get(0);
                return node.getJob().getOffering().getName();
            }
            return super.getText(element);
        }
    }

    private static class NewAgentFilter
    extends ViewerFilter {
        private NewAgentFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            VersionNode node;
            if (element instanceof VersionNode && (node = (VersionNode)element).isAgentVersionNode()) {
                return node.isRecommended();
            }
            return true;
        }
    }

    private static class OfferingSorter
    extends ViewerSorter {
        private OfferingSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof VersionNode && e2 instanceof VersionNode) {
                return ((VersionNode)e1).getOffering().compareVersion((IContent)((VersionNode)e2).getOffering());
            }
            if (e1 instanceof PackageNode && e2 instanceof PackageNode) {
                PackageNode node1 = (PackageNode)e1;
                if (node1.isAgentPackageNode()) {
                    return -1;
                }
                PackageNode node2 = (PackageNode)e2;
                if (node2.isAgentPackageNode()) {
                    return 1;
                }
            }
            return super.compare(viewer, e1, e2);
        }

        public int category(Object element) {
            if (element instanceof VersionNode) {
                return 1;
            }
            if (element instanceof PackageNode) {
                return 2;
            }
            return super.category(element);
        }

        public void sort(Viewer viewer, Object[] elements) {
            AgentUIUtils.sortByNameAndVersion(viewer, this, elements);
        }
    }

    private static class PekFilter
    extends ViewerFilter {
        private PekFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof PackageNode) {
                PackageNode node = (PackageNode)element;
                VersionNode vnode = (VersionNode)node.getVersionNodes().get(0);
                return !vnode.isPekNode();
            }
            if (element instanceof VersionNode) {
                VersionNode node = (VersionNode)element;
                return !node.isPekNode();
            }
            return true;
        }
    }

    private class RecommendedFilter
    extends ViewerFilter {
        private RecommendedFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (AvailableOfferingSection.this.showAll) {
                return true;
            }
            if (element instanceof VersionNode) {
                VersionNode node = (VersionNode)element;
                return node.isRecommended();
            }
            return true;
        }
    }
}

