/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SpaceInfoUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.InstallAgentUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.MaxInstallSizeInfo;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class AgentInstallLocationPage
extends AbstractAgentUIWizardPage {
    public static final CustomMessageWizardPage.ErrorId AGENT_INSTALL_LOCATION_ERROR = new CustomMessageWizardPage.ErrorId();
    public static final CustomMessageWizardPage.WarningId AGENT_INSTALL_LOCATION_WARNING = new CustomMessageWizardPage.WarningId();
    private Button agentLocationButton;
    private Text agentLocationText;
    private Table diskspaceTable;
    private IOffering agentOffering;
    private Profile agentProfile;
    private MaxInstallSizeInfo installAgentJobSizeInfo;

    public AgentInstallLocationPage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(toolkit, com.ibm.cic.agent.internal.ui.licenses.Messages.InstallLocationPage_title, Messages.AgentInstallLocationPage_desc, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.AgentInstallLocationPage");
    }

    @Override
    public void createControl(Composite parent) {
        this.agentProfile = this.createAgentProfile(this.getSelectedAgentJobs());
        Profile.setLicenseProfileInstallLocation((Profile)this.agentProfile);
        this.setSelection(this.agentProfile);
        this.getInstallAgentSizeInfo();
        Composite detailsComposite = this.toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginTop = 15;
        detailsComposite.setLayout((Layout)layout);
        detailsComposite.setLayoutData((Object)new GridData(768));
        this.createWarningArea(detailsComposite);
        this.createInstallLocationArea(detailsComposite);
        this.createDiskspaceSection(detailsComposite);
        this.setControl((Control)detailsComposite);
    }

    private void createWarningArea(Composite parent) {
        Composite warningComposite = this.toolkit.createComposite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        warningComposite.setLayout((Layout)layout);
        warningComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label warningIcon = this.toolkit.createLabel(warningComposite, "", 0);
        warningIcon.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        warningIcon.setImage(DisplayKeeper.INSTANCE.getDisplay().getSystemImage(2));
        Label warningMessage = this.toolkit.createLabel(warningComposite, Messages.AgentInstallLocationPage_warningMsg, 64);
        warningMessage.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.toolkit.createLabel(parent, "");
    }

    private void createInstallLocationArea(final Composite parent) {
        Composite locationComposite = this.toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        locationComposite.setLayout((Layout)layout);
        locationComposite.setLayoutData((Object)new GridData(768));
        Label label = this.toolkit.createLabel(locationComposite, Messages.AgentInstallLocationPage_locationLabel);
        label.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        String initialLocation = "";
        if (this.agentProfile != null) {
            initialLocation = this.agentProfile.getInstallLocation();
        }
        this.agentLocationText = this.toolkit.createText(locationComposite, TextProcessor.process((String)initialLocation), 2048);
        this.agentLocationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.agentLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String directory = ((Text)e.widget).getText();
                String deprocessedDir = TextProcessor.deprocess((String)directory.trim());
                AgentInstallLocationPage.this.handleAgentLocationChange(deprocessedDir);
            }
        });
        this.agentLocationButton = this.toolkit.createButton(locationComposite, Messages.AgentInstallLocationPage_browseButton, 8);
        this.agentLocationButton.setEnabled(true);
        this.agentLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String directory = UiServices.getInstance().getDirectoryDialog(parent.getShell()).title(Messages.CommonLocationPage_commonDialogTitle).message(Messages.AgentInstallLocationDlg_msg).filterPath(TextProcessor.deprocess((String)AgentInstallLocationPage.this.agentLocationText.getText().trim())).run();
                if (directory != null) {
                    String trimedDirectory = directory.trim();
                    String displayDirectory = TextProcessor.process((String)trimedDirectory);
                    AgentInstallLocationPage.this.agentLocationText.setText(displayDirectory);
                }
            }
        });
    }

    protected void createDiskspaceSection(Composite container) {
        new Label(container, 0);
        Section spaceSection = this.toolkit.createSection(container, 512);
        spaceSection.setText(Messages.InstallLocationDetailsPage_diskspaceInfo);
        Composite spaceComposite = this.toolkit.createComposite((Composite)spaceSection);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        spaceComposite.setLayout((Layout)layout);
        spaceSection.setClient((Control)spaceComposite);
        spaceSection.setLayoutData((Object)new GridData(4, 1, true, false));
        int originalBorderStyle = this.toolkit.getBorderStyle();
        this.toolkit.setBorderStyle(0);
        int spaceTableStyle = 32772;
        this.diskspaceTable = this.toolkit.createTable(spaceComposite, spaceTableStyle);
        GridData data = new GridData(4, 1, false, false);
        data.horizontalSpan = 2;
        data.heightHint = this.diskspaceTable.getItemHeight() * 2;
        this.diskspaceTable.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 80, false));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(7, 150, false));
        this.diskspaceTable.setLayout((Layout)tableLayout);
        new TableColumn(this.diskspaceTable, 16384, 0);
        new TableColumn(this.diskspaceTable, 131072, 1);
        this.diskspaceTable.pack();
        this.toolkit.setBorderStyle(originalBorderStyle);
    }

    Profile createAgentProfile(List jobs) {
        if (jobs == null || jobs.size() == 0) {
            return null;
        }
        Agent agent = AgentUI.getDefault().getAgent();
        AbstractJob job = (AbstractJob)jobs.get(0);
        this.agentOffering = job.getOffering();
        boolean hasAgentInstalled = InstallAgentUtils.hasAgentInstalled();
        Profile profile = agent.getAgentProfile();
        if (profile == null) {
            profile = AgentUtil.makeNewIMProfileForJob((AbstractJob)job);
        } else if (!hasAgentInstalled) {
            agent.deleteProfile(profile);
            profile.setShadow(true);
        }
        return profile;
    }

    void setSelection(Profile profile) {
        List profilesList = this.getAgentProfileList();
        profilesList.clear();
        Map profileLocaleLangs = this.getProfileLocalLanguagesMap();
        profileLocaleLangs.clear();
        if (profile != null) {
            profilesList.add(profile);
            Set supportedLangSet = OfferingProperty.getSupportedLocales((IOffering)this.agentOffering);
            String supportedLangString = ProfileLanguageUtils.convertCodeSetToString((Set)supportedLangSet);
            String currentLocaleLangs = profile.getData("cic.selector.nl");
            if (currentLocaleLangs == null || currentLocaleLangs.length() == 0) {
                profileLocaleLangs.put(profile, supportedLangString);
            } else {
                profileLocaleLangs.put(profile, currentLocaleLangs);
            }
            this.updateJobsProfile(profile);
            this.addAgentFeaturesToJob();
        }
    }

    private void updateJobsProfile(Profile profile) {
        int length = Integer.MAX_VALUE;
        for (AbstractJob job : this.getSelectedAgentJobs()) {
            job.setProfile(profile);
            int pathLength = PlatformUtils.getMaxInstallLocationLengthForOffering((IOffering)job.getOffering());
            if (pathLength >= length) continue;
            length = pathLength;
        }
        profile.setMaxInstallLocationLength(length);
    }

    private void addAgentFeaturesToJob() {
        List features = this.agentOffering.getFeatureGroup().getFeatures();
        List jobs = this.getSelectedAgentJobs();
        if (jobs != null && !jobs.isEmpty()) {
            InstallJob job = (InstallJob)jobs.get(0);
            job.setFeatures((Collection)features);
        }
    }

    private void getInstallAgentSizeInfo() {
        if (this.installAgentJobSizeInfo == null && this.agentProfile != null && !InstallAgentUtils.hasAgentInstalled()) {
            List selectedJobs = this.getSelectedAgentJobs();
            AbstractJob[] jobs = selectedJobs.toArray(new AbstractJob[selectedJobs.size()]);
            IStatus status = this.validateCurrentAgentDirectory();
            if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
                this.installAgentJobSizeInfo = AgentUI.getDefault().getAgent().getSizeInfo((AgentJob[])jobs, (IProgressMonitor)new NullProgressMonitor());
            } else {
                String originalInstallLocation = this.agentProfile.getInstallLocation();
                boolean success = false;
                int maxAttemp = 100;
                int i = 0;
                while (i < maxAttemp && !success) {
                    String newLocation = String.valueOf(originalInstallLocation) + i;
                    this.setAgentInstallLocation(newLocation);
                    IStatus validateStatus = this.agentProfile.validateInstallLocation(false);
                    if (!StatusUtil.isErrorOrCancel((IStatus)validateStatus)) {
                        success = true;
                        this.installAgentJobSizeInfo = AgentUI.getDefault().getAgent().getSizeInfo((AgentJob[])jobs, (IProgressMonitor)new NullProgressMonitor());
                    }
                    ++i;
                }
                this.setAgentInstallLocation(originalInstallLocation);
            }
        }
    }

    private void checkInitialAgentLocation(String location) {
        if (this.isWizardReady()) {
            IStatus status = this.validateCurrentAgentDirectory();
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                this.setErrorStateWithStatus(AGENT_INSTALL_LOCATION_ERROR, status);
                this.setWarningState(AGENT_INSTALL_LOCATION_WARNING, null);
                this.setPageComplete(false);
            } else if (status.getSeverity() == 2) {
                this.setErrorStateWithStatus(AGENT_INSTALL_LOCATION_ERROR, null);
                IStatus[] children = status.getChildren();
                if (children != null && children.length == 1) {
                    this.setWarningStateWithStatus(AGENT_INSTALL_LOCATION_WARNING, children[0]);
                } else {
                    this.setWarningStateWithStatus(AGENT_INSTALL_LOCATION_WARNING, status);
                }
                this.setPageComplete(true);
            } else {
                this.setErrorStateWithStatus(AGENT_INSTALL_LOCATION_ERROR, null);
                this.setWarningState(AGENT_INSTALL_LOCATION_WARNING, null);
                this.setPageComplete(true);
            }
        }
    }

    void handleAgentLocationChange(String directory) {
        CicMultiStatus status = Statuses.ST.createMultiStatus(com.ibm.cic.common.core.utils.Messages.MultipleWarnings, new Object[0]);
        IStatus setInstallLocationStatus = this.setAgentInstallLocation(directory);
        if (StatusUtil.isErrorOrCancel((IStatus)setInstallLocationStatus)) {
            this.setErrorStateWithStatus(AGENT_INSTALL_LOCATION_ERROR, setInstallLocationStatus);
            this.setWarningState(AGENT_INSTALL_LOCATION_WARNING, null);
            this.setPageComplete(false);
            return;
        }
        status.add(setInstallLocationStatus);
        IStatus validationStatus = this.validateCurrentAgentDirectory();
        if (StatusUtil.isErrorOrCancel((IStatus)validationStatus)) {
            this.setErrorStateWithStatus(AGENT_INSTALL_LOCATION_ERROR, validationStatus);
            this.setWarningState(AGENT_INSTALL_LOCATION_WARNING, null);
            this.setPageComplete(false);
            return;
        }
        status.add(validationStatus);
        if (status.getSeverity() == 2) {
            IStatus[] children = status.getChildren();
            if (children != null && children.length == 1) {
                this.setWarningStateWithStatus(AGENT_INSTALL_LOCATION_WARNING, children[0]);
            } else {
                this.setWarningStateWithStatus(AGENT_INSTALL_LOCATION_WARNING, (IStatus)status);
            }
        } else {
            this.setWarningState(AGENT_INSTALL_LOCATION_WARNING, null);
        }
        this.setErrorStateWithStatus(AGENT_INSTALL_LOCATION_ERROR, null);
        this.setPageComplete(true);
        this.showDiskSpaceInfo();
    }

    private IStatus validateSpaceSizeInfo(List selectedJobs) {
        if (selectedJobs == null || selectedJobs.size() != 1) {
            return new Status(4, "com.ibm.cic.agent.ui", 0, Messages.AgentInstallLocationPage_invalidJobs, null);
        }
        if (this.agentProfile != null && this.agentProfile.getInstallLocation() != null && this.installAgentJobSizeInfo != null) {
            long availableSpace;
            String agentInstallLocation = this.agentProfile.getInstallLocation();
            long maxSize = this.installAgentJobSizeInfo.getMaxSize();
            if (maxSize > (availableSpace = SpaceInfoUtils.getAvailableSpaceInLong((String)agentInstallLocation))) {
                String errorMsg = NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.FeatureSelectionPage_invalidAvailableDiskSpace, (Object)PlatformUtils.getLocationDevice((String)agentInstallLocation));
                return new Status(4, "com.ibm.cic.agent.ui", 0, errorMsg, null);
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus setAgentInstallLocation(String location) {
        String oldLocation = this.agentProfile.getInstallLocation();
        if (location.equals(oldLocation)) {
            return Status.OK_STATUS;
        }
        IStatus status = this.agentProfile.setInstallLocation(location);
        if (status.isOK() || status.getSeverity() == 2) {
            this.agentProfile.setNeedsRequalification();
            Profile.setLicenseProfileInstallLocation((Profile)this.agentProfile);
        }
        return status;
    }

    private IStatus validateCurrentAgentDirectory() {
        CicMultiStatus return_status = Statuses.ST.createMultiStatus(com.ibm.cic.common.core.utils.Messages.MultipleWarnings, new Object[0]);
        IStatus status = AgentUtil.validateJobsInstallLocation((List)this.getSelectedAgentJobs());
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        return_status.add(status);
        status = AgentUtil.getOfferingsApplicability((List)this.getSelectedAgentJobs());
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        return_status.add(status);
        status = AgentUtil.validateVistaVirtualizationLocation((List)this.getSelectedAgentJobs(), (IOffering[])new IOffering[]{this.agentOffering});
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        return_status.add(status);
        status = this.validateSpaceSizeInfo(this.getSelectedAgentJobs());
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        return_status.add(status);
        return StatusUtil.toSingleStatus((IStatus)return_status);
    }

    private boolean isWizardReady() {
        return this.getWizard().getContainer().getCurrentPage() != null;
    }

    @Override
    protected void setFocus() {
        String initialLocation = "";
        if (this.agentLocationText != null) {
            initialLocation = this.agentLocationText.getText().trim();
        }
        this.checkInitialAgentLocation(initialLocation);
        this.showDiskSpaceInfo();
    }

    protected void showDiskSpaceInfo() {
        this.diskspaceTable.removeAll();
        TableItem tableItem = new TableItem(this.diskspaceTable, 0);
        tableItem.setText(new String[]{Messages.InstallLocationDetailsPage_spaceTable_volumeName, Messages.InstallLocationDetailsPage_spaceTable_availableSpace});
        int width1 = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, Messages.InstallLocationDetailsPage_spaceTable_volumeName);
        int width2 = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, Messages.InstallLocationDetailsPage_spaceTable_availableSpace);
        String volumeName = PlatformUtils.getLocationDevice((String)this.agentProfile.getInstallLocation());
        String availableSpace = SpaceInfoUtils.getAvailableSpace((String)volumeName);
        TableItem item = new TableItem(this.diskspaceTable, 0);
        item.setText(new String[]{volumeName, availableSpace});
        int width = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, volumeName);
        width1 = Math.max(width1, width);
        width = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, availableSpace);
        width2 = Math.max(width2, width);
        GridData data = (GridData)this.diskspaceTable.getLayoutData();
        data.heightHint = this.diskspaceTable.getItemHeight() * 2;
        TableColumn col1 = this.diskspaceTable.getColumn(0);
        col1.setWidth(width1);
        TableColumn col2 = this.diskspaceTable.getColumn(1);
        col2.setWidth(width2);
        this.diskspaceTable.redraw();
    }

    public boolean shouldSkip() {
        return InstallAgentUtils.hasAgentInstalled();
    }

    private List getSelectedAgentJobs() {
        List jobs = this.getSelectedJobs();
        if (jobs == null || jobs.size() == 0) {
            return null;
        }
        Agent agent = AgentUI.getDefault().getAgent();
        int i = 0;
        while (i < jobs.size()) {
            AbstractJob job = (AbstractJob)jobs.get(i);
            IOffering offering = job.getOffering();
            if (offering != null && agent.isAgentOffering((IOfferingOrFix)offering)) {
                ArrayList<AbstractJob> result = new ArrayList<AbstractJob>(1);
                result.add(job);
                return result;
            }
            ++i;
        }
        return null;
    }
}

