/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class JobFeatureContentProvider
extends ArrayContentProvider
implements ITreeContentProvider {
    private Object[] input;
    private final Map jobToChildrenMap = new HashMap();
    private boolean showFeature = true;
    private boolean hasFix = false;
    private ITreeContentProvider featureTreeContentProvider;
    private Map jobToRootFeatureGroupMap;

    public JobFeatureContentProvider() {
    }

    public JobFeatureContentProvider(boolean showFeature) {
        this.showFeature = showFeature;
    }

    public JobFeatureContentProvider(ITreeContentProvider provider, Map map) {
        this.featureTreeContentProvider = provider;
        this.jobToRootFeatureGroupMap = map;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof AbstractJob) {
            Object[] children = (Object[])this.jobToChildrenMap.get(parentElement);
            if (children == null) {
                ArrayList<Object> childrenList = new ArrayList<Object>();
                IOffering offering = ((AbstractJob)parentElement).getOffering();
                if (offering != null) {
                    if (this.showFeature) {
                        if (this.jobToRootFeatureGroupMap != null && this.featureTreeContentProvider != null) {
                            if (this.hasFix) {
                                Object[] valueArray = (Object[])this.jobToRootFeatureGroupMap.get(parentElement);
                                if (valueArray != null) {
                                    childrenList.addAll(Arrays.asList(valueArray));
                                }
                            } else {
                                childrenList.addAll(Arrays.asList(this.featureTreeContentProvider.getChildren(parentElement)));
                            }
                        } else {
                            List selectedFeatures = ((AgentJob)parentElement).getFeatures();
                            ArrayList<IFeature> visibleSelectedFeatures = new ArrayList<IFeature>();
                            int i = 0;
                            while (i < selectedFeatures.size()) {
                                IFeature feature = (IFeature)selectedFeatures.get(i);
                                if (feature.isVisible()) {
                                    visibleSelectedFeatures.add(feature);
                                }
                                ++i;
                            }
                            childrenList.addAll(visibleSelectedFeatures);
                        }
                    }
                    if (this.input != null && this.input.length > 0) {
                        Object[] objectArray = this.input;
                        int n = this.input.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFix fix;
                            Object element = objectArray[n2];
                            if (element instanceof AbstractJob && (fix = ((AbstractJob)element).getFix()) != null && FixUtil.isFixApplicable((IFix)fix, (IOffering)offering)) {
                                childrenList.add(element);
                            }
                            ++n2;
                        }
                    }
                }
                children = childrenList.toArray(new Object[childrenList.size()]);
                this.jobToChildrenMap.put(parentElement, children);
            }
            return children;
        }
        if (this.featureTreeContentProvider != null) {
            return this.featureTreeContentProvider.getChildren(parentElement);
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        this.input = (Object[])inputElement;
        ArrayList<Object> roots = new ArrayList<Object>();
        if (inputElement != null && inputElement instanceof Object[]) {
            Object element;
            Object[] inputArray;
            ArrayList<IOffering> offeringList = new ArrayList<IOffering>();
            Object[] objectArray = inputArray = (Object[])inputElement;
            int n = inputArray.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering offering;
                element = objectArray[n2];
                if (element instanceof AbstractJob && (offering = ((AbstractJob)element).getOffering()) != null) {
                    roots.add(element);
                    offeringList.add(offering);
                }
                ++n2;
            }
            objectArray = inputArray;
            n = inputArray.length;
            n2 = 0;
            while (n2 < n) {
                IFix fix;
                element = objectArray[n2];
                if (element instanceof AbstractJob && (fix = ((AbstractJob)element).getFix()) != null) {
                    this.hasFix = true;
                    boolean fixAppliesToOffering = false;
                    int j = 0;
                    while (j < offeringList.size()) {
                        IOffering offering = (IOffering)offeringList.get(j);
                        if (FixUtil.isFixApplicable((IFix)fix, (IOffering)offering)) {
                            fixAppliesToOffering = true;
                            break;
                        }
                        ++j;
                    }
                    if (!fixAppliesToOffering) {
                        roots.add(element);
                    }
                }
                ++n2;
            }
        }
        return roots.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void setShowFeature(boolean showFeature) {
        this.showFeature = showFeature;
    }

    public void clearJobToChildrenMap() {
        this.jobToChildrenMap.clear();
    }
}

