/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.Messages;
import com.ibm.cic.agent.internal.ui.utils.ConfigurationCustomPanelNode;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationOfferingNode {
    private String nodeLabel;
    private final AgentJob job;
    private IOffering offering;
    private Profile profile;
    private final List children = new ArrayList();
    private ConfigurationOfferingNode previousOfferingNode;
    private ConfigurationOfferingNode nextOfferingNode;

    public ConfigurationOfferingNode(AgentJob job) {
        this.job = job;
        if (job != null) {
            this.offering = job.getOffering();
            this.profile = job.getProfile();
            this.nodeLabel = this.offering != null ? OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)this.offering, (boolean)false) : "No Offering";
        } else {
            this.nodeLabel = Messages.SingleConfigurationPage_allPackages;
        }
    }

    public List getChildren() {
        return this.children;
    }

    public void addChildren(ConfigurationCustomPanelNode child) {
        if (this.children.isEmpty()) {
            this.children.add(child);
        } else if (!this.children.contains(child)) {
            ConfigurationCustomPanelNode lastNode = (ConfigurationCustomPanelNode)this.children.get(this.children.size() - 1);
            lastNode.setNextNode(child);
            child.setPreviousNode(lastNode);
            this.children.add(child);
        }
    }

    public AgentJob getJob() {
        return this.job;
    }

    public IOffering getOffering() {
        return this.offering;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public String toString() {
        return this.nodeLabel;
    }

    public ConfigurationOfferingNode getPreviousOfferingNode() {
        return this.previousOfferingNode;
    }

    public void setPreviousOfferingNode(ConfigurationOfferingNode previousOfferingNode) {
        this.previousOfferingNode = previousOfferingNode;
    }

    public ConfigurationOfferingNode getNextOfferingNode() {
        return this.nextOfferingNode;
    }

    public void setNextOfferingNode(ConfigurationOfferingNode nextOfferingNode) {
        this.nextOfferingNode = nextOfferingNode;
    }
}

