/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.preferences;

import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.downloads.CredentialStore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class EfdPassportAdvantagePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREFERENCE_DLG_SETTINGS = "com.ibm.cic.agent.ui.preferenceDlg.settings";
    private Button connectPWA;
    private Button clearCredentials;

    public EfdPassportAdvantagePage() {
        this.setPreferenceStore(AgentUI.getDefault().getAgentPreferenceStore());
    }

    public void createControl(Composite parent) {
        Button restoreDefaultButton;
        super.createControl(parent);
        if (!SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ICicPreferenceConstants.PASSPORT_ADVANTAGE_ENABLED) && (restoreDefaultButton = this.getDefaultsButton()) != null) {
            restoreDefaultButton.setEnabled(false);
        }
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cic.agent.ui.PassportAdvantagePage");
        this.initializeDialogUnits((Control)parent);
        Font font = parent.getFont();
        Composite rootComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        rootComposite.setLayout((Layout)layout);
        rootComposite.setLayoutData((Object)new GridData(1808));
        Composite buttonContainer = new Composite(rootComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        buttonContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.connectPWA = new Button(buttonContainer, 32);
        this.connectPWA.setText(Messages.PreferencePage_PPA_connectButton);
        this.connectPWA.setFont(font);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.connectPWA.setLayoutData((Object)gridData);
        this.connectPWA.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EfdPassportAdvantagePage.this.connectPWA.getSelection()) {
                    AgentUI.getDefault().getAgent().resetPassportAdvantageRepository();
                }
            }
        });
        this.clearCredentials = new Button(buttonContainer, 8);
        this.clearCredentials.setFont(font);
        this.clearCredentials.setText(com.ibm.cic.common.ui.internal.Messages.AgentProperties_RepositoriesPrefs_button_credentials);
        GridData gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.verticalAlignment = 1;
        this.clearCredentials.setLayoutData((Object)gd);
        this.clearCredentials.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean answer = MessageDialog.openConfirm((Shell)EfdPassportAdvantagePage.this.clearCredentials.getShell(), (String)com.ibm.cic.common.ui.internal.Messages.ClearCredentialDlgTitle, (String)com.ibm.cic.common.core.sharedUI.Messages.ClearCredentialDlgMsg);
                if (answer) {
                    CredentialStore.INSTANCE.removeAllCredentials();
                }
                EfdPassportAdvantagePage.this.clearCredentials.setEnabled(CredentialStore.INSTANCE.isAnyCredentialSaved());
            }
        });
        boolean enablePPA = this.getPreferenceStore().getBoolean(ICicPreferenceConstants.PASSPORT_ADVANTAGE_ENABLED.key());
        this.loadValues(enablePPA, false);
        if (!SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ICicPreferenceConstants.PASSPORT_ADVANTAGE_ENABLED)) {
            this.connectPWA.setEnabled(false);
        }
        return rootComposite;
    }

    private void loadValues(boolean enablePPA, boolean forceRefresh) {
        this.connectPWA.setSelection(enablePPA);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.clearCredentials.setEnabled(CredentialStore.INSTANCE.isAnyCredentialSaved());
        }
    }

    public boolean performOk() {
        boolean enablePPA = this.connectPWA.getSelection();
        this.getPreferenceStore().setValue(ICicPreferenceConstants.PASSPORT_ADVANTAGE_ENABLED.key(), enablePPA);
        AgentUI.getDefault().getAgent().addOrRemovePPA(enablePPA);
        return true;
    }

    protected void performDefaults() {
        boolean enablePPADefault = this.getPreferenceStore().getDefaultBoolean(ICicPreferenceConstants.PASSPORT_ADVANTAGE_ENABLED.key());
        this.connectPWA.setSelection(enablePPADefault);
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }
}

